/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.function.udaf.KudafAggregator;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.StreamAggregate;
import io.confluent.ksql.execution.plan.StreamWindowedAggregate;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.AggregateBuilderUtils;
import io.confluent.ksql.execution.streams.AggregateParams;
import io.confluent.ksql.execution.streams.AggregateParamsFactory;
import io.confluent.ksql.execution.streams.MaterializationUtil;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.execution.streams.transform.KsValueTransformer;
import io.confluent.ksql.execution.transform.KsqlProcessingContext;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.execution.windows.HoppingWindowExpression;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.SessionWindowExpression;
import io.confluent.ksql.execution.windows.TumblingWindowExpression;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.execution.windows.WindowVisitor;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.WindowInfo;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.TimeWindowedKStream;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;

public final class StreamAggregateBuilder {
    private StreamAggregateBuilder() {
    }

    public static KTableHolder<GenericKey> build(KGroupedStreamHolder groupedStream, StreamAggregate aggregate, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory) {
        return StreamAggregateBuilder.build(groupedStream, aggregate, buildContext, materializedFactory, new AggregateParamsFactory());
    }

    static KTableHolder<GenericKey> build(KGroupedStreamHolder groupedStream, StreamAggregate aggregate, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory, AggregateParamsFactory aggregateParamsFactory) {
        LogicalSchema sourceSchema = groupedStream.getSchema();
        List nonFuncColumns = aggregate.getNonAggregateColumns();
        AggregateParams aggregateParams = aggregateParamsFactory.create(sourceSchema, nonFuncColumns, buildContext.getFunctionRegistry(), aggregate.getAggregationFunctions(), false, buildContext.getKsqlConfig());
        LogicalSchema aggregateSchema = aggregateParams.getAggregateSchema();
        LogicalSchema resultSchema = aggregateParams.getSchema();
        Materialized materialized = MaterializationUtil.buildMaterialized(aggregate, aggregateSchema, aggregate.getInternalFormats(), buildContext, materializedFactory, ExecutionKeyFactory.unwindowed((RuntimeBuildContext)buildContext));
        KudafAggregator aggregator = aggregateParams.getAggregator();
        KTable aggregated = groupedStream.getGroupedStream().aggregate((Initializer)aggregateParams.getInitializer(), aggregateParams.getAggregator(), materialized);
        MaterializationInfo.Builder materializationBuilder = AggregateBuilderUtils.materializationInfoBuilder(aggregateParams.getAggregator(), aggregate, aggregateSchema, resultSchema);
        KTable result = aggregated.transformValues(() -> new KsValueTransformer(aggregator.getResultMapper()), Named.as((String)StreamsUtil.buildOpName(AggregateBuilderUtils.outputContext(aggregate))), new String[0]);
        return KTableHolder.materialized((KTable)result, (LogicalSchema)resultSchema, (ExecutionKeyFactory)ExecutionKeyFactory.unwindowed((RuntimeBuildContext)buildContext), (MaterializationInfo.Builder)materializationBuilder);
    }

    public static KTableHolder<Windowed<GenericKey>> build(KGroupedStreamHolder groupedStream, StreamWindowedAggregate aggregate, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory) {
        return StreamAggregateBuilder.build(groupedStream, aggregate, buildContext, materializedFactory, new AggregateParamsFactory());
    }

    static KTableHolder<Windowed<GenericKey>> build(KGroupedStreamHolder groupedStream, StreamWindowedAggregate aggregate, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory, AggregateParamsFactory aggregateParamsFactory) {
        LogicalSchema sourceSchema = groupedStream.getSchema();
        List nonFuncColumns = aggregate.getNonAggregateColumns();
        AggregateParams aggregateParams = aggregateParamsFactory.create(sourceSchema, nonFuncColumns, buildContext.getFunctionRegistry(), aggregate.getAggregationFunctions(), true, buildContext.getKsqlConfig());
        LogicalSchema aggregateSchema = aggregateParams.getAggregateSchema();
        LogicalSchema resultSchema = aggregateParams.getSchema();
        KsqlWindowExpression ksqlWindowExpression = aggregate.getWindowExpression();
        KTable aggregated = (KTable)ksqlWindowExpression.accept((WindowVisitor)new WindowedAggregator((KGroupedStream<GenericKey, GenericRow>)groupedStream.getGroupedStream(), aggregate, aggregateSchema, buildContext, materializedFactory, aggregateParams), null);
        KudafAggregator aggregator = aggregateParams.getAggregator();
        KTable reduced = aggregated.transformValues(() -> new KsValueTransformer(aggregator.getResultMapper()), Named.as((String)StreamsUtil.buildOpName(AggregateBuilderUtils.outputContext(aggregate))), new String[0]);
        MaterializationInfo.Builder materializationBuilder = AggregateBuilderUtils.materializationInfoBuilder(aggregateParams.getAggregator(), aggregate, aggregateSchema, resultSchema);
        reduced = reduced.transformValues(() -> new KsValueTransformer<Windowed<GenericKey>, GenericRow>(new WindowBoundsPopulator()), Named.as((String)StreamsUtil.buildOpName(AggregateBuilderUtils.windowSelectContext(aggregate))), new String[0]);
        materializationBuilder.map(pl -> new WindowBoundsPopulator(), resultSchema, AggregateBuilderUtils.windowSelectContext(aggregate));
        return KTableHolder.materialized((KTable)reduced, (LogicalSchema)resultSchema, (ExecutionKeyFactory)ExecutionKeyFactory.windowed((RuntimeBuildContext)buildContext, (WindowInfo)ksqlWindowExpression.getWindowInfo()), (MaterializationInfo.Builder)materializationBuilder);
    }

    private static final class WindowBoundsPopulator
    implements KsqlTransformer<Windowed<GenericKey>, GenericRow> {
        private WindowBoundsPopulator() {
        }

        public GenericRow transform(Windowed<GenericKey> readOnlyKey, GenericRow value, KsqlProcessingContext ctx) {
            if (value == null) {
                return null;
            }
            Window window = readOnlyKey.window();
            value.ensureAdditionalCapacity(2);
            value.append((Object)window.start());
            value.append((Object)window.end());
            return value;
        }
    }

    private static class WindowedAggregator
    implements WindowVisitor<KTable<Windowed<GenericKey>, GenericRow>, Void> {
        final QueryContext queryContext;
        final Formats formats;
        final KGroupedStream<GenericKey, GenericRow> groupedStream;
        final RuntimeBuildContext buildContext;
        final MaterializedFactory materializedFactory;
        final Serde<GenericKey> keySerde;
        final Serde<GenericRow> valueSerde;
        final AggregateParams aggregateParams;

        WindowedAggregator(KGroupedStream<GenericKey, GenericRow> groupedStream, StreamWindowedAggregate aggregate, LogicalSchema aggregateSchema, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory, AggregateParams aggregateParams) {
            Objects.requireNonNull(aggregate, "aggregate");
            this.groupedStream = Objects.requireNonNull(groupedStream, "groupedStream");
            this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
            this.materializedFactory = Objects.requireNonNull(materializedFactory, "materializedFactory");
            this.aggregateParams = Objects.requireNonNull(aggregateParams, "aggregateParams");
            this.queryContext = MaterializationUtil.materializeContext(aggregate);
            this.formats = aggregate.getInternalFormats();
            PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)aggregateSchema, (SerdeFeatures)this.formats.getKeyFeatures(), (SerdeFeatures)this.formats.getValueFeatures());
            this.keySerde = buildContext.buildKeySerde(this.formats.getKeyFormat(), physicalSchema, this.queryContext);
            this.valueSerde = buildContext.buildValueSerde(this.formats.getValueFormat(), physicalSchema, this.queryContext);
        }

        public KTable<Windowed<GenericKey>, GenericRow> visitHoppingWindowExpression(HoppingWindowExpression window, Void ctx) {
            TimeWindows windows = TimeWindows.of((Duration)window.getSize().toDuration()).advanceBy(window.getAdvanceBy().toDuration());
            windows = window.getGracePeriod().map(WindowTimeClause::toDuration).map(arg_0 -> ((TimeWindows)windows).grace(arg_0)).orElse(windows);
            TimeWindowedKStream timeWindowedKStream = this.groupedStream.windowedBy((Windows)windows);
            if (window.getEmitStrategy().isPresent() && window.getEmitStrategy().get() == OutputRefinement.FINAL) {
                timeWindowedKStream = timeWindowedKStream.emitStrategy(EmitStrategy.onWindowClose());
            }
            return timeWindowedKStream.aggregate((Initializer)this.aggregateParams.getInitializer(), this.aggregateParams.getAggregator(), this.materializedFactory.create(this.keySerde, this.valueSerde, StreamsUtil.buildOpName(this.queryContext), window.getRetention().map(WindowTimeClause::toDuration)));
        }

        public KTable<Windowed<GenericKey>, GenericRow> visitSessionWindowExpression(SessionWindowExpression window, Void ctx) {
            SessionWindows windows = SessionWindows.with((Duration)window.getGap().toDuration());
            windows = window.getGracePeriod().map(WindowTimeClause::toDuration).map(arg_0 -> ((SessionWindows)windows).grace(arg_0)).orElse(windows);
            SessionWindowedKStream sessionWindowedKStream = this.groupedStream.windowedBy(windows);
            if (window.getEmitStrategy().isPresent() && window.getEmitStrategy().get() == OutputRefinement.FINAL) {
                sessionWindowedKStream = sessionWindowedKStream.emitStrategy(EmitStrategy.onWindowClose());
            }
            return sessionWindowedKStream.aggregate((Initializer)this.aggregateParams.getInitializer(), this.aggregateParams.getAggregator(), this.aggregateParams.getAggregator().getMerger(), this.materializedFactory.create(this.keySerde, this.valueSerde, StreamsUtil.buildOpName(this.queryContext), window.getRetention().map(WindowTimeClause::toDuration)));
        }

        public KTable<Windowed<GenericKey>, GenericRow> visitTumblingWindowExpression(TumblingWindowExpression window, Void ctx) {
            TimeWindows windows = TimeWindows.of((Duration)window.getSize().toDuration());
            windows = window.getGracePeriod().map(WindowTimeClause::toDuration).map(arg_0 -> ((TimeWindows)windows).grace(arg_0)).orElse(windows);
            TimeWindowedKStream timeWindowedKStream = this.groupedStream.windowedBy((Windows)windows);
            if (window.getEmitStrategy().isPresent() && window.getEmitStrategy().get() == OutputRefinement.FINAL) {
                timeWindowedKStream = timeWindowedKStream.emitStrategy(EmitStrategy.onWindowClose());
            }
            return timeWindowedKStream.aggregate((Initializer)this.aggregateParams.getInitializer(), this.aggregateParams.getAggregator(), this.materializedFactory.create(this.keySerde, this.valueSerde, StreamsUtil.buildOpName(this.queryContext), window.getRetention().map(WindowTimeClause::toDuration)));
        }
    }
}

