/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedTableHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.GroupByParams;
import io.confluent.ksql.execution.streams.GroupedFactory;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;

class TableGroupByBuilderBase {
    private final RuntimeBuildContext buildContext;
    private final GroupedFactory groupedFactory;
    private final ParamsFactory paramsFactory;

    TableGroupByBuilderBase(RuntimeBuildContext buildContext, GroupedFactory groupedFactory, ParamsFactory paramsFactory) {
        this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
        this.groupedFactory = Objects.requireNonNull(groupedFactory, "groupedFactory");
        this.paramsFactory = Objects.requireNonNull(paramsFactory, "paramsFactory");
    }

    public <K> KGroupedTableHolder build(KTableHolder<K> table, QueryContext queryContext, Formats formats, List<Expression> groupByExpressions) {
        LogicalSchema sourceSchema = table.getSchema();
        List groupBy = CodeGenRunner.compileExpressions(groupByExpressions.stream(), (String)"Group By", (LogicalSchema)sourceSchema, (KsqlConfig)this.buildContext.getKsqlConfig(), (FunctionRegistry)this.buildContext.getFunctionRegistry());
        ProcessingLogger logger = this.buildContext.getProcessingLogger(queryContext);
        GroupByParams params = this.paramsFactory.build(sourceSchema, groupBy, logger);
        PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)params.getSchema(), (SerdeFeatures)formats.getKeyFeatures(), (SerdeFeatures)formats.getValueFeatures());
        Serde keySerde = this.buildContext.buildKeySerde(formats.getKeyFormat(), physicalSchema, queryContext);
        Serde valSerde = this.buildContext.buildValueSerde(formats.getValueFormat(), physicalSchema, queryContext);
        Grouped grouped = this.groupedFactory.create(StreamsUtil.buildOpName(queryContext), keySerde, valSerde);
        KGroupedTable groupedTable = table.getTable().filter((k, v) -> v != null).groupBy(new TableKeyValueMapper(params.getMapper()), grouped);
        return KGroupedTableHolder.of((KGroupedTable)groupedTable, (LogicalSchema)params.getSchema());
    }

    static interface ParamsFactory {
        public GroupByParams build(LogicalSchema var1, List<CompiledExpression> var2, ProcessingLogger var3);
    }

    public static final class TableKeyValueMapper<K>
    implements KeyValueMapper<K, GenericRow, KeyValue<GenericKey, GenericRow>> {
        private final Function<GenericRow, GenericKey> groupByMapper;

        private TableKeyValueMapper(Function<GenericRow, GenericKey> groupByMapper) {
            this.groupByMapper = Objects.requireNonNull(groupByMapper, "groupByMapper");
        }

        public KeyValue<GenericKey, GenericRow> apply(K key, GenericRow value) {
            return new KeyValue((Object)this.groupByMapper.apply(value), (Object)value);
        }
    }
}

