/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.streams.JoinParams;
import io.confluent.ksql.execution.streams.JoinParamsFactory;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.ValueJoiner;

public final class TableTableJoinBuilder {
    private TableTableJoinBuilder() {
    }

    public static <K> KTableHolder<K> build(KTableHolder<K> left, KTableHolder<K> right, TableTableJoin<K> join) {
        KTable result;
        LogicalSchema rightSchema;
        LogicalSchema leftSchema;
        if (join.getJoinType().equals((Object)JoinType.RIGHT)) {
            leftSchema = right.getSchema();
            rightSchema = left.getSchema();
        } else {
            leftSchema = left.getSchema();
            rightSchema = right.getSchema();
        }
        JoinParams joinParams = JoinParamsFactory.create(join.getKeyColName(), leftSchema, rightSchema);
        switch (join.getJoinType()) {
            case INNER: {
                result = left.getTable().join(right.getTable(), (ValueJoiner)joinParams.getJoiner());
                break;
            }
            case LEFT: {
                result = left.getTable().leftJoin(right.getTable(), (ValueJoiner)joinParams.getJoiner());
                break;
            }
            case RIGHT: {
                result = right.getTable().leftJoin(left.getTable(), (ValueJoiner)joinParams.getJoiner());
                break;
            }
            case OUTER: {
                result = left.getTable().outerJoin(right.getTable(), (ValueJoiner)joinParams.getJoiner());
                break;
            }
            default: {
                throw new IllegalStateException("invalid join type: " + join.getJoinType());
            }
        }
        return KTableHolder.unmaterialized((KTable)result, (LogicalSchema)joinParams.getSchema(), (ExecutionKeyFactory)left.getExecutionKeyFactory());
    }
}

