/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.context.QueryLoggerUtil;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.streams.materialization.KsqlMaterialization;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterialization;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class KsqlMaterializationFactory {
    private final ProcessingLogContext processingLogContext;
    private final MaterializationFactory materializationFactory;

    public KsqlMaterializationFactory(ProcessingLogContext processingLogContext) {
        this(processingLogContext, KsqlMaterialization::new);
    }

    @VisibleForTesting
    KsqlMaterializationFactory(ProcessingLogContext processingLogContext, MaterializationFactory materializationFactory) {
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.materializationFactory = Objects.requireNonNull(materializationFactory, "materializationFactory");
    }

    public Materialization create(StreamsMaterialization delegate, MaterializationInfo info, QueryId queryId, QueryContext.Stacker contextStacker) {
        TransformVisitor transformVisitor = new TransformVisitor(queryId, contextStacker);
        List<KsqlMaterialization.Transform> transforms = info.getTransforms().stream().map(xform -> (KsqlMaterialization.Transform)xform.visit((MaterializationInfo.TransformVisitor)transformVisitor)).collect(Collectors.toList());
        return this.materializationFactory.create(delegate, info.getSchema(), transforms);
    }

    private class TransformVisitor
    implements MaterializationInfo.TransformVisitor<KsqlMaterialization.Transform> {
        private final QueryId queryId;
        private final QueryContext.Stacker stacker;

        TransformVisitor(QueryId queryId, QueryContext.Stacker stacker) {
            this.queryId = Objects.requireNonNull(queryId, "queryId");
            this.stacker = Objects.requireNonNull(stacker, "stacker");
        }

        public KsqlMaterialization.Transform visit(MaterializationInfo.MapperInfo info) {
            KsqlTransformer resultMapper = info.getMapper(this::getLogger);
            return (k, v, ctx) -> Optional.of(resultMapper.transform(k, v, ctx));
        }

        public KsqlMaterialization.Transform visit(MaterializationInfo.PredicateInfo info) {
            KsqlTransformer predicate = info.getPredicate(this::getLogger);
            return (arg_0, arg_1, arg_2) -> ((KsqlTransformer)predicate).transform(arg_0, arg_1, arg_2);
        }

        private ProcessingLogger getLogger(QueryContext queryContext) {
            QueryContext.Stacker stacker = this.stacker;
            for (String ctx : queryContext.getContext()) {
                stacker = stacker.push(new String[]{ctx});
            }
            return KsqlMaterializationFactory.this.processingLogContext.getLoggerFactory().getLogger(QueryLoggerUtil.queryLoggerName((QueryLoggerUtil.QueryType)QueryLoggerUtil.QueryType.PULL_QUERY, (QueryContext)stacker.getQueryContext()));
        }
    }

    static interface MaterializationFactory {
        public KsqlMaterialization create(StreamsMaterialization var1, LogicalSchema var2, List<KsqlMaterialization.Transform> var3);
    }
}

