/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.materialization.MaterializationException;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedWindowedTable;
import io.confluent.ksql.execution.streams.materialization.WindowedRow;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedQueryResult;
import io.confluent.ksql.execution.streams.materialization.ks.KsStateStore;
import io.confluent.ksql.execution.streams.materialization.ks.NotUpToBoundException;
import io.confluent.ksql.util.IteratorUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.StateQueryRequest;
import org.apache.kafka.streams.query.StateQueryResult;
import org.apache.kafka.streams.query.WindowKeyQuery;
import org.apache.kafka.streams.query.WindowRangeQuery;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStoreIterator;

class KsMaterializedWindowTableIQv2
implements StreamsMaterializedWindowedTable {
    private final KsStateStore stateStore;
    private final Duration windowSize;

    KsMaterializedWindowTableIQv2(KsStateStore store, Duration windowSize) {
        this.stateStore = Objects.requireNonNull(store, "store");
        this.windowSize = Objects.requireNonNull(windowSize, "windowSize");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KsMaterializedQueryResult<WindowedRow> get(GenericKey key, int partition, Range<Instant> windowStartBounds, Range<Instant> windowEndBounds, Optional<Position> position) {
        try {
            KafkaStreams streams;
            StateQueryResult result;
            QueryResult queryResult;
            Instant lower = this.calculateLowerBound(windowStartBounds, windowEndBounds);
            Instant upper = this.calculateUpperBound(windowStartBounds, windowEndBounds);
            WindowKeyQuery query = WindowKeyQuery.withKeyAndWindowStartRange((Object)key, (Instant)lower, (Instant)upper);
            StateQueryRequest request = StateQueryRequest.inStore((String)this.stateStore.getStateStoreName()).withQuery((Query)query);
            if (position.isPresent()) {
                request = request.withPositionBound(PositionBound.at((Position)position.get()));
            }
            if ((queryResult = (QueryResult)(result = (streams = this.stateStore.getKafkaStreams()).query(request)).getPartitionResults().get(partition)).isFailure()) {
                throw this.failedQueryException(queryResult);
            }
            if (queryResult.getResult() == null) {
                return KsMaterializedQueryResult.rowIteratorWithPosition(Collections.emptyIterator(), queryResult.getPosition());
            }
            try (WindowStoreIterator it = (WindowStoreIterator)queryResult.getResult();){
                ImmutableList.Builder builder = ImmutableList.builder();
                while (it.hasNext()) {
                    Instant windowEnd;
                    KeyValue next = (KeyValue)it.next();
                    Instant windowStart = Instant.ofEpochMilli((Long)next.key);
                    if (!windowStartBounds.contains((Comparable)windowStart) || !windowEndBounds.contains((Comparable)(windowEnd = windowStart.plus(this.windowSize)))) continue;
                    TimeWindow window = new TimeWindow(windowStart.toEpochMilli(), windowEnd.toEpochMilli());
                    WindowedRow row = WindowedRow.of(this.stateStore.schema(), (Windowed<GenericKey>)new Windowed((Object)key, (Window)window), (GenericRow)((ValueAndTimestamp)next.value).value(), ((ValueAndTimestamp)next.value).timestamp());
                    builder.add((Object)row);
                }
                KsMaterializedQueryResult<WindowedRow> ksMaterializedQueryResult = KsMaterializedQueryResult.rowIteratorWithPosition(builder.build().iterator(), queryResult.getPosition());
                return ksMaterializedQueryResult;
            }
        }
        catch (MaterializationException | NotUpToBoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to get value from materialized table", e);
        }
    }

    @Override
    public KsMaterializedQueryResult<WindowedRow> get(int partition, Range<Instant> windowStartBounds, Range<Instant> windowEndBounds, Optional<Position> position) {
        try {
            StateQueryResult result;
            QueryResult queryResult;
            Instant lower = this.calculateLowerBound(windowStartBounds, windowEndBounds);
            Instant upper = this.calculateUpperBound(windowStartBounds, windowEndBounds);
            WindowRangeQuery query = WindowRangeQuery.withWindowStartRange((Instant)lower, (Instant)upper);
            StateQueryRequest request = StateQueryRequest.inStore((String)this.stateStore.getStateStoreName()).withQuery((Query)query);
            if (position.isPresent()) {
                request = request.withPositionBound(PositionBound.at((Position)position.get()));
            }
            if ((queryResult = (QueryResult)(result = this.stateStore.getKafkaStreams().query(request)).getPartitionResults().get(partition)).isFailure()) {
                throw this.failedQueryException(queryResult);
            }
            KeyValueIterator iterator = (KeyValueIterator)queryResult.getResult();
            return KsMaterializedQueryResult.rowIteratorWithPosition(Streams.stream((Iterator)IteratorUtil.onComplete((Iterator)iterator, () -> ((KeyValueIterator)iterator).close())).map(next -> {
                Instant windowStart = ((Windowed)next.key).window().startTime();
                if (!windowStartBounds.contains((Comparable)windowStart)) {
                    return null;
                }
                Instant windowEnd = ((Windowed)next.key).window().endTime();
                if (!windowEndBounds.contains((Comparable)windowEnd)) {
                    return null;
                }
                TimeWindow window = new TimeWindow(windowStart.toEpochMilli(), windowEnd.toEpochMilli());
                WindowedRow row = WindowedRow.of(this.stateStore.schema(), (Windowed<GenericKey>)new Windowed(((Windowed)next.key).key(), (Window)window), (GenericRow)((ValueAndTimestamp)next.value).value(), ((ValueAndTimestamp)next.value).timestamp());
                return row;
            }).filter(Objects::nonNull).iterator(), queryResult.getPosition());
        }
        catch (MaterializationException | NotUpToBoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to get value from materialized table", e);
        }
    }

    private Instant calculateUpperBound(Range<Instant> windowStartBounds, Range<Instant> windowEndBounds) {
        Instant start = windowStartBounds.hasUpperBound() ? (Instant)windowStartBounds.upperEndpoint() : Instant.ofEpochMilli(Long.MAX_VALUE);
        Instant end = windowEndBounds.hasUpperBound() ? ((Instant)windowEndBounds.upperEndpoint()).minus(this.windowSize) : Instant.ofEpochMilli(Long.MAX_VALUE);
        return start.compareTo(end) < 0 ? start : end;
    }

    private Instant calculateLowerBound(Range<Instant> windowStartBounds, Range<Instant> windowEndBounds) {
        Instant start = windowStartBounds.hasLowerBound() ? (Instant)windowStartBounds.lowerEndpoint() : Instant.ofEpochMilli(0L);
        Instant end = windowEndBounds.hasLowerBound() ? ((Instant)windowEndBounds.lowerEndpoint()).minus(this.windowSize) : Instant.ofEpochMilli(0L);
        return start.compareTo(end) < 0 ? end : start;
    }

    private Exception failedQueryException(QueryResult<?> queryResult) {
        String message = "Failed to get value from materialized table: " + queryResult.getFailureReason() + ": " + queryResult.getFailureMessage();
        if (queryResult.getFailureReason().equals((Object)FailureReason.NOT_UP_TO_BOUND)) {
            return new NotUpToBoundException(message);
        }
        return new MaterializationException(message);
    }
}

