/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import java.lang.reflect.Field;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CompositeReadOnlySessionStore;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public final class SessionStoreCacheBypass {
    private static final Field PROVIDER_FIELD;
    private static final Field STORE_NAME_FIELD;
    private static final Field STORE_TYPE_FIELD;
    static final Field SERDES_FIELD;
    private static final String STORE_UNAVAILABLE_MESSAGE = "State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.";

    private SessionStoreCacheBypass() {
    }

    public static KeyValueIterator<Windowed<GenericKey>, GenericRow> fetch(ReadOnlySessionStore<GenericKey, GenericRow> store, GenericKey key) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlySessionStore<GenericKey, GenericRow>> stores = SessionStoreCacheBypass.getStores(store);
        Function<ReadOnlySessionStore<GenericKey, GenericRow>, KeyValueIterator<Windowed<GenericKey>, GenericRow>> fetchFunc = sessionStore -> SessionStoreCacheBypass.fetchUncached((ReadOnlySessionStore<GenericKey, GenericRow>)sessionStore, key);
        return SessionStoreCacheBypass.findFirstNonEmptyIterator(stores, fetchFunc);
    }

    private static KeyValueIterator<Windowed<GenericKey>, GenericRow> fetchUncached(ReadOnlySessionStore<GenericKey, GenericRow> sessionStore, GenericKey key) {
        if (!(sessionStore instanceof MeteredSessionStore)) {
            throw new IllegalStateException("Expecting a MeteredSessionStore");
        }
        StateSerdes<GenericKey, GenericRow> serdes = SessionStoreCacheBypass.getSerdes(sessionStore);
        Bytes rawKey = Bytes.wrap((byte[])serdes.rawKey((Object)key));
        SessionStore<Bytes, byte[]> wrapped = SessionStoreCacheBypass.getInnermostStore(sessionStore);
        KeyValueIterator fetch = wrapped.fetch((Object)rawKey);
        return new DeserializingIterator(fetch, serdes);
    }

    public static KeyValueIterator<Windowed<GenericKey>, GenericRow> fetchRange(ReadOnlySessionStore<GenericKey, GenericRow> store, GenericKey keyFrom, GenericKey keyTo) {
        Objects.requireNonNull(keyFrom, "lower key can't be null");
        Objects.requireNonNull(keyTo, "upper key can't be null");
        List<ReadOnlySessionStore<GenericKey, GenericRow>> stores = SessionStoreCacheBypass.getStores(store);
        Function<ReadOnlySessionStore<GenericKey, GenericRow>, KeyValueIterator<Windowed<GenericKey>, GenericRow>> fetchFunc = sessionStore -> SessionStoreCacheBypass.fetchRangeUncached((ReadOnlySessionStore<GenericKey, GenericRow>)sessionStore, keyFrom, keyTo);
        return SessionStoreCacheBypass.findFirstNonEmptyIterator(stores, fetchFunc);
    }

    private static KeyValueIterator<Windowed<GenericKey>, GenericRow> fetchRangeUncached(ReadOnlySessionStore<GenericKey, GenericRow> sessionStore, GenericKey keyFrom, GenericKey keyTo) {
        if (!(sessionStore instanceof MeteredSessionStore)) {
            throw new IllegalStateException("Expecting a MeteredSessionStore");
        }
        StateSerdes<GenericKey, GenericRow> serdes = SessionStoreCacheBypass.getSerdes(sessionStore);
        Bytes rawKeyFrom = Bytes.wrap((byte[])serdes.rawKey((Object)keyFrom));
        Bytes rawKeyTo = Bytes.wrap((byte[])serdes.rawKey((Object)keyTo));
        SessionStore<Bytes, byte[]> wrapped = SessionStoreCacheBypass.getInnermostStore(sessionStore);
        KeyValueIterator fetch = wrapped.fetch((Object)rawKeyFrom, (Object)rawKeyTo);
        return new DeserializingIterator(fetch, serdes);
    }

    private static KeyValueIterator<Windowed<GenericKey>, GenericRow> findFirstNonEmptyIterator(List<ReadOnlySessionStore<GenericKey, GenericRow>> stores, Function<ReadOnlySessionStore<GenericKey, GenericRow>, KeyValueIterator<Windowed<GenericKey>, GenericRow>> fetchFunc) {
        for (ReadOnlySessionStore<GenericKey, GenericRow> sessionStore : stores) {
            try {
                KeyValueIterator<Windowed<GenericKey>, GenericRow> result = fetchFunc.apply(sessionStore);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException(STORE_UNAVAILABLE_MESSAGE, (Throwable)e);
            }
        }
        return new EmptyKeyValueIterator();
    }

    private static StateSerdes<GenericKey, GenericRow> getSerdes(ReadOnlySessionStore<GenericKey, GenericRow> sessionStore) throws RuntimeException {
        try {
            return (StateSerdes)SERDES_FIELD.get(sessionStore);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Stream internals changed unexpectedly!", e);
        }
    }

    private static SessionStore<Bytes, byte[]> getInnermostStore(ReadOnlySessionStore<GenericKey, GenericRow> sessionStore) {
        StateStore store;
        SessionStore wrapped = (SessionStore)((MeteredSessionStore)sessionStore).wrapped();
        while (wrapped instanceof WrappedStateStore && (store = ((WrappedStateStore)wrapped).wrapped()) instanceof SessionStore) {
            wrapped = (SessionStore)store;
        }
        return wrapped;
    }

    private static List<ReadOnlySessionStore<GenericKey, GenericRow>> getStores(ReadOnlySessionStore<GenericKey, GenericRow> store) {
        try {
            StateStoreProvider provider = (StateStoreProvider)PROVIDER_FIELD.get(store);
            String storeName = (String)STORE_NAME_FIELD.get(store);
            QueryableStoreType storeType = (QueryableStoreType)STORE_TYPE_FIELD.get(store);
            return provider.stores(storeName, storeType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Stream internals changed unexpectedly!", e);
        }
    }

    static {
        try {
            PROVIDER_FIELD = CompositeReadOnlySessionStore.class.getDeclaredField("storeProvider");
            PROVIDER_FIELD.setAccessible(true);
            STORE_NAME_FIELD = CompositeReadOnlySessionStore.class.getDeclaredField("storeName");
            STORE_NAME_FIELD.setAccessible(true);
            STORE_TYPE_FIELD = CompositeReadOnlySessionStore.class.getDeclaredField("queryableStoreType");
            STORE_TYPE_FIELD.setAccessible(true);
            SERDES_FIELD = MeteredSessionStore.class.getDeclaredField("serdes");
            SERDES_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Stream internals changed unexpectedly!", e);
        }
    }

    private static class EmptyKeyValueIterator
    implements KeyValueIterator<Windowed<GenericKey>, GenericRow> {
        private EmptyKeyValueIterator() {
        }

        public void close() {
        }

        public Windowed<GenericKey> peekNextKey() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public KeyValue<Windowed<GenericKey>, GenericRow> next() {
            throw new NoSuchElementException();
        }
    }

    private static final class DeserializingIterator
    implements KeyValueIterator<Windowed<GenericKey>, GenericRow> {
        private final KeyValueIterator<Windowed<Bytes>, byte[]> fetch;
        private final StateSerdes<GenericKey, GenericRow> serdes;

        private DeserializingIterator(KeyValueIterator<Windowed<Bytes>, byte[]> fetch, StateSerdes<GenericKey, GenericRow> serdes) {
            this.fetch = fetch;
            this.serdes = serdes;
        }

        public void close() {
            this.fetch.close();
        }

        public Windowed<GenericKey> peekNextKey() {
            Windowed windowed = (Windowed)this.fetch.peekNextKey();
            return new Windowed(this.serdes.keyFrom(((Bytes)windowed.key()).get()), windowed.window());
        }

        public boolean hasNext() {
            return this.fetch.hasNext();
        }

        public KeyValue<Windowed<GenericKey>, GenericRow> next() {
            Windowed<GenericKey> key = this.peekNextKey();
            KeyValue next = (KeyValue)this.fetch.next();
            return KeyValue.pair(key, (Object)this.serdes.valueFrom((byte[])next.value));
        }
    }

    static interface SessionStoreCacheBypassFetcherRange {
        public KeyValueIterator<Windowed<GenericKey>, GenericRow> fetchRange(ReadOnlySessionStore<GenericKey, GenericRow> var1, GenericKey var2, GenericKey var3);
    }

    static interface SessionStoreCacheBypassFetcher {
        public KeyValueIterator<Windowed<GenericKey>, GenericRow> fetch(ReadOnlySessionStore<GenericKey, GenericRow> var1, GenericKey var2);
    }
}

