/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public final class WindowStoreCacheBypass {
    private static final Field PROVIDER_FIELD;
    private static final Field STORE_NAME_FIELD;
    private static final Field WINDOW_STORE_TYPE_FIELD;
    static final Field SERDES_FIELD;
    private static final String STORE_UNAVAILABLE_MESSAGE = "State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.";

    private WindowStoreCacheBypass() {
    }

    public static WindowStoreIterator<ValueAndTimestamp<GenericRow>> fetch(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> store, GenericKey key, Instant lower, Instant upper) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>> stores = WindowStoreCacheBypass.getStores(store);
        Function<ReadOnlyWindowStore, WindowStoreIterator> fetchFunc = windowStore -> WindowStoreCacheBypass.fetchUncached((ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>)windowStore, key, lower, upper);
        return WindowStoreCacheBypass.findFirstNonEmptyIterator(stores, fetchFunc);
    }

    private static WindowStoreIterator<ValueAndTimestamp<GenericRow>> fetchUncached(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> windowStore, GenericKey key, Instant lower, Instant upper) {
        if (!(windowStore instanceof MeteredWindowStore)) {
            throw new IllegalStateException("Expecting a MeteredWindowStore");
        }
        StateSerdes<GenericKey, ValueAndTimestamp<GenericRow>> serdes = WindowStoreCacheBypass.getSerdes(windowStore);
        WindowStore<Bytes, byte[]> wrapped = WindowStoreCacheBypass.getInnermostStore(windowStore);
        Bytes rawKey = Bytes.wrap((byte[])serdes.rawKey((Object)key));
        WindowStoreIterator fetch = wrapped.fetch((Object)rawKey, lower, upper);
        return new DeserializingIterator(fetch, serdes);
    }

    public static KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> fetchRange(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> store, GenericKey keyFrom, GenericKey keyTo, Instant lower, Instant upper) {
        Objects.requireNonNull(keyFrom, "lower key can't be null");
        Objects.requireNonNull(keyTo, "upper key can't be null");
        List<ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>> stores = WindowStoreCacheBypass.getStores(store);
        Function<ReadOnlyWindowStore, KeyValueIterator> fetchFunc = windowStore -> WindowStoreCacheBypass.fetchRangeUncached((ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>)windowStore, keyFrom, keyTo, lower, upper);
        return WindowStoreCacheBypass.findFirstNonEmptyIterator(stores, fetchFunc);
    }

    private static KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> fetchRangeUncached(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> windowStore, GenericKey keyFrom, GenericKey keyTo, Instant lower, Instant upper) {
        if (!(windowStore instanceof MeteredWindowStore)) {
            throw new IllegalStateException("Expecting a MeteredWindowStore");
        }
        StateSerdes<GenericKey, ValueAndTimestamp<GenericRow>> serdes = WindowStoreCacheBypass.getSerdes(windowStore);
        WindowStore<Bytes, byte[]> wrapped = WindowStoreCacheBypass.getInnermostStore(windowStore);
        Bytes rawKeyFrom = Bytes.wrap((byte[])serdes.rawKey((Object)keyFrom));
        Bytes rawKeyTo = Bytes.wrap((byte[])serdes.rawKey((Object)keyTo));
        KeyValueIterator fetch = wrapped.fetch((Object)rawKeyFrom, (Object)rawKeyTo, lower, upper);
        return new DeserializingKeyValueIterator(fetch, serdes);
    }

    public static KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> fetchAll(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> store, Instant lower, Instant upper) {
        List<ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>> stores = WindowStoreCacheBypass.getStores(store);
        Function<ReadOnlyWindowStore, KeyValueIterator> fetchFunc = windowStore -> WindowStoreCacheBypass.fetchAllUncached((ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>)windowStore, lower, upper);
        return WindowStoreCacheBypass.findFirstNonEmptyIterator(stores, fetchFunc);
    }

    private static KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> fetchAllUncached(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> windowStore, Instant lower, Instant upper) {
        if (!(windowStore instanceof MeteredWindowStore)) {
            throw new IllegalStateException("Expecting a MeteredWindowStore");
        }
        StateSerdes<GenericKey, ValueAndTimestamp<GenericRow>> serdes = WindowStoreCacheBypass.getSerdes(windowStore);
        WindowStore<Bytes, byte[]> wrapped = WindowStoreCacheBypass.getInnermostStore(windowStore);
        KeyValueIterator fetch = wrapped.fetchAll(lower, upper);
        return new DeserializingKeyValueIterator(fetch, serdes);
    }

    private static <T extends KeyValueIterator & Closeable> T findFirstNonEmptyIterator(List<ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>> stores, Function<ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>, T> func) {
        KeyValueIterator result = null;
        for (ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> store : stores) {
            try {
                result = (KeyValueIterator)func.apply(store);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return (T)result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException(STORE_UNAVAILABLE_MESSAGE, (Throwable)e);
            }
        }
        return (T)(result instanceof WindowStoreIterator ? new EmptyWindowStoreIterator() : new EmptyKeyValueIterator());
    }

    private static StateSerdes<GenericKey, ValueAndTimestamp<GenericRow>> getSerdes(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> windowStore) throws RuntimeException {
        try {
            return (StateSerdes)SERDES_FIELD.get(windowStore);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Stream internals changed unexpectedly!", e);
        }
    }

    private static WindowStore<Bytes, byte[]> getInnermostStore(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> windowStore) {
        StateStore store;
        WindowStore wrapped = (WindowStore)((MeteredWindowStore)windowStore).wrapped();
        while (wrapped instanceof WrappedStateStore && (store = ((WrappedStateStore)wrapped).wrapped()) instanceof WindowStore) {
            wrapped = (WindowStore)store;
        }
        return wrapped;
    }

    private static List<ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>>> getStores(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> store) {
        try {
            StateStoreProvider provider = (StateStoreProvider)PROVIDER_FIELD.get(store);
            String storeName = (String)STORE_NAME_FIELD.get(store);
            QueryableStoreType windowStoreType = (QueryableStoreType)WINDOW_STORE_TYPE_FIELD.get(store);
            return provider.stores(storeName, windowStoreType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Stream internals changed unexpectedly!", e);
        }
    }

    static {
        try {
            PROVIDER_FIELD = CompositeReadOnlyWindowStore.class.getDeclaredField("provider");
            PROVIDER_FIELD.setAccessible(true);
            STORE_NAME_FIELD = CompositeReadOnlyWindowStore.class.getDeclaredField("storeName");
            STORE_NAME_FIELD.setAccessible(true);
            WINDOW_STORE_TYPE_FIELD = CompositeReadOnlyWindowStore.class.getDeclaredField("windowStoreType");
            WINDOW_STORE_TYPE_FIELD.setAccessible(true);
            SERDES_FIELD = MeteredWindowStore.class.getDeclaredField("serdes");
            SERDES_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Stream internals changed unexpectedly!", e);
        }
    }

    private static class EmptyKeyValueIterator
    implements KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> {
        private EmptyKeyValueIterator() {
        }

        public void close() {
        }

        public Windowed<GenericKey> peekNextKey() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public KeyValue<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> next() {
            throw new NoSuchElementException();
        }
    }

    private static class EmptyWindowStoreIterator
    implements WindowStoreIterator<ValueAndTimestamp<GenericRow>> {
        private EmptyWindowStoreIterator() {
        }

        public void close() {
        }

        public Long peekNextKey() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public KeyValue<Long, ValueAndTimestamp<GenericRow>> next() {
            throw new NoSuchElementException();
        }
    }

    private static final class DeserializingIterator
    implements WindowStoreIterator<ValueAndTimestamp<GenericRow>> {
        private final WindowStoreIterator<byte[]> fetch;
        private final StateSerdes<GenericKey, ValueAndTimestamp<GenericRow>> serdes;

        private DeserializingIterator(WindowStoreIterator<byte[]> fetch, StateSerdes<GenericKey, ValueAndTimestamp<GenericRow>> serdes) {
            this.fetch = fetch;
            this.serdes = serdes;
        }

        public void close() {
            this.fetch.close();
        }

        public Long peekNextKey() {
            return (Long)this.fetch.peekNextKey();
        }

        public boolean hasNext() {
            return this.fetch.hasNext();
        }

        public KeyValue<Long, ValueAndTimestamp<GenericRow>> next() {
            KeyValue next = (KeyValue)this.fetch.next();
            return KeyValue.pair((Object)next.key, (Object)this.serdes.valueFrom((byte[])next.value));
        }
    }

    private static final class DeserializingKeyValueIterator
    implements KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> {
        private final KeyValueIterator<Windowed<Bytes>, byte[]> fetch;
        private final StateSerdes<GenericKey, ValueAndTimestamp<GenericRow>> serdes;

        private DeserializingKeyValueIterator(KeyValueIterator<Windowed<Bytes>, byte[]> fetch, StateSerdes<GenericKey, ValueAndTimestamp<GenericRow>> serdes) {
            this.fetch = fetch;
            this.serdes = serdes;
        }

        public void close() {
            this.fetch.close();
        }

        public Windowed<GenericKey> peekNextKey() {
            Windowed nextKey = (Windowed)this.fetch.peekNextKey();
            return new Windowed(this.serdes.keyFrom(((Bytes)nextKey.key()).get()), nextKey.window());
        }

        public boolean hasNext() {
            return this.fetch.hasNext();
        }

        public KeyValue<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> next() {
            KeyValue next = (KeyValue)this.fetch.next();
            Windowed windowedKey = new Windowed(this.serdes.keyFrom(((Bytes)((Windowed)next.key).key()).get()), ((Windowed)next.key).window());
            return KeyValue.pair((Object)windowedKey, (Object)this.serdes.valueFrom((byte[])next.value));
        }
    }

    static interface WindowStoreCacheBypassFetcherRange {
        public KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> fetchRange(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> var1, GenericKey var2, GenericKey var3, Instant var4, Instant var5);
    }

    static interface WindowStoreCacheBypassFetcherAll {
        public KeyValueIterator<Windowed<GenericKey>, ValueAndTimestamp<GenericRow>> fetchAll(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> var1, Instant var2, Instant var3);
    }

    static interface WindowStoreCacheBypassFetcher {
        public WindowStoreIterator<ValueAndTimestamp<GenericRow>> fetch(ReadOnlyWindowStore<GenericKey, ValueAndTimestamp<GenericRow>> var1, GenericKey var2, Instant var3, Instant var4);
    }
}

