/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlBooleans;
import io.confluent.ksql.schema.ksql.SqlDoubles;
import io.confluent.ksql.schema.ksql.SqlTimeTypes;
import io.confluent.ksql.schema.ksql.SqlValueCoercer;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.BytesUtils;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Struct;

public enum DefaultSqlValueCoercer implements SqlValueCoercer
{
    STRICT,
    LAX;

    private ImmutableMap<SupportedCoercion, Coercer> rules;

    @Override
    public SqlValueCoercer.Result coerce(Object value, SqlType to) {
        return this.doCoerce(value, to);
    }

    public Optional<SqlType> canCoerce(SqlType from, SqlType to) {
        return this.getCoercerFor(from.baseType(), to.baseType()).flatMap(coercer -> coercer.canCoerce(this, from, to));
    }

    private SqlValueCoercer.Result doCoerce(Object value, SqlType to) {
        if (value == null) {
            return SqlValueCoercer.Result.nullResult();
        }
        SqlBaseType from = SchemaConverters.javaToSqlConverter().toSqlType(value.getClass());
        return this.getCoercerFor(from, to.baseType()).map(c -> c.coerce(this, value, to)).orElseGet(SqlValueCoercer.Result::failure);
    }

    private Optional<Coercer> getCoercerFor(SqlBaseType from, SqlBaseType to) {
        if (this.rules == null) {
            this.rules = Rules.buildRules(this == LAX);
        }
        return Optional.ofNullable(this.rules.get((Object)DefaultSqlValueCoercer.key(from, to)));
    }

    private static Optional<SqlType> coerceToDecimalCheck(DefaultSqlValueCoercer coercer, SqlType from, SqlType to) {
        if (to.baseType() == SqlBaseType.DOUBLE) {
            return Optional.of(to);
        }
        return Optional.of(DecimalUtil.widen((SqlType)from, (SqlType)to));
    }

    private static SqlValueCoercer.Result coerceToDecimal(Object value, SqlType sqlType) {
        try {
            SqlDecimal sqlDecimal = (SqlDecimal)sqlType;
            return SqlValueCoercer.Result.of(DecimalUtil.ensureFit((BigDecimal)new BigDecimal(String.valueOf(value)), (SqlDecimal)sqlDecimal));
        }
        catch (KsqlException | ArithmeticException | NumberFormatException e) {
            return SqlValueCoercer.Result.failure();
        }
    }

    private static SqlValueCoercer.Result anyToString(Object value) {
        return SqlValueCoercer.Result.of(value.toString());
    }

    private Optional<SqlType> canCoerceToArray(SqlType from, SqlType to) {
        SqlArray fromArray = (SqlArray)from;
        SqlArray toArray = (SqlArray)to;
        return this.canCoerce(fromArray.getItemType(), toArray.getItemType()).map(SqlTypes::array);
    }

    private SqlValueCoercer.Result coerceToArray(Object value, SqlType to) {
        if (!(value instanceof List)) {
            return SqlValueCoercer.Result.failure();
        }
        SqlType itemType = ((SqlArray)to).getItemType();
        List list = (List)value;
        ArrayList<Object> coerced = new ArrayList<Object>(list.size());
        for (Object el : list) {
            SqlValueCoercer.Result result = this.doCoerce(el, itemType);
            if (result.failed()) {
                return SqlValueCoercer.Result.failure();
            }
            coerced.add(result.value().orElse(null));
        }
        return SqlValueCoercer.Result.of(coerced);
    }

    private Optional<SqlType> canCoerceToMap(SqlType from, SqlType to) {
        SqlMap fromMap = (SqlMap)from;
        SqlMap toMap = (SqlMap)to;
        return this.canCoerce(fromMap.getKeyType(), toMap.getKeyType()).flatMap(keyType -> this.canCoerce(fromMap.getValueType(), toMap.getValueType()).map(valType -> SqlTypes.map((SqlType)keyType, (SqlType)valType)));
    }

    private SqlValueCoercer.Result coerceToMap(Object value, SqlType to) {
        if (!(value instanceof Map)) {
            return SqlValueCoercer.Result.failure();
        }
        SqlType keyType = ((SqlMap)to).getKeyType();
        SqlType valType = ((SqlMap)to).getValueType();
        Map map = (Map)value;
        HashMap<Object, Object> coerced = new HashMap<Object, Object>();
        for (Map.Entry entry : map.entrySet()) {
            SqlValueCoercer.Result coercedKey = this.doCoerce(entry.getKey(), keyType);
            SqlValueCoercer.Result coercedValue = this.doCoerce(entry.getValue(), valType);
            if (coercedKey.failed() || coercedValue.failed()) {
                return SqlValueCoercer.Result.failure();
            }
            coerced.put(coercedKey.value().orElse(null), coercedValue.value().orElse(null));
        }
        return SqlValueCoercer.Result.of(coerced);
    }

    private Optional<SqlType> canCoerceToStruct(SqlType from, SqlType to) {
        SqlStruct fromStruct = (SqlStruct)from;
        SqlStruct toStruct = (SqlStruct)to;
        List fieldNames = Streams.concat((Stream[])new Stream[]{fromStruct.fields().stream(), toStruct.fields().stream()}).map(SqlStruct.Field::name).distinct().collect(Collectors.toList());
        SqlStruct.Builder builder = SqlTypes.struct();
        for (String fieldName : fieldNames) {
            SqlType fieldType;
            Optional toField = toStruct.field(fieldName);
            Optional fromField = fromStruct.field(fieldName);
            if (!fromField.isPresent()) {
                fieldType = ((SqlStruct.Field)toField.orElseThrow(IllegalStateException::new)).type();
            } else if (!toField.isPresent()) {
                fieldType = ((SqlStruct.Field)fromField.orElseThrow(IllegalStateException::new)).type();
            } else {
                Optional<SqlType> common = this.canCoerce(((SqlStruct.Field)fromField.get()).type(), ((SqlStruct.Field)toField.get()).type());
                if (!common.isPresent()) {
                    return Optional.empty();
                }
                fieldType = common.get();
            }
            builder.field(fieldName, fieldType);
        }
        return Optional.of(builder.build());
    }

    private SqlValueCoercer.Result coerceToStruct(Object value, SqlType to) {
        if (!(value instanceof Struct)) {
            return SqlValueCoercer.Result.failure();
        }
        Struct struct = (Struct)value;
        SqlStruct fromStruct = (SqlStruct)SchemaConverters.connectToSqlConverter().toSqlType(struct.schema());
        SqlStruct toStruct = (SqlStruct)to;
        Struct coerced = new Struct(SchemaConverters.sqlToConnectConverter().toConnectSchema((SqlType)toStruct));
        for (SqlStruct.Field toField : toStruct.fields()) {
            SqlValueCoercer.Result fieldValue = fromStruct.field(toField.name()).map(f -> struct.get(f.name())).map(v -> this.doCoerce(v, toField.type())).orElse(SqlValueCoercer.Result.nullResult());
            if (fieldValue.failed()) {
                return SqlValueCoercer.Result.failure();
            }
            fieldValue.value().ifPresent(v -> coerced.put(toField.name(), v));
        }
        return SqlValueCoercer.Result.of(coerced);
    }

    private static boolean parseBoolean(String v) {
        return SqlBooleans.parseBooleanExact(v.trim()).orElseThrow(IllegalArgumentException::new);
    }

    private static SupportedCoercion key(SqlBaseType from, SqlBaseType to) {
        return new SupportedCoercion(from, to);
    }

    private static Coercer coercer(CoerceFunction coerceFunction) {
        return new Coercer(CheckFunction.PASS_THROUGH, coerceFunction);
    }

    private static Coercer coercer(CheckFunction checkFunction, CoerceFunction coerceFunction) {
        return new Coercer(checkFunction, coerceFunction);
    }

    private static Coercer decimalCoercer() {
        return DefaultSqlValueCoercer.coercer(DefaultSqlValueCoercer::coerceToDecimalCheck, (c, v, t) -> DefaultSqlValueCoercer.coerceToDecimal(v, t));
    }

    static /* synthetic */ SupportedCoercion access$000(SqlBaseType x0, SqlBaseType x1) {
        return DefaultSqlValueCoercer.key(x0, x1);
    }

    static /* synthetic */ Coercer access$100(CheckFunction x0, CoerceFunction x1) {
        return DefaultSqlValueCoercer.coercer(x0, x1);
    }

    static /* synthetic */ Coercer access$300() {
        return DefaultSqlValueCoercer.decimalCoercer();
    }

    private static final class Coercer {
        static final Coercer PASS_THROUGH = DefaultSqlValueCoercer.access$200(CoerceFunction.PASS_THROUGH);
        private final CheckFunction checkFunction;
        private final CoerceFunction coerceFunction;

        Coercer(CheckFunction checkFunction, CoerceFunction coerceFunction) {
            this.checkFunction = Objects.requireNonNull(checkFunction, "checkFunction");
            this.coerceFunction = Objects.requireNonNull(coerceFunction, "coerceFunction");
        }

        Optional<SqlType> canCoerce(DefaultSqlValueCoercer coercer, SqlType from, SqlType to) {
            return this.checkFunction.canCoerce(coercer, from, to);
        }

        SqlValueCoercer.Result coerce(DefaultSqlValueCoercer coercer, Object value, SqlType to) {
            return this.coerceFunction.coerce(coercer, value, to);
        }
    }

    private static interface CoerceFunction {
        public static final CoerceFunction PASS_THROUGH = (coercer, value, to) -> SqlValueCoercer.Result.of(value);

        public SqlValueCoercer.Result coerce(DefaultSqlValueCoercer var1, Object var2, SqlType var3);
    }

    private static interface CheckFunction {
        public static final CheckFunction PASS_THROUGH = (coercer, from, to) -> Optional.of(to);

        public Optional<SqlType> canCoerce(DefaultSqlValueCoercer var1, SqlType var2, SqlType var3);
    }

    private static final class SupportedCoercion {
        private final SqlBaseType from;
        private final SqlBaseType to;

        SupportedCoercion(SqlBaseType from, SqlBaseType to) {
            this.from = Objects.requireNonNull(from, "from");
            this.to = Objects.requireNonNull(to, "to");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SupportedCoercion that = (SupportedCoercion)o;
            return this.from == that.from && this.to == that.to;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }

    private static final class Rules {
        private static final ImmutableMap<SupportedCoercion, Coercer> STRICT_SUPPORTED = ImmutableMap.builder().put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.BOOLEAN, SqlBaseType.BOOLEAN), (Object)Coercer.PASS_THROUGH).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.INTEGER, SqlBaseType.INTEGER), (Object)Coercer.PASS_THROUGH).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.INTEGER, SqlBaseType.BIGINT), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> SqlValueCoercer.Result.of(((Number)v).longValue()))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.INTEGER, SqlBaseType.DECIMAL), (Object)DefaultSqlValueCoercer.access$300()).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.INTEGER, SqlBaseType.DOUBLE), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> SqlValueCoercer.Result.of(((Number)v).doubleValue()))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.BIGINT, SqlBaseType.BIGINT), (Object)Coercer.PASS_THROUGH).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.BIGINT, SqlBaseType.DECIMAL), (Object)DefaultSqlValueCoercer.access$300()).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.BIGINT, SqlBaseType.DOUBLE), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> SqlValueCoercer.Result.of(((Number)v).doubleValue()))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.DECIMAL, SqlBaseType.DECIMAL), (Object)DefaultSqlValueCoercer.access$300()).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.DECIMAL, SqlBaseType.DOUBLE), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> SqlValueCoercer.Result.of(((Number)v).doubleValue()))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.DOUBLE, SqlBaseType.DOUBLE), (Object)Coercer.PASS_THROUGH).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.STRING), (Object)Coercer.PASS_THROUGH).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.TIMESTAMP), (Object)Rules.parser((v, t) -> SqlTimeTypes.parseTimestamp(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.TIME), (Object)Rules.parser((v, t) -> SqlTimeTypes.parseTime(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.DATE), (Object)Rules.parser((v, t) -> SqlTimeTypes.parseDate(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.BYTES), (Object)Rules.parser((v, t) -> ByteBuffer.wrap(BytesUtils.decode((String)v, (BytesUtils.Encoding)BytesUtils.Encoding.BASE64)))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.ARRAY, SqlBaseType.ARRAY), (Object)DefaultSqlValueCoercer.access$100((rec$, x$0, x$1) -> DefaultSqlValueCoercer.access$1100(rec$, x$0, x$1), (rec$, x$0, x$1) -> DefaultSqlValueCoercer.access$1000(rec$, x$0, x$1))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.MAP, SqlBaseType.MAP), (Object)DefaultSqlValueCoercer.access$100((rec$, x$0, x$1) -> DefaultSqlValueCoercer.access$900(rec$, x$0, x$1), (rec$, x$0, x$1) -> DefaultSqlValueCoercer.access$800(rec$, x$0, x$1))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRUCT, SqlBaseType.STRUCT), (Object)DefaultSqlValueCoercer.access$100((rec$, x$0, x$1) -> DefaultSqlValueCoercer.access$700(rec$, x$0, x$1), (rec$, x$0, x$1) -> DefaultSqlValueCoercer.access$600(rec$, x$0, x$1))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.TIMESTAMP, SqlBaseType.TIMESTAMP), (Object)Coercer.PASS_THROUGH).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.TIME, SqlBaseType.TIME), (Object)Coercer.PASS_THROUGH).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.DATE, SqlBaseType.DATE), (Object)Coercer.PASS_THROUGH).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.BYTES, SqlBaseType.BYTES), (Object)Coercer.PASS_THROUGH).build();
        private static final ImmutableMap<SupportedCoercion, Coercer> LAX_ADDITIONAL = ImmutableMap.builder().put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.BOOLEAN, SqlBaseType.STRING), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> DefaultSqlValueCoercer.access$500(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.INTEGER, SqlBaseType.STRING), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> DefaultSqlValueCoercer.access$500(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.BIGINT, SqlBaseType.STRING), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> DefaultSqlValueCoercer.access$500(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.DECIMAL, SqlBaseType.STRING), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> SqlValueCoercer.Result.of(((BigDecimal)v).toPlainString()))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.DOUBLE, SqlBaseType.STRING), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> DefaultSqlValueCoercer.access$500(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.BOOLEAN), (Object)Rules.parser((v, t) -> DefaultSqlValueCoercer.access$400(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.INTEGER), (Object)Rules.parser((v, t) -> Integer.parseInt(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.BIGINT), (Object)Rules.parser((v, t) -> Long.parseLong(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.DECIMAL), (Object)Rules.parser((v, t) -> DecimalUtil.ensureFit((BigDecimal)new BigDecimal((String)v), (SqlDecimal)((SqlDecimal)t)))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.STRING, SqlBaseType.DOUBLE), (Object)Rules.parser((v, t) -> SqlDoubles.parseDouble(v))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.TIMESTAMP, SqlBaseType.STRING), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> SqlValueCoercer.Result.of(SqlTimeTypes.formatTimestamp((Timestamp)v)))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.TIME, SqlBaseType.STRING), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> SqlValueCoercer.Result.of(SqlTimeTypes.formatTime((Time)v)))).put((Object)DefaultSqlValueCoercer.access$000(SqlBaseType.DATE, SqlBaseType.STRING), (Object)DefaultSqlValueCoercer.access$200((c, v, t) -> SqlValueCoercer.Result.of(SqlTimeTypes.formatDate((Date)v)))).build();

        private Rules() {
        }

        private static Coercer parser(BiFunction<String, SqlType, Object> parserFunction) {
            return DefaultSqlValueCoercer.coercer((c, v, t) -> {
                try {
                    return SqlValueCoercer.Result.of(parserFunction.apply(((String)v).trim(), t));
                }
                catch (Exception e) {
                    return SqlValueCoercer.Result.failure();
                }
            });
        }

        static ImmutableMap<SupportedCoercion, Coercer> buildRules(boolean lax) {
            return !lax ? STRICT_SUPPORTED : ImmutableMap.builder().putAll(STRICT_SUPPORTED).putAll(LAX_ADDITIONAL).build();
        }
    }
}

