/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemUtils {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");

    public static PublicKey loadPublicKey(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, US_ASCII);){
            PEMParser pemParser = new PEMParser((Reader)new BufferedReader(reader));
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)pemParser.readObject());
            PublicKey publicKey = new JcaPEMKeyConverter().getPublicKey(keyInfo);
            return publicKey;
        }
    }

    public static void writePublicKey(OutputStream out, PublicKey key) throws IOException {
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(out, "utf8"));){
            pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)key));
        }
    }

    public static KeyPair loadKeyPair(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, US_ASCII);){
            PEMParser pemParser = new PEMParser((Reader)new BufferedReader(reader));
            PEMKeyPair pemKeyPair = (PEMKeyPair)pemParser.readObject();
            KeyPair keyPair = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
            return keyPair;
        }
    }

    public static void writeKeyPair(OutputStream out, KeyPair keyPair) throws IOException {
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(out, "utf8"));){
            pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)keyPair));
        }
    }
}

