/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import java.util.EnumMap;
import org.apache.kafka.server.quota.ClientQuotaType;

public class QuotaConfig {
    static final double UNLIMITED_THROUGHPUT_QUOTA = 9.223372036854776E18;
    static final double UNLIMITED_REQUEST_QUOTA = 2.147483647E9;
    static final double UNLIMITED_CONTROLLER_RATE_QUOTA = 2.147483647E9;
    static final double UNLIMITED_PRODUCER_ID_QUOTA = 2.147483647E9;
    public static final QuotaConfig UNLIMITED_QUOTA = new QuotaConfig(9.223372036854776E18, 9.223372036854776E18, 2.147483647E9, 2.147483647E9, 2.147483647E9);
    private final EnumMap<ClientQuotaType, Double> quotas = new EnumMap(ClientQuotaType.class);

    public QuotaConfig(Long produceQuota, Long fetchQuota, Double requestQuota, Double controllerQuota, Double producerIdQuota, QuotaConfig defaultQuota) {
        this(produceQuota == null ? defaultQuota.quota(ClientQuotaType.PRODUCE) : (double)produceQuota.longValue(), fetchQuota == null ? defaultQuota.quota(ClientQuotaType.FETCH) : (double)fetchQuota.longValue(), requestQuota == null ? defaultQuota.quota(ClientQuotaType.REQUEST) : requestQuota.doubleValue(), controllerQuota == null ? defaultQuota.quota(ClientQuotaType.CONTROLLER_MUTATION) : controllerQuota.doubleValue(), producerIdQuota == null ? defaultQuota.quota(ClientQuotaType.PRODUCER_ID) : producerIdQuota.doubleValue());
    }

    public Long equalQuotaPerBrokerOrUnlimited(ClientQuotaType quotaType, int numBrokers, Long quotaIfNoBrokers) {
        if (numBrokers <= 0) {
            return quotaIfNoBrokers;
        }
        Double quota = this.hasQuotaLimit(quotaType) ? this.quota(quotaType) / (double)numBrokers : UNLIMITED_QUOTA.quota(quotaType);
        return quota.longValue();
    }

    QuotaConfig(double produceQuota, double fetchQuota, double requestQuota, double controllerMutationQuota, double producerIdQuota) {
        if (produceQuota <= 0.0 || fetchQuota <= 0.0 || requestQuota <= 0.0 || controllerMutationQuota <= 0.0 || producerIdQuota <= 0.0) {
            throw new IllegalArgumentException(String.format("Invalid quota produce=%f fetch=%f request=%f controller=%f", produceQuota, fetchQuota, requestQuota, controllerMutationQuota));
        }
        this.quotas.put(ClientQuotaType.PRODUCE, produceQuota);
        this.quotas.put(ClientQuotaType.FETCH, fetchQuota);
        this.quotas.put(ClientQuotaType.REQUEST, requestQuota);
        this.quotas.put(ClientQuotaType.CONTROLLER_MUTATION, controllerMutationQuota);
        this.quotas.put(ClientQuotaType.PRODUCER_ID, producerIdQuota);
    }

    public QuotaConfig withQuota(ClientQuotaType quotaType, double quotaValue) {
        EnumMap<ClientQuotaType, Double> newQuotas = new EnumMap<ClientQuotaType, Double>(this.quotas);
        newQuotas.put(quotaType, quotaValue);
        return new QuotaConfig(newQuotas.get(ClientQuotaType.PRODUCE), newQuotas.get(ClientQuotaType.FETCH), newQuotas.get(ClientQuotaType.REQUEST), newQuotas.get(ClientQuotaType.CONTROLLER_MUTATION), newQuotas.get(ClientQuotaType.PRODUCER_ID));
    }

    public boolean hasQuotaLimit(ClientQuotaType quotaType) {
        return this.quota(quotaType) != UNLIMITED_QUOTA.quota(quotaType);
    }

    public double quota(ClientQuotaType quotaType) {
        return this.quotas.get(quotaType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuotaConfig that = (QuotaConfig)o;
        return this.quotas.equals((Object)that.quotas);
    }

    public int hashCode() {
        return this.quotas.hashCode();
    }

    public String toString() {
        return "QuotaConfig(quotas=" + this.quotas + ')';
    }
}

