/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Exit;

public class DeleteAclsForMultiTenantPrincipal {
    public static void main(String[] args) {
        if (args.length == 1 && (args[0].equals("--h") || args[0].equals("--help"))) {
            System.out.println("Pass BOOTSTRAP_SERVERS_CONFIG as first arguments, lkcID as second arguments and other arguments as space separated principals. Usage: DeleteAclsForMultiTenantPrincipal localhost:1971 lkc-123 user1");
            Exit.exit((int)0);
        } else if (args.length < 3) {
            System.out.println("Pass at least three arguments, BOOTSTRAP_SERVERS_CONFIG as first arguments, lkcID as second arguments and other arguments as principals.");
            Exit.exit((int)0);
        }
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", args[0]);
        try (AdminClient adminClient = AdminClient.create((Properties)props);){
            for (int i = 2; i < args.length; ++i) {
                Collection aclBindings = (Collection)adminClient.deleteAcls(Collections.singleton(DeleteAclsForMultiTenantPrincipal.filter(args[1], args[i]))).all().get();
                System.out.printf("AclBinding for lkc=%s and principal=%s are following: %n", args[1], args[i]);
                for (AclBinding aclBinding : aclBindings) {
                    System.out.println(aclBinding);
                }
                System.out.printf("Deleted %d ACLs%n", aclBindings.size());
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static AclBindingFilter filter(String lkcId, String principalName) {
        return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(new KafkaPrincipal("TenantUser", lkcId + "_" + principalName).toString(), null, AclOperation.ANY, AclPermissionType.ANY));
    }
}

