/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authenticator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.message.DefaultPrincipalData;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class OAuthKafkaPrincipalBuilder
implements KafkaPrincipalBuilder,
KafkaPrincipalSerde,
Configurable {
    private static final String CONFLUENT_ISSUER = "Confluent";
    private static final String GROUPS_CLAIM_NAME = "groups";
    private static final String OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY = "OAUTHBEARER.token";
    private final JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setDisableRequireSignature().setSkipAllValidators().build();
    private DefaultKafkaPrincipalBuilder defaultKafkaPrincipalBuilder;

    public void configure(Map<String, ?> configs) {
        KerberosShortNamer kerberosShortNamer = SaslChannelBuilder.createKerberosShortNamerFromConfigs(configs);
        SslPrincipalMapper sslPrincipalMapper = SslChannelBuilder.createSslPrincipalMapperFromConfigs(configs);
        this.defaultKafkaPrincipalBuilder = new DefaultKafkaPrincipalBuilder(kerberosShortNamer, sslPrincipalMapper);
    }

    public KafkaPrincipal build(AuthenticationContext context) {
        SaslServer saslServer;
        if (context instanceof SaslAuthenticationContext && "OAUTHBEARER".equals((saslServer = ((SaslAuthenticationContext)context).server()).getMechanismName())) {
            OAuthBearerToken token = (OAuthBearerToken)saslServer.getNegotiatedProperty(OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY);
            return this.applyOAuthBearerPrincipalMapper(token);
        }
        return Objects.requireNonNull(this.defaultKafkaPrincipalBuilder, "Principal builder instance has not yet been configured").build(context);
    }

    private KafkaPrincipal applyOAuthBearerPrincipalMapper(OAuthBearerToken oauthBearerToken) {
        try {
            JwtClaims claims = this.jwtConsumer.processToClaims(oauthBearerToken.value());
            if (this.getJwtIssuerOrEmpty(claims).equals(CONFLUENT_ISSUER) && claims.hasClaim(GROUPS_CLAIM_NAME)) {
                return new ConfluentPrincipal("User", claims.getSubject(), claims.getSubject(), Optional.empty(), false, new HashSet(claims.getStringListClaimValue(GROUPS_CLAIM_NAME)));
            }
            return new KafkaPrincipal("User", oauthBearerToken.principalName());
        }
        catch (Exception e) {
            throw new KafkaException("Failed to map OAuthBearer token to ConfluentPrincipal for '" + oauthBearerToken.principalName() + "'", (Throwable)e);
        }
    }

    private String getJwtIssuerOrEmpty(JwtClaims jwtClaims) {
        try {
            return jwtClaims.getIssuer();
        }
        catch (MalformedClaimException ignored) {
            return "";
        }
    }

    public byte[] serialize(KafkaPrincipal principal) throws SerializationException {
        if (principal instanceof ConfluentPrincipal) {
            ConfluentPrincipal cp = (ConfluentPrincipal)principal;
            DefaultPrincipalData data = new DefaultPrincipalData().setType(principal.getPrincipalType()).setName(principal.getName()).setTokenAuthenticated(principal.tokenAuthenticated());
            if (cp.getGroups() != null && !cp.getGroups().isEmpty()) {
                data.setGroups(new ArrayList(cp.getGroups()));
            }
            return MessageUtil.toVersionPrefixedBytes((short)0, (Message)data);
        }
        return this.defaultKafkaPrincipalBuilder.serialize(principal);
    }

    public KafkaPrincipal deserialize(byte[] bytes) throws SerializationException {
        DefaultPrincipalData data;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short version = buffer.getShort();
        if (version < 0 || version > 0) {
            throw new SerializationException("Invalid principal data version " + version);
        }
        try {
            data = new DefaultPrincipalData((Readable)new ByteBufferAccessor(buffer), version);
        }
        catch (Throwable t) {
            throw new SerializationException("Failed to deserialize principal", t);
        }
        if (buffer.hasRemaining()) {
            throw new SerializationException("Failed to deserialize principal: " + buffer.remaining() + " bytes remaining after parsing");
        }
        if (data.groups() != null && !data.groups().isEmpty()) {
            return new ConfluentPrincipal(data.type(), data.name(), data.name(), Optional.empty(), data.tokenAuthenticated(), new HashSet(data.groups()));
        }
        return this.defaultKafkaPrincipalBuilder.deserialize(bytes);
    }
}

