/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public final class QueryStateStoreId {
    private static final String SEPARATOR = "#";
    private final String queryId;
    private final String stateStoreName;

    public static QueryStateStoreId of(String queryId, String stateStoreName) {
        return new QueryStateStoreId(queryId, stateStoreName);
    }

    public static QueryStateStoreId of(String serializedKey) {
        return new QueryStateStoreId(serializedKey);
    }

    private QueryStateStoreId(String queryId, String stateStoreName) {
        this.queryId = queryId;
        this.stateStoreName = stateStoreName;
    }

    @JsonCreator
    public QueryStateStoreId(String serializedPair) {
        String[] parts = serializedPair.split("\\#");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0);
        this.queryId = Objects.requireNonNull(parts[0]);
        this.stateStoreName = Objects.requireNonNull(parts[1]);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getStateStoreName() {
        return this.stateStoreName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryStateStoreId that = (QueryStateStoreId)o;
        return Objects.equals(this.queryId, that.queryId) && Objects.equals(this.stateStoreName, that.stateStoreName);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.stateStoreName);
    }

    @JsonValue
    public String toString() {
        return this.queryId + SEPARATOR + this.stateStoreName;
    }
}

