/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cloud.rbac;

import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.utils.Utils;

public class CloudScope {
    public static final String ORGANIZATION_LEVEL = "organization";
    public static final String ENVIRONMENT_LEVEL = "environment";
    public static final String CLOUD_CLUSTER_LEVEL = "cloud-cluster";
    public static final String KAFKA_CLUSTER_KEY = "kafka-cluster";
    public String orgId;
    public String accountId;
    public String cloudClusterId;
    public String clusterType;
    public String logicalClusterId;

    private static String resourceId(String level, Scope scope) {
        Optional<String> orgScopePathElement = scope.path().stream().filter(e -> e.startsWith(level + "=")).findFirst();
        return orgScopePathElement.map(s -> s.substring((level + "=").length())).orElse(null);
    }

    public CloudScope(Scope scope) {
        List path = scope.path();
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Scope missing organization");
        }
        this.orgId = ((String)path.get(0)).replace("organization=", "");
        if (this.orgId.contains("=")) {
            throw new IllegalArgumentException("Unexpected scope path element: " + (String)path.get(0));
        }
        if (path.size() > 1) {
            this.accountId = ((String)scope.path().get(1)).replace("environment=", "");
            if (this.accountId.contains("=")) {
                throw new IllegalArgumentException("Unexpected scope path element: " + (String)path.get(1));
            }
        }
        if (path.size() > 2) {
            this.cloudClusterId = ((String)scope.path().get(2)).replace("cloud-cluster=", "");
            if (this.cloudClusterId.contains("=")) {
                throw new IllegalArgumentException("Unexpected scope path element: " + (String)path.get(2));
            }
        }
        if (path.size() > 3) {
            throw new IllegalArgumentException("Too many elements in scope path: " + path);
        }
        if (scope.clusters().size() > 2) {
            throw new IllegalArgumentException("Scope has too many clusters. Max is 2.");
        }
        HashMap clusters = new HashMap(scope.clusters());
        if (scope.clusters().size() == 2 && clusters.remove(KAFKA_CLUSTER_KEY) == null) {
            throw new IllegalArgumentException("Scope clusters missing kafka-cluster");
        }
        if (clusters.size() == 1) {
            this.clusterType = (String)clusters.keySet().iterator().next();
            this.logicalClusterId = (String)clusters.get(this.clusterType);
            if (this.logicalClusterId == null) {
                throw new IllegalArgumentException("Scope cluster missing identifier: " + clusters);
            }
        }
        if (this.clusterType != null && this.clusterType.equals(ClusterType.SCHEMA_REGISTRY_CLUSTER.toString())) {
            if (this.accountId == null) {
                throw new IllegalArgumentException("schema registry clusters need org and env");
            }
        } else if (this.clusterType != null && (this.accountId == null || this.cloudClusterId == null)) {
            throw new IllegalArgumentException("cluster type needs org, env, and cloud-cluster");
        }
    }

    public static Scope getScope(String orgId) {
        return CloudScope.getScope(orgId, null, null, null, null);
    }

    public static Scope getScope(String orgId, String accountId) {
        return CloudScope.getScope(orgId, accountId, null, null, null);
    }

    public static Scope getScope(String orgId, String accountId, String cloudClusterId) {
        return CloudScope.getScope(orgId, accountId, cloudClusterId, null, null);
    }

    public static Scope getScope(String orgId, String accountId, String cloudClusterId, String clusterType, String logicalClusterId) {
        ArrayList<String> path = new ArrayList<String>();
        HashMap<String, String> clusters = new HashMap<String, String>();
        if (orgId != null) {
            path.add("organization=" + orgId);
        }
        if (accountId != null) {
            path.add("environment=" + accountId);
        }
        if (cloudClusterId != null && !cloudClusterId.isEmpty()) {
            path.add("cloud-cluster=" + cloudClusterId);
        }
        if (clusterType != null || logicalClusterId != null) {
            if (clusterType != null && logicalClusterId != null) {
                clusters.put(clusterType.toLowerCase(), logicalClusterId);
            } else {
                throw new IllegalArgumentException(String.format("Both clusterType ({}) and logicalCluster ({}) must be set if either one is set.", clusterType, logicalClusterId));
            }
        }
        return new Scope(path, clusters);
    }

    public static String organizationResourceId(Scope scope) {
        return CloudScope.resourceId(ORGANIZATION_LEVEL, scope);
    }

    public static String environmentResourceId(Scope scope) {
        return CloudScope.resourceId(ENVIRONMENT_LEVEL, scope);
    }

    public static String cloudClusterResourceId(Scope scope) {
        return CloudScope.resourceId(CLOUD_CLUSTER_LEVEL, scope);
    }

    public static Scope organizationScope(String orgId) {
        return new Scope(Arrays.asList("organization=" + orgId), Collections.emptyMap());
    }

    public static Scope envScope(String orgId, String envId) {
        return new Scope(Arrays.asList("organization=" + orgId, "environment=" + envId), Collections.emptyMap());
    }

    public static Scope cloudClusterScope(String orgId, String envId, String lkcId) {
        return new Scope(Arrays.asList("organization=" + orgId, "environment=" + envId, "cloud-cluster=" + lkcId), Collections.emptyMap());
    }

    public static Scope kafkaScope(String orgId, String envId, String lkcId) {
        return new Scope(Arrays.asList("organization=" + orgId, "environment=" + envId, "cloud-cluster=" + lkcId), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)KAFKA_CLUSTER_KEY, (Object)lkcId)}));
    }

    public static String bindingScope(Scope scope) {
        if (scope.clusters().isEmpty()) {
            return scope.bindingScope();
        }
        HashMap clusters = (HashMap)scope.clusters();
        if (scope.clusters().size() > 2) {
            throw new IllegalArgumentException("Scope has too many clusters. Max is 2.");
        }
        if (scope.clusters().size() == 2 && clusters.remove(KAFKA_CLUSTER_KEY) == null) {
            throw new IllegalArgumentException("Scope clusters missing kafka-cluster");
        }
        if (clusters.size() == 1) {
            String clusterType = (String)clusters.keySet().iterator().next();
            if (clusterType.equals(ClusterType.SCHEMA_REGISTRY_CLUSTER.toString()) || clusterType.equals(ClusterType.KSQL_CLUSTER.toString())) {
                return clusterType;
            }
            if (clusterType.equals(KAFKA_CLUSTER_KEY)) {
                return "cluster";
            }
        }
        return null;
    }
}

