/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.app;

import io.confluent.rest.RestConfig;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.config.ConfigDef;

public class RbacApiAppConfig
extends RestConfig {
    private static ConfigDef config;
    public static final String CONFIG_PREFIX = "confluent.metadata.server.";
    public static final int MDS_PORT_DEFAULT = 8090;
    public static final String MDS_LISTENERS_DEFAULT = "http://0.0.0.0:8090";
    public static final String MDS_USER_STORE_CONFIG = "user.store";
    public static final String MDS_USER_STORE_LDAP = "LDAP";
    public static final String MDS_USER_STORE_FILE = "FILE";
    public static final String MDS_USER_STORE_NONE = "NONE";
    public static final ConfigDef.ValidString MDS_USER_STORE_VALIDATOR;
    public static final String MDS_USER_STORE_DOC = "What MDS should authenticate users against. Default is LDAP, which then expects Kafka Ldap settings to be configured.Other options include NONE and FILE. NONE implies that that only bearer auth is supported, without fallback to a user store to verify user credentials. FILE validates user credentials against a local file using Jetty's HashLoginService. FILE should NOT be used in a production environment. Note that choice of user store only matters as long as 'authentication.method' is not NONE.";
    public static final String FILE_LOGIN_PATH_PROP = "user.store.file.path";
    public static final String FILE_LOGIN_PROP_PATH_DOC = "Property file containing user credentials in Jetty HashLoginService style.";
    public static final String MDS_OPENAPI_ENABLE_CONFIG = "openapi.enable";
    public static final String MDS_OPENAPI_ENABLE_DOC = "Enables the OpenApi UI to be run on this MDS node.  Allows clients to be able to see and interact with the Api for learning and development purposes.Should not be run in production.";
    public static final String MDS_API_FLAVOR_PROP = "api.flavor";
    public static final String MDS_API_FLAVOR_DOC = "Which flavor of the MDS API should be run.";
    public static final String CLUSTER_REGISTRY_MDS_PROP = "cluster.registry.clusters";
    public static final String SSO_MODE = "sso.mode";
    public static final String SSO_MODE_DOC = "The support for user login using an identity provider is not enabled by default, and this optional setting tells the mode for SSO like OIDC or SAML.";

    public static ConfigDef baseConfigDef() {
        return RbacApiAppConfig.baseConfigDef((int)8090, (String)"").define(MDS_USER_STORE_CONFIG, ConfigDef.Type.STRING, (Object)MDS_USER_STORE_LDAP, (ConfigDef.Validator)MDS_USER_STORE_VALIDATOR, ConfigDef.Importance.LOW, MDS_USER_STORE_DOC).define(FILE_LOGIN_PATH_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, FILE_LOGIN_PROP_PATH_DOC).define(MDS_OPENAPI_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, MDS_OPENAPI_ENABLE_DOC).define(CLUSTER_REGISTRY_MDS_PROP, ConfigDef.Type.STRING, (Object)"[]", ConfigDef.Importance.LOW, "JSON defining initial state of Cluster Registry. This should not be set manually, instead Cluster Registry http apis should be used.").define(SSO_MODE, ConfigDef.Type.STRING, (Object)"none", ConfigDef.Importance.LOW, SSO_MODE_DOC);
    }

    public RbacApiAppConfig() {
        super(config);
    }

    public RbacApiAppConfig(Map<?, ?> props) {
        super(config, props);
    }

    public RbacApiAppConfig(ConfigDef definition) {
        super(definition, new TreeMap());
    }

    public RbacApiAppConfig(ConfigDef definition, Map<?, ?> props) {
        super(definition, props);
    }

    public static ConfigDef getConfigDef() {
        return config;
    }

    static {
        MDS_USER_STORE_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{MDS_USER_STORE_LDAP, MDS_USER_STORE_FILE, MDS_USER_STORE_NONE});
        config = RbacApiAppConfig.baseConfigDef();
    }
}

