/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.authorizer;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.util.JwtUtils;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.Role;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;

public class SecurityMetadataAuthorizer {
    public static final Operation DESCRIBE_ACCESS = new Operation("DescribeAccess");
    public static final Operation ALTER_ACCESS = new Operation("AlterAccess");
    public static final Operation DESCRIBE = new Operation("Describe");
    public static final Operation ALTER = new Operation("Alter");
    public static final Operation BIND = new Operation("Bind");
    public static final io.confluent.security.authorizer.ResourceType INTERNAL_ROLE_TYPE = new io.confluent.security.authorizer.ResourceType("InternalRole");
    private static final io.confluent.security.authorizer.ResourceType SECURITY_METADATA_TYPE = new io.confluent.security.authorizer.ResourceType("SecurityMetadata");
    private static final ResourcePattern SECURITY_METADATA = new ResourcePattern(SECURITY_METADATA_TYPE, "security-metadata", PatternType.LITERAL);
    private static final Set<Operation> SECURITY_METADATA_OPS = Utils.mkSet((Object[])new Operation[]{DESCRIBE, ALTER});
    private static final Set<Operation> RESOURCE_ACCESS_OPS = Utils.mkSet((Object[])new Operation[]{DESCRIBE_ACCESS, ALTER_ACCESS});
    private static final ResourcePattern clusterResource = new ResourcePattern(new io.confluent.security.authorizer.ResourceType(ResourceType.CLUSTER.name()), "kafka-cluster", PatternType.LITERAL);
    private final Authorizer authorizer;
    private final Scope metadataClusterScope;
    private String groupsClaimName;

    public SecurityMetadataAuthorizer(Authorizer authorizer, Scope metadataClusterScope) {
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer");
        this.metadataClusterScope = Objects.requireNonNull(metadataClusterScope);
        this.groupsClaimName = "groups";
    }

    public void authorizeSecurityMetadataAccess(SecurityContext context, Scope scope, Operation op) {
        this.authorizeSecurityMetadataAccess(context, scope, op, true);
    }

    public void authorizeSecurityMetadataAccess(SecurityContext context, Operation op) {
        this.authorizeSecurityMetadataAccess(context, this.metadataClusterScope, op, true);
    }

    public void authorizeSecurityMetadataAccess(SecurityContext context, Scope scope, Operation op, boolean logIfDenied) {
        this.ensureValidOp(op, SECURITY_METADATA_OPS, SECURITY_METADATA.name());
        KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
        this.authorize(requestorPrincipal, new Action(scope, SECURITY_METADATA, op, 1, true, logIfDenied));
    }

    public boolean hasSecurityMetadataAccess(KafkaPrincipal requestorPrincipal, Scope scope, Operation op) {
        this.ensureValidOp(op, SECURITY_METADATA_OPS, SECURITY_METADATA.name());
        return this.hasAuthorization(requestorPrincipal, new Action(scope, SECURITY_METADATA, op));
    }

    public boolean hasSecurityMetadataAccess(KafkaPrincipal kafkaPrincipal, Operation op) {
        return this.hasSecurityMetadataAccess(kafkaPrincipal, this.metadataClusterScope, op);
    }

    public void authorizeSecurityMetadataAccessAllowDescribeSelf(SecurityContext context, KafkaPrincipal targetPrincipal, Operation op) {
        KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
        if (op.equals((Object)DESCRIBE) && (this.isCallingPrincipalSameAsTargetPrincipal((Principal)requestorPrincipal, targetPrincipal) || this.isCallingPrincipalPartOfTargetGroupPrincipal(requestorPrincipal, targetPrincipal))) {
            return;
        }
        this.authorizeSecurityMetadataAccess(context, op);
    }

    public void authorizeSecurityMetadataAccessAllowDescribeSelf(SecurityContext context, Scope scope, KafkaPrincipal targetPrincipal, Operation op) {
        KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
        if (op.equals((Object)DESCRIBE) && (this.isCallingPrincipalSameAsTargetPrincipal((Principal)requestorPrincipal, targetPrincipal) || this.isCallingPrincipalPartOfTargetGroupPrincipal(requestorPrincipal, targetPrincipal))) {
            return;
        }
        this.authorizeSecurityMetadataAccess(context, scope, op);
    }

    public void authorizeResourceAccess(SecurityContext context, Scope scope, Collection<ResourcePattern> resourcePatterns, Operation op) {
        this.ensureValidOp(op, RESOURCE_ACCESS_OPS, "resource access");
        KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
        resourcePatterns.forEach(resourcePattern -> this.authorize(requestorPrincipal, new Action(scope, resourcePattern, op)));
    }

    public void authorizeRoleAccess(SecurityContext context, Role role) {
        if (role != null && role.internal()) {
            KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
            this.authorize(requestorPrincipal, new Action(Scope.ROOT_SCOPE, new ResourcePattern(INTERNAL_ROLE_TYPE, role.name(), PatternType.LITERAL), BIND));
        }
    }

    public Set<ResourcePattern> filterResourceAccess(KafkaPrincipal principal, Scope scope, Collection<ResourcePattern> resourcePatterns, Operation op) {
        if (resourcePatterns.isEmpty()) {
            return Collections.emptySet();
        }
        List distinctPatterns = resourcePatterns.stream().distinct().collect(Collectors.toList());
        List actions = distinctPatterns.stream().map(rp -> new Action(scope, rp, op, 1, false, false)).collect(Collectors.toList());
        List authorizeResults = this.authorizer.authorize(principal, "", actions);
        HashSet authorizedPatterns = new HashSet();
        IntStream.range(0, authorizeResults.size()).forEach(i -> {
            if (((AuthorizeResult)authorizeResults.get(i)).equals((Object)AuthorizeResult.ALLOWED)) {
                authorizedPatterns.add(distinctPatterns.get(i));
            }
        });
        HashSet<ResourcePattern> filteredPatterns = new HashSet<ResourcePattern>(distinctPatterns);
        filteredPatterns.retainAll(authorizedPatterns);
        return filteredPatterns;
    }

    public void authorizeFilteredAccess(SecurityContext context, Scope scope, Collection<ResourcePatternFilter> resourcePatternFilters, Operation op) {
        this.ensureValidOp(op, RESOURCE_ACCESS_OPS, "resource access");
        KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
        boolean needsSecurityMetadataAccess = false;
        for (ResourcePatternFilter f : resourcePatternFilters) {
            if (f.name() != null) {
                ResourcePattern pattern = new ResourcePattern(f.resourceType(), f.name(), f.patternType());
                this.authorize(requestorPrincipal, new Action(scope, pattern, op));
                continue;
            }
            needsSecurityMetadataAccess = true;
        }
        if (needsSecurityMetadataAccess) {
            this.authorizeSecurityMetadataAccess(context, scope, op == ALTER_ACCESS ? ALTER : DESCRIBE);
        }
    }

    public void authorizeAuthorizeRequest(SecurityContext context, KafkaPrincipal principal, List<Action> actions) {
        KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
        if (this.isCallingPrincipalSameAsTargetPrincipal((Principal)requestorPrincipal, principal) || this.isCallingPrincipalPartOfTargetGroupPrincipal(requestorPrincipal, principal)) {
            return;
        }
        actions.stream().map(action -> action.resourcePattern().patternType()).forEach(patternType -> {
            if (patternType != PatternType.LITERAL) {
                throw new IllegalArgumentException("Only literal resources are supported. Got: " + patternType);
            }
        });
        Set authorizeActions = actions.stream().map(action -> new Action(action.scope(), action.resourcePattern(), DESCRIBE_ACCESS)).collect(Collectors.toSet());
        List authorizeResults = this.authorizer.authorize(requestorPrincipal, "", new ArrayList(authorizeActions));
        if (!authorizeResults.stream().allMatch(arg_0 -> AuthorizeResult.ALLOWED.equals(arg_0))) {
            throw new AuthorizationException("Authorization request for principal " + principal + " is not permitted for requestor principal " + requestorPrincipal);
        }
    }

    public void authorizeAclAccess(SecurityContext context, Scope scope, ResourcePattern resourcePattern, Operation securityMetadataOp, Operation resourceOwnerOp) {
        KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
        if (!this.aclAccess(context, scope, resourcePattern, securityMetadataOp, resourceOwnerOp)) {
            throw new AuthorizationException("Acl Alter operation not permitted for " + requestorPrincipal);
        }
    }

    public boolean aclAccess(SecurityContext context, Scope scope, ResourcePattern resourcePattern, Operation securityMetadataOp, Operation resourceOwnerOp) {
        this.ensureValidOp(securityMetadataOp, SECURITY_METADATA_OPS, SECURITY_METADATA.name());
        this.ensureValidOp(resourceOwnerOp, RESOURCE_ACCESS_OPS, "resource access");
        KafkaPrincipal requestorPrincipal = this.userPrincipal(context);
        LinkedList<Action> authorizeActions = new LinkedList<Action>();
        authorizeActions.add(new Action(scope, SECURITY_METADATA, securityMetadataOp));
        authorizeActions.add(new Action(scope, clusterResource, securityMetadataOp));
        authorizeActions.add(new Action(scope, resourcePattern, resourceOwnerOp));
        List authorizeResults = this.authorizer.authorize(requestorPrincipal, "", authorizeActions);
        return authorizeResults.stream().anyMatch(arg_0 -> AuthorizeResult.ALLOWED.equals(arg_0));
    }

    private boolean hasAuthorization(KafkaPrincipal principal, Action action) {
        AuthorizeResult result = (AuthorizeResult)this.authorizer.authorize(principal, "", Collections.singletonList(action)).get(0);
        return result == AuthorizeResult.ALLOWED;
    }

    private void authorize(KafkaPrincipal principal, Action action) {
        if (!this.hasAuthorization(principal, action)) {
            throw new AuthorizationException(action + " not permitted for " + principal);
        }
    }

    private void ensureValidOp(Operation op, Set<Operation> supportedOps, String resourceDesc) {
        if (!supportedOps.contains(op)) {
            throw new IllegalArgumentException(String.format("Unsupported operation %s for %s, supported ops are %s", op, resourceDesc, supportedOps));
        }
    }

    public KafkaPrincipal userPrincipal(SecurityContext context) {
        Principal principal = context.getUserPrincipal();
        if (principal == null) {
            return KafkaPrincipal.ANONYMOUS;
        }
        Set<String> groups = this.getGroupsFromPrincipal(principal);
        if (!groups.isEmpty()) {
            return new ConfluentPrincipal("User", principal.getName(), principal.getName(), Optional.empty(), false, groups);
        }
        return new KafkaPrincipal("User", principal.getName());
    }

    private Set<String> getGroupsFromPrincipal(Principal principal) {
        if (principal instanceof JwtPrincipal) {
            return JwtUtils.getGroupsFromJwtPrincipal((JwtPrincipal)((JwtPrincipal)principal));
        }
        return Collections.emptySet();
    }

    public boolean isCallingPrincipalSameAsTargetPrincipal(Principal callingPrincipal, KafkaPrincipal targetPrincipal) {
        if (callingPrincipal == null || targetPrincipal == null) {
            return false;
        }
        if (callingPrincipal.getName() == null || targetPrincipal.getName() == null) {
            return false;
        }
        if (!"User".equals(targetPrincipal.getPrincipalType())) {
            return false;
        }
        return callingPrincipal.getName().equals(targetPrincipal.getName());
    }

    private boolean isCallingPrincipalPartOfTargetGroupPrincipal(KafkaPrincipal callingPrincipal, KafkaPrincipal targetGroupPrincipal) {
        if (callingPrincipal == null || targetGroupPrincipal == null) {
            return false;
        }
        if (!"Group".equals(targetGroupPrincipal.getPrincipalType())) {
            return false;
        }
        if (!(callingPrincipal instanceof ConfluentPrincipal)) {
            return false;
        }
        if (Objects.isNull(((ConfluentPrincipal)callingPrincipal).getGroups())) {
            return false;
        }
        return ((ConfluentPrincipal)callingPrincipal).getGroups().contains(targetGroupPrincipal.getName());
    }
}

