/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.comparators;

import io.confluent.security.authorizer.Scope;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ScopeComparator
implements Comparator<Scope> {
    private static final String KAFKA_CLUSTER = "kafka-cluster";
    private static final ScopeComparator INSTANCE = new ScopeComparator();

    public static ScopeComparator getInstance() {
        return INSTANCE;
    }

    private ScopeComparator() {
    }

    @Override
    public int compare(Scope scope1, Scope scope2) {
        if (!scope1.path().equals(scope2.path())) {
            int shorter = Math.min(scope1.path().size(), scope2.path().size());
            for (int i = 0; i < shorter; ++i) {
                int pairwise = ((String)scope1.path().get(i)).compareTo((String)scope2.path().get(i));
                if (pairwise == 0) continue;
                return pairwise;
            }
            return scope1.path().size() - scope2.path().size();
        }
        return this.compare(scope1.clusters(), scope2.clusters());
    }

    @Override
    private int compare(Map<String, String> clusters1, Map<String, String> clusters2) {
        int compareKafkaClusters;
        if (clusters1.equals(clusters2)) {
            return 0;
        }
        String kafkaCluster1 = this.kafkaCluster(clusters1);
        String kafkaCluster2 = this.kafkaCluster(clusters2);
        if (kafkaCluster1 != null && kafkaCluster2 != null && (compareKafkaClusters = kafkaCluster1.compareTo(kafkaCluster2)) != 0) {
            return compareKafkaClusters;
        }
        if (kafkaCluster1 == null && kafkaCluster2 != null) {
            return -1;
        }
        if (kafkaCluster1 != null && kafkaCluster2 == null) {
            return 1;
        }
        String sortedClusters1 = this.toString(clusters1);
        String sortedClusters2 = this.toString(clusters2);
        return sortedClusters1.compareTo(sortedClusters2);
    }

    private String toString(Map<String, String> clusters) {
        List clusterStrs = clusters.entrySet().stream().filter(x -> !((String)x.getKey()).equals(KAFKA_CLUSTER)).map(x -> (String)x.getKey() + "=" + (String)x.getValue()).sorted().collect(Collectors.toList());
        return String.join((CharSequence)"&", clusterStrs);
    }

    private String kafkaCluster(Map<String, String> clusters) {
        return clusters.get(KAFKA_CLUSTER);
    }
}

