/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.rbacapi.comparators.ScopeComparator;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.rbac.RoleBinding;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;

public class ManagedRoleBinding
implements Comparable<ManagedRoleBinding> {
    @JsonProperty(value="roleBinding")
    public final RoleBinding roleBinding;
    @JsonProperty(value="alterAccess")
    public final boolean alterAccess;
    private static final Comparator<ManagedRoleBinding> comparator = Comparator.comparing(ManagedRoleBinding::principalString).thenComparing(rbaa -> rbaa.roleBinding.role()).thenComparing(rbaa -> rbaa.roleBinding.scope(), ScopeComparator.getInstance()).thenComparing(ManagedRoleBinding::resourcePatternString).thenComparing(rbaa -> rbaa.alterAccess);

    @JsonCreator
    public ManagedRoleBinding(@JsonProperty(value="roleBinding") RoleBinding roleBinding, @JsonProperty(value="alterAccess") boolean alterAccess) {
        this.roleBinding = roleBinding;
        this.alterAccess = alterAccess;
    }

    private String principalString() {
        return this.roleBinding.principal().toString();
    }

    private String resourcePatternString() {
        return this.roleBinding.resources().stream().map(ResourcePattern::toString).sorted().collect(Collectors.joining(","));
    }

    @Override
    public int compareTo(ManagedRoleBinding o) {
        return comparator.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedRoleBinding that = (ManagedRoleBinding)o;
        return this.alterAccess == that.alterAccess && Objects.equals(this.roleBinding, that.roleBinding);
    }

    public int hashCode() {
        return Objects.hash(this.roleBinding, this.alterAccess);
    }

    public String toString() {
        return "RoleBindingAlterAccess{roleBinding=" + this.roleBinding + ", alterAccess=" + this.alterAccess + '}';
    }
}

