/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.Scope;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class MdsScope {
    private final String clusterName;
    private final Scope scope;

    public static MdsScope of(Scope scope) {
        return new MdsScope(scope);
    }

    public MdsScope(@JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="path") List<String> path, @JsonProperty(value="clusters") Map<String, String> clusters) {
        this.clusterName = clusterName;
        this.scope = path == null && (clusters == null || clusters.isEmpty()) ? (clusterName != null ? null : Scope.ROOT_SCOPE) : new Scope(path, clusters);
    }

    public MdsScope(String clusterName, Scope scope) {
        this.clusterName = clusterName;
        this.scope = scope;
    }

    public MdsScope(String clusterName) {
        this.clusterName = clusterName;
        this.scope = null;
    }

    public MdsScope(Scope scope) {
        this.clusterName = null;
        this.scope = scope;
    }

    @JsonProperty
    public String clusterName() {
        return this.clusterName;
    }

    public Scope scope() {
        return this.scope;
    }

    @JsonProperty
    public List<String> path() {
        return this.scope == null ? Collections.emptyList() : this.scope.path();
    }

    @JsonProperty
    public Map<String, String> clusters() {
        return this.scope == null ? Collections.emptyMap() : this.scope.clusters();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MdsScope that = (MdsScope)o;
        return this.clusterName != null && that.clusterName != null && Objects.equals(this.clusterName, that.clusterName) || Objects.equals(this.scope.path(), that.scope.path()) && Objects.equals(this.scope.clusters(), that.scope.clusters());
    }

    public int hashCode() {
        if (this.clusterName != null) {
            return Objects.hash(this.clusterName);
        }
        return Objects.hash(this.scope);
    }

    public String toString() {
        if (this.scope == null) {
            return "MdsScope(clusterName=" + this.clusterName + ")";
        }
        return "MdsScope(clusterName=" + this.clusterName + ", " + this.scope.toString() + ")";
    }
}

