/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.errorhandlers;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class NoJettyDefaultStackTraceErrorHandler
extends ErrorHandler {
    private static final String JAVAX_ERROR_MESSAGE_ATTRIBUTE = "javax.servlet.error.message";
    private static final String JAVAX_ERROR_EXCEPTION_ATTRIBUTE = "javax.servlet.error.exception";

    public NoJettyDefaultStackTraceErrorHandler() {
        this.setShowStacks(false);
        this.setShowServlet(false);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.defaultRequestAcceptHeaderToJson(baseRequest);
        request = this.handleStatusException(request, response);
        this.doError(target, baseRequest, request, response);
    }

    private HttpServletRequest handleStatusException(HttpServletRequest request, HttpServletResponse response) {
        switch (response.getStatus()) {
            case 500: {
                String internalServerErrorMessage = "Internal Server Error";
                request.setAttribute(JAVAX_ERROR_MESSAGE_ATTRIBUTE, (Object)internalServerErrorMessage);
                request.setAttribute(JAVAX_ERROR_EXCEPTION_ATTRIBUTE, null);
                return request;
            }
        }
        return request;
    }

    private void defaultRequestAcceptHeaderToJson(Request baseRequest) {
        String acceptHeaderValue = baseRequest.getHttpFields().get(HttpHeader.ACCEPT);
        if (acceptHeaderValue == null || acceptHeaderValue.equals("*/*")) {
            baseRequest.getHttpFields().put(HttpHeader.ACCEPT, "application/json");
        }
    }
}

