/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.login;

import io.confluent.security.auth.metadata.PasswordVerifier;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.jaas.spi.LdapLoginModule;
import org.eclipse.jetty.util.security.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPasswordVerifier
implements PasswordVerifier {
    private static final Logger log = LoggerFactory.getLogger(LdapPasswordVerifier.class);

    public LdapPasswordVerifier() {
        log.info("Created LDAP password verifier");
    }

    public void configure(Map<String, ?> configs) {
    }

    public PasswordVerifier.Result verify(char[] ldapPassword, char[] loginPassword) {
        if (ldapPassword == null || loginPassword == null) {
            return PasswordVerifier.Result.MISMATCH;
        }
        String password = LdapLoginModule.convertCredentialLdapToJetty((String)new String(ldapPassword));
        Credential ldapCredential = Credential.getCredential((String)password);
        if (ldapCredential.check((Object)loginPassword)) {
            return PasswordVerifier.Result.MATCH;
        }
        return PasswordVerifier.Result.MISMATCH;
    }

    public void close() throws IOException {
    }
}

