/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jetty.util.StringUtil;

public class MdsFeatures {
    private static final String BASELINE_FEATURES_FILE = "/mds_v1_baseline_features.json";
    public static final String BASIC_AUTH = "basic.auth.1.enabled";
    public static final String TOKEN_GENERATION = "token.generation.1.enabled";
    public static final String TOKEN_VALIDATION = "token.validation.1.enabled";
    public static final String OIDC = "oidc.login.1.enabled";
    private static final Set<String> knownConfigDrivenFeatures = ImmutableSet.of((Object)"basic.auth.1.enabled", (Object)"token.generation.1.enabled", (Object)"token.validation.1.enabled", (Object)"oidc.login.1.enabled");
    private final TreeMap<String, Boolean> features;
    private final TreeMap<String, String> legend;

    public static MdsFeatures loadBaselineFeatures(ObjectMapper objectMapper) {
        InputStream mdsFeaturesBaselineData = MdsFeatures.class.getResourceAsStream(BASELINE_FEATURES_FILE);
        try {
            return (MdsFeatures)objectMapper.readValue(mdsFeaturesBaselineData, (TypeReference)new TypeReference<MdsFeatures>(){});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to load MDS baseline features", ioe);
        }
    }

    public MdsFeatures(@JsonProperty(value="features") TreeMap<String, Boolean> features, @JsonProperty(value="legend") TreeMap<String, String> legend) {
        this.features = features;
        this.legend = legend;
        Preconditions.checkArgument((boolean)features.keySet().containsAll(knownConfigDrivenFeatures));
        Preconditions.checkArgument((boolean)legend.keySet().containsAll(knownConfigDrivenFeatures));
        Preconditions.checkArgument((boolean)features.keySet().containsAll(legend.keySet()));
        Preconditions.checkArgument((boolean)legend.keySet().containsAll(features.keySet()));
    }

    @JsonProperty
    public Map<String, Boolean> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    @JsonProperty
    public Map<String, String> getLegend() {
        return Collections.unmodifiableMap(this.legend);
    }

    public void markBasicAuthEnabled() {
        this.markConfigFeature(BASIC_AUTH);
    }

    public void markTokenGenerationEnabled() {
        this.markConfigFeature(TOKEN_GENERATION);
    }

    public void markTokenValidationEnabled() {
        this.markConfigFeature(TOKEN_VALIDATION);
    }

    public void markOidcEnabled() {
        this.markConfigFeature(OIDC);
    }

    private void markConfigFeature(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Feature key should not be null.");
        Preconditions.checkArgument((boolean)StringUtil.isNotBlank((String)key));
        Preconditions.checkArgument((boolean)key.endsWith(".enabled"), (Object)"Config feature key should end with '.enabled'");
        this.features.put(key, true);
    }
}

