/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.UUID;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={OrganizationIdValidator.class})
public @interface ValidOrganizationId {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Organization ID.";

    public static class OrganizationIdValidator
    implements ConstraintValidator<ValidOrganizationId, String> {
        public void initialize(ValidOrganizationId constraintAnnotation) {
        }

        public boolean isValid(String organizationId, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            try {
                UUID.fromString(organizationId);
            }
            catch (IllegalArgumentException e) {
                context.buildConstraintViolationWithTemplate("Invalid organization ID, should be a UUID : " + organizationId).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

