/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={PrincipalValidator.class})
public @interface ValidPrincipal {
    public static final Set<String> validPrincipalTypes = Utils.mkSet((Object[])new String[]{"User", "Group"});

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Principal. Found: ${validatedValue}";

    public static class PrincipalValidator
    implements ConstraintValidator<ValidPrincipal, String> {
        public void initialize(ValidPrincipal constraintAnnotation) {
        }

        public boolean isValid(String principal, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            boolean valid = true;
            try {
                KafkaPrincipal parsedPrincipal = SecurityUtils.parseKafkaPrincipal((String)principal);
                if (!validPrincipalTypes.contains(parsedPrincipal.getPrincipalType())) {
                    valid = false;
                } else if (parsedPrincipal.getName().isEmpty()) {
                    valid = false;
                }
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
            if (!valid) {
                context.buildConstraintViolationWithTemplate("Invalid principal : " + principal).addConstraintViolation();
            }
            return valid;
        }
    }
}

