/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKey;
import com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedKeyBundle
extends KeyBundle {
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;
    private Boolean managed;

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public DeletedKeyBundle setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    @Override
    public Boolean isManaged() {
        return this.managed;
    }

    @Override
    public DeletedKeyBundle setKey(JsonWebKey key) {
        super.setKey(key);
        return this;
    }

    @Override
    public DeletedKeyBundle setAttributes(KeyAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    @Override
    public DeletedKeyBundle setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public DeletedKeyBundle setReleasePolicy(KeyReleasePolicy releasePolicy) {
        super.setReleasePolicy(releasePolicy);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", (JsonSerializable)this.getKey());
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.getAttributes());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("release_policy", (JsonSerializable)this.getReleasePolicy());
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedKeyBundle fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedKeyBundle)jsonReader.readObject(reader -> {
            DeletedKeyBundle deserializedDeletedKeyBundle = new DeletedKeyBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedDeletedKeyBundle.setKey(JsonWebKey.fromJson(reader));
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedKeyBundle.setAttributes(KeyAttributes.fromJson(reader));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedKeyBundle.setTags(tags);
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedDeletedKeyBundle.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    deserializedDeletedKeyBundle.setReleasePolicy(KeyReleasePolicy.fromJson(reader));
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedKeyBundle.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedKeyBundle.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedKeyBundle.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedKeyBundle;
        });
    }
}

