/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public final class TopicPlacement {
    @JsonProperty(value="observerPromotionPolicy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final ObserverPromotionPolicy observerPromotionPolicy;
    private final int version;
    private final List<ConstraintCount> replicas;
    private final List<ConstraintCount> observers;
    public static final int LATEST_VERSION = 2;
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    public static final ConfigDef.Validator VALIDATOR;

    @JsonCreator
    private TopicPlacement(@JsonProperty(value="observerPromotionPolicy") ObserverPromotionPolicy observerPromotionPolicy, @JsonProperty(value="version") int version, @JsonProperty(value="replicas") List<ConstraintCount> replicas, @JsonProperty(value="observers") List<ConstraintCount> observers) {
        this.version = version;
        this.observerPromotionPolicy = observerPromotionPolicy;
        this.replicas = replicas == null ? Collections.emptyList() : replicas;
        this.observers = observers == null ? Collections.emptyList() : observers;
    }

    public String toString() {
        return "TopicPlacement(version=" + this.version + (this.version() > 1 ? "observerPromotionPolicy=" + this.observerPromotionPolicy().toString() : "") + ",replicas=" + this.replicas + ",observers=" + this.observers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicPlacement)) {
            return false;
        }
        TopicPlacement tp = (TopicPlacement)o;
        return Objects.equals(tp.version(), this.version) && Objects.equals((Object)tp.observerPromotionPolicy(), (Object)this.observerPromotionPolicy()) && Objects.equals(tp.replicas(), this.replicas) && Objects.equals(tp.observers(), this.observers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.observerPromotionPolicy(), this.replicas, this.observers});
    }

    @JsonProperty(value="version", required=true)
    public int version() {
        return this.version;
    }

    public ObserverPromotionPolicy observerPromotionPolicy() {
        if (this.observerPromotionPolicy == null) {
            return ObserverPromotionPolicy.defaultPolicy(this.version());
        }
        return this.observerPromotionPolicy;
    }

    @JsonProperty(value="replicas")
    public List<ConstraintCount> replicas() {
        return this.replicas;
    }

    @JsonProperty(value="observers")
    public List<ConstraintCount> observers() {
        return this.observers;
    }

    public boolean hasObserverConstraints() {
        return !this.observers.isEmpty();
    }

    public boolean matchesReplicas(Map<String, String> attributes) {
        return this.replicas.stream().anyMatch(constraintCount -> constraintCount.matches(attributes));
    }

    public boolean matchesObservers(Map<String, String> attributes) {
        return this.observers.stream().anyMatch(constraintCount -> constraintCount.matches(attributes));
    }

    public static Optional<TopicPlacement> parse(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Optional.empty();
        }
        try {
            TopicPlacement topicPlacement = (TopicPlacement)JSON_SERDE.readValue(value, TopicPlacement.class);
            if (topicPlacement == null) {
                throw new IllegalArgumentException("Value cannot be the JSON null: " + value);
            }
            if (topicPlacement.version() == 1 && topicPlacement.observerPromotionPolicy != null) {
                throw new IllegalArgumentException("Topic placement constraint version 1 does not support observerPromotionPolicy");
            }
            if (topicPlacement.version() > 2 || topicPlacement.version() < 1) {
                throw new IllegalArgumentException("Version " + topicPlacement.version() + " is not supported or the version property was not specified");
            }
            if (topicPlacement.replicas().isEmpty()) {
                throw new IllegalArgumentException("At least one replica constraint must be specified.");
            }
            for (ConstraintCount constraint : topicPlacement.replicas) {
                if (constraint.count() >= 1) continue;
                throw new IllegalArgumentException("Replica constraint count cannot less than one.");
            }
            for (ConstraintCount constraint : topicPlacement.observers) {
                if (constraint.count() >= 1) continue;
                throw new IllegalArgumentException("Observer constraint count cannot be less than one.");
            }
            return Optional.of(topicPlacement);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception while parsing placement configuration", e);
        }
    }

    public String toJson() {
        try {
            return JSON_SERDE.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<String> validateAssignment(TopicPlacement topicPlacement, List<Replica> syncReplicas, List<Replica> observers) {
        Optional<String> syncMessage = TopicPlacement.matchesConstraints(topicPlacement.replicas(), syncReplicas).map(message -> String.format(message, "sync replicas"));
        if (syncMessage.isPresent()) {
            return syncMessage;
        }
        return TopicPlacement.matchesConstraints(topicPlacement.observers(), observers).map(message -> String.format(message, "observers"));
    }

    private static Optional<String> matchesConstraints(List<ConstraintCount> constraints, List<Replica> replicas) {
        ArrayList<Replica> invalidReplicas = new ArrayList<Replica>();
        ArrayList<ConstraintCount> pendingConstraints = new ArrayList<ConstraintCount>(constraints);
        ArrayList<Replica> sortedReplicas = new ArrayList<Replica>(replicas);
        sortedReplicas.sort(Comparator.comparingInt(replica -> replica.attributes().isPresent() ? 0 : 1));
        for (Replica replica2 : sortedReplicas) {
            boolean matched = false;
            ArrayList<ConstraintCount> currentConstraints = pendingConstraints;
            pendingConstraints = new ArrayList();
            for (ConstraintCount constraint : currentConstraints) {
                if (matched) {
                    pendingConstraints.add(constraint);
                    continue;
                }
                matched = replica2.attributes().map(Stream::of).orElse(Stream.empty()).allMatch(attributes -> constraint.matches((Map<String, String>)attributes));
                if (matched) {
                    if (constraint.count() <= 1) continue;
                    pendingConstraints.add(ConstraintCount.of(constraint.count() - 1, constraint.constraints));
                    continue;
                }
                pendingConstraints.add(constraint);
            }
            if (matched) continue;
            invalidReplicas.add(replica2);
        }
        return TopicPlacement.generateError(constraints, replicas, invalidReplicas, pendingConstraints);
    }

    private static Optional<String> generateError(List<ConstraintCount> constraints, List<Replica> replicas, List<Replica> invalidReplicas, List<ConstraintCount> pendingConstraints) {
        Optional<String> message = Optional.empty();
        if (invalidReplicas.isEmpty() && !pendingConstraints.isEmpty()) {
            List replicaIds = replicas.stream().map(replica -> replica.id()).collect(Collectors.toList());
            int constraintSum = constraints.stream().mapToInt(constraint -> constraint.count()).sum();
            message = Optional.of(String.format("Number of assigned replicas (%s) doesn't match the %%s constraint counts %s", replicaIds, constraintSum));
        } else if (!invalidReplicas.isEmpty() || !pendingConstraints.isEmpty()) {
            List invalidReplicaIds = invalidReplicas.stream().map(replica -> replica.id()).collect(Collectors.toList());
            Set matchingReplicaIds = replicas.stream().map(replica -> replica.id()).collect(Collectors.toSet());
            matchingReplicaIds.removeAll(new HashSet(invalidReplicaIds));
            message = Optional.of(String.format("Replicas (%s) do not match the %%s constraints (%s). The following replicas matched: %s.", invalidReplicaIds, constraints, matchingReplicaIds));
        }
        return message;
    }

    static {
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        VALIDATOR = new TopicPlacementValidator();
    }

    public static final class TopicPlacementValidator
    implements ConfigDef.Validator {
        private TopicPlacementValidator() {
        }

        public void ensureValid(String name, Object o) {
            if (o == null) {
                return;
            }
            try {
                TopicPlacement.parse((String)o);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException(name, o, e.getMessage());
            }
        }
    }

    public static final class Replica {
        private final int id;
        private final Optional<Map<String, String>> attributes;

        private Replica(int id, Optional<Map<String, String>> attributes) {
            this.id = id;
            this.attributes = attributes;
        }

        public int id() {
            return this.id;
        }

        public Optional<Map<String, String>> attributes() {
            return this.attributes;
        }

        public String toString() {
            return "Replica(id=" + this.id + ",attributes=" + this.attributes + ")";
        }

        public static Replica of(int id, Optional<Map<String, String>> attributes) {
            return new Replica(id, attributes);
        }
    }

    public static final class ConstraintCount {
        private final int count;
        private final Map<String, String> constraints;

        @JsonCreator
        private ConstraintCount(@JsonProperty(value="count") int count, @JsonProperty(value="constraints") Map<String, String> constraints) {
            this.count = count;
            this.constraints = constraints == null ? Collections.emptyMap() : constraints;
            this.constraints.values().removeIf(value -> value == null || value.trim().isEmpty());
        }

        @JsonProperty(value="count")
        public int count() {
            return this.count;
        }

        @JsonProperty(value="constraints")
        public Map<String, String> constraints() {
            return this.constraints;
        }

        public boolean matches(Map<String, String> attributes) {
            return ConstraintCount.isSubset(this.constraints, attributes);
        }

        public static boolean isSubset(Map<String, String> attributes1, Map<String, String> attributes2) {
            return attributes2.entrySet().containsAll(attributes1.entrySet());
        }

        public String toString() {
            return "ConstraintCount(count=" + this.count + ",constraints=" + this.constraints + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstraintCount)) {
                return false;
            }
            ConstraintCount cc = (ConstraintCount)o;
            return Objects.equals(cc.count(), this.count) && Objects.equals(cc.constraints(), this.constraints);
        }

        public int hashCode() {
            return Objects.hash(this.count, this.constraints);
        }

        public static ConstraintCount of(int count, Map<String, String> constraint) {
            return new ConstraintCount(count, constraint);
        }
    }

    public static enum ObserverPromotionPolicy {
        UNDER_MIN_ISR,
        UNDER_REPLICATED,
        LEADER_IS_OBSERVER;


        public static ObserverPromotionPolicy defaultPolicy(int version) {
            if (version < 2) {
                return LEADER_IS_OBSERVER;
            }
            return UNDER_MIN_ISR;
        }

        public static ObserverPromotionPolicy defaultPolicy() {
            return UNDER_MIN_ISR;
        }
    }
}

