/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.AutoValue_Partition;
import io.confluent.kafkarest.entities.PartitionReplica;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.common.TopicPartition;

@AutoValue
public abstract class Partition {
    Partition() {
    }

    public abstract String getClusterId();

    public abstract String getTopicName();

    public abstract int getPartitionId();

    public abstract ImmutableList<PartitionReplica> getReplicas();

    @Nullable
    public abstract Long getEarliestOffset();

    @Nullable
    public abstract Long getLatestOffset();

    public final Optional<PartitionReplica> getLeader() {
        return this.getReplicas().stream().filter(PartitionReplica::isLeader).findAny();
    }

    public static Partition create(String clusterId, String topicName, int partitionId, List<PartitionReplica> replicas) {
        return Partition.create(clusterId, topicName, partitionId, replicas, null, null);
    }

    public static Partition create(String clusterId, String topicName, int partitionId, List<PartitionReplica> replicas, @Nullable Long earliestOffset, @Nullable Long latestOffset) {
        return new AutoValue_Partition(clusterId, topicName, partitionId, (ImmutableList<PartitionReplica>)ImmutableList.copyOf(replicas), earliestOffset, latestOffset);
    }

    public TopicPartition toTopicPartition() {
        return new TopicPartition(this.getTopicName(), this.getPartitionId());
    }
}

