/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.v3.AutoValue_PartitionData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
public abstract class PartitionData
extends Resource {
    PartitionData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="partition_id")
    public abstract int getPartitionId();

    @JsonProperty(value="leader")
    public abstract Optional<Resource.Relationship> getLeader();

    @JsonProperty(value="replicas")
    public abstract Resource.Relationship getReplicas();

    @JsonProperty(value="reassignment")
    public abstract Resource.Relationship getReassignment();

    public static Builder builder() {
        return new AutoValue_PartitionData.Builder().setKind("KafkaPartition");
    }

    public static Builder fromPartition(Partition partition) {
        return PartitionData.builder().setClusterId(partition.getClusterId()).setTopicName(partition.getTopicName()).setPartitionId(partition.getPartitionId());
    }

    @JsonCreator
    static PartitionData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partition_id") int partitionId, @JsonProperty(value="leader") @Nullable Resource.Relationship leader, @JsonProperty(value="replicas") Resource.Relationship replicas, @JsonProperty(value="reassignment") Resource.Relationship reassignment) {
        return ((Builder)((Builder)PartitionData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setTopicName(topicName).setPartitionId(partitionId).setLeader(leader).setReplicas(replicas).setReassignment(reassignment).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setTopicName(String var1);

        public abstract Builder setPartitionId(int var1);

        public abstract Builder setLeader(@Nullable Resource.Relationship var1);

        public abstract Builder setReplicas(Resource.Relationship var1);

        public abstract Builder setReassignment(Resource.Relationship var1);

        public abstract PartitionData build();
    }
}

