/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.ratelimit;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import java.util.Objects;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;

final class FixedCostRateLimitRequestFilter
implements ContainerRequestFilter {
    private final RequestRateLimiter genericRateLimiter;
    private final int cost;
    private final LoadingCache<String, RequestRateLimiter> perClusterRateLimiterCache;

    FixedCostRateLimitRequestFilter(RequestRateLimiter genericRateLimiter, int cost, LoadingCache<String, RequestRateLimiter> perClusterRateLimiterCache) {
        Preconditions.checkArgument((cost > 0 ? 1 : 0) != 0, (Object)"Cost must be positive");
        this.genericRateLimiter = Objects.requireNonNull(genericRateLimiter);
        this.cost = cost;
        this.perClusterRateLimiterCache = Objects.requireNonNull(perClusterRateLimiterCache);
    }

    public void filter(ContainerRequestContext requestContext) {
        String clusterId = (String)requestContext.getUriInfo().getPathParameters(true).getFirst((Object)"clusterId");
        if (clusterId != null) {
            RequestRateLimiter rateLimiter = (RequestRateLimiter)this.perClusterRateLimiterCache.getUnchecked((Object)clusterId);
            rateLimiter.rateLimit(this.cost);
        }
        this.genericRateLimiter.rateLimit(this.cost);
    }
}

