/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceRequestDataJsonConverter;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.ProduceResponseDataJsonConverter;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.server.audit.KafkaRequestEvent;

public class ProduceRequestAuditExtractor {
    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        RequestContext requestContext = (RequestContext)requestEvent.requestContext();
        ProduceResponseData produceResponseData = ProduceResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        requestEvent.requestPayload().path("topicData").forEach(topic -> topic.path("partitionData").forEach(partition -> ((ObjectNode)partition).putIfAbsent("records", null)));
        ProduceRequestData produceRequestData = ProduceRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        for (ProduceResponseData.TopicProduceResponse topicProduceResponse : produceResponseData.responses()) {
            String topicName = topicProduceResponse.name();
            String transformedTopicName = (requestContext.tenantPrefix().isPresent() ? (String)requestContext.tenantPrefix().get() : "") + topicName;
            Uuid topicId = Uuid.ZERO_UUID;
            for (ProduceResponseData.PartitionProduceResponse partitionProduceResponse : topicProduceResponse.partitionResponses()) {
                ProduceConsumeAuditLogTracker.TopicDetails topicDetails = new ProduceConsumeAuditLogTracker.TopicDetails(topicId, topicName);
                ProduceConsumeAuditLogTracker.TopicDetails transformedTopicDetails = new ProduceConsumeAuditLogTracker.TopicDetails(topicId, transformedTopicName);
                if (requestContext.produceConsumeAuditLogTracker.hasProduceTopic(transformedTopicDetails).booleanValue()) continue;
                if (Errors.forCode((short)partitionProduceResponse.errorCode()).equals((Object)Errors.NONE)) {
                    requestContext.produceConsumeAuditLogTracker.addProduceTopic(transformedTopicDetails);
                }
                boolean hasAuthorizationFailure = AuditLogUtils.hasAuthorizationFailure(partitionProduceResponse.errorCode());
                Struct requestData = ProduceRequestAuditExtractor.requestData(topicDetails, produceRequestData);
                Struct resultData = ProduceRequestAuditExtractor.resultData(partitionProduceResponse);
                Result.Status status = ProduceRequestAuditExtractor.status(partitionProduceResponse);
                List<TypedCloudResourceRef> typedCloudResourceRefList = ProduceRequestAuditExtractor.typedCloudResourceRefList(requestEvent, topicName);
                ResourcePattern resourcePattern = new ResourcePattern("Topic", topicName, PatternType.LITERAL);
                String resourceCrn = AuditLogUtils.requestResourceCrn(extractorOptions.crnAuthority(), requestEvent, resourcePattern);
                AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, false, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
                extractedAuditLogs.add(auditLog);
            }
        }
        return extractedAuditLogs;
    }

    private static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent, String topicName) {
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.TOPIC).setResourceId(topicName).build());
        return typedCloudResourceRefList;
    }

    private static Struct requestData(ProduceConsumeAuditLogTracker.TopicDetails topicDetails, ProduceRequestData produceRequestData) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("transactionalId", (JsonNode)new TextNode(produceRequestData.transactionalId()));
        jsonNode.set("acks", (JsonNode)new ShortNode(produceRequestData.acks()));
        jsonNode.set("topic", (JsonNode)new TextNode(topicDetails.topicName()));
        jsonNode.set("partition", (JsonNode)NullNode.getInstance());
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(ProduceResponseData.PartitionProduceResponse partitionProduceResponse) {
        if (partitionProduceResponse.errorCode() == Errors.NONE.code()) {
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    private static Struct resultData(ProduceResponseData.PartitionProduceResponse partitionProduceResponse) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("offset", (JsonNode)NullNode.getInstance());
        jsonNode.set("message", (JsonNode)new TextNode(partitionProduceResponse.errorMessage()));
        jsonNode.set("errorCode", (JsonNode)new ShortNode(partitionProduceResponse.errorCode()));
        jsonNode.set("errorType", (JsonNode)new TextNode(Errors.forCode((short)partitionProduceResponse.errorCode()).name()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

