/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.util;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.tools.migrations.util.MigrationVersionInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MigrationVersionInfoFormatter {
    private static final List<VersionInfoField> VERSION_INFO_FIELDS = ImmutableList.of((Object)new VersionInfoField("Version", vInfo -> String.valueOf(vInfo.getVersion())), (Object)new VersionInfoField("Name", MigrationVersionInfo::getName), (Object)new VersionInfoField("State", vInfo -> vInfo.getState().toString()), (Object)new VersionInfoField("Previous Version", MigrationVersionInfo::getPrevVersion), (Object)new VersionInfoField("Started On", MigrationVersionInfo::getStartedOn), (Object)new VersionInfoField("Completed On", MigrationVersionInfo::getCompletedOn), (Object)new VersionInfoField("Error Reason", MigrationVersionInfo::getErrorReason));
    private final List<MigrationVersionInfo> versionInfos = new ArrayList<MigrationVersionInfo>();

    public void addVersionInfo(MigrationVersionInfo versionInfo) {
        this.versionInfos.add(versionInfo);
    }

    public String getFormatted() {
        List<Integer> columnLengths = VERSION_INFO_FIELDS.stream().map(field -> {
            int maxLength = Math.max(field.header.length(), this.versionInfos.stream().map(field.extractor).map(String::length).max(Integer::compare).orElse(0));
            return maxLength;
        }).collect(Collectors.toList());
        String rowFormatString = MigrationVersionInfoFormatter.constructRowFormatString(columnLengths);
        StringBuilder builder = new StringBuilder();
        int totalColLength = (Integer)columnLengths.stream().reduce(Integer::sum).orElseThrow(IllegalStateException::new);
        int dividerLength = totalColLength + 3 * VERSION_INFO_FIELDS.size() - 1;
        String divider = StringUtils.repeat((String)"-", (int)dividerLength);
        builder.append(divider);
        builder.append("\n");
        builder.append(String.format(rowFormatString, VERSION_INFO_FIELDS.stream().map(f -> f.header).toArray()));
        builder.append(divider);
        builder.append("\n");
        for (MigrationVersionInfo result : this.versionInfos) {
            builder.append(String.format(rowFormatString, VERSION_INFO_FIELDS.stream().map(f -> f.extractor.apply(result)).toArray()));
        }
        builder.append(divider);
        builder.append("\n");
        return builder.toString();
    }

    private static String constructRowFormatString(List<Integer> lengths) {
        List columnFormatStrings = lengths.stream().map(MigrationVersionInfoFormatter::constructSingleColumnFormatString).collect(Collectors.toList());
        return String.format(" %s %n", String.join((CharSequence)" | ", columnFormatStrings));
    }

    private static String constructSingleColumnFormatString(Integer length) {
        return String.format("%%%ds", -1 * length);
    }

    private static class VersionInfoField {
        final String header;
        final Function<MigrationVersionInfo, String> extractor;

        VersionInfoField(String header, Function<MigrationVersionInfo, String> extractor) {
            this.header = header;
            this.extractor = extractor;
        }
    }
}

