/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.util;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.ClientOptions;
import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.util.KsqlException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public final class MigrationsUtil {
    public static final String MIGRATIONS_COMMAND = "ksql-migrations";

    private MigrationsUtil() {
    }

    public static Client getKsqlClient(MigrationConfig config) throws MigrationException {
        return MigrationsUtil.getKsqlClient(config, null);
    }

    public static Client getKsqlClient(MigrationConfig config, String headersFile) throws MigrationException {
        return MigrationsUtil.getKsqlClient(config.getString("ksql.server.url"), config.getString("ksql.auth.basic.username"), config.getPassword("ksql.auth.basic.password").value(), config.getString("ssl.truststore.location"), config.getPassword("ssl.truststore.password").value(), config.getString("ssl.keystore.location"), config.getPassword("ssl.keystore.password").value(), config.getPassword("ssl.key.password").value(), config.getString("ssl.key.alias"), config.getBoolean("ssl.alpn"), config.getBoolean("ssl.verify.host"), MigrationsUtil.loadRequestHeaders(headersFile));
    }

    public static Client getKsqlClient(String ksqlServerUrl, String username, String password, String sslTrustStoreLocation, String sslTrustStorePassword, String sslKeystoreLocation, String sslKeystorePassword, String sslKeyPassword, String sslKeyAlias, boolean sslAlpn, boolean sslVerifyHost, Map<String, String> requestHeaders) {
        return Client.create((ClientOptions)MigrationsUtil.createClientOptions(ksqlServerUrl, username, password, sslTrustStoreLocation, sslTrustStorePassword, sslKeystoreLocation, sslKeystorePassword, sslKeyPassword, sslKeyAlias, sslAlpn, sslVerifyHost, requestHeaders));
    }

    @VisibleForTesting
    static ClientOptions createClientOptions(String ksqlServerUrl, String username, String password, String sslTrustStoreLocation, String sslTrustStorePassword, String sslKeystoreLocation, String sslKeystorePassword, String sslKeyPassword, String sslKeyAlias, boolean useAlpn, boolean verifyHost, Map<String, String> requestHeaders) {
        URL url;
        try {
            url = new URL(ksqlServerUrl);
        }
        catch (MalformedURLException e) {
            throw new MigrationException("Invalid ksql server URL: " + ksqlServerUrl);
        }
        ClientOptions options = ClientOptions.create().setHost(url.getHost()).setPort(url.getPort());
        if (username != null && !username.isEmpty() || password != null && !password.isEmpty()) {
            options.setBasicAuthCredentials(username, password);
        }
        boolean useTls = ksqlServerUrl.trim().toLowerCase().startsWith("https://");
        options.setUseTls(useTls);
        if (useTls) {
            options.setTrustStore(sslTrustStoreLocation);
            options.setTrustStorePassword(sslTrustStorePassword);
            options.setKeyStore(sslKeystoreLocation);
            options.setKeyStorePassword(sslKeystorePassword);
            options.setKeyPassword(sslKeyPassword);
            options.setKeyAlias(sslKeyAlias);
            options.setUseAlpn(useAlpn);
            options.setVerifyHost(verifyHost);
        }
        if (requestHeaders != null) {
            options.setRequestHeaders(requestHeaders);
        }
        return options;
    }

    private static Map<String, String> loadRequestHeaders(String headersFile) {
        if (headersFile == null || headersFile.trim().isEmpty()) {
            return null;
        }
        try {
            return PropertiesUtil.loadProperties((File)new File(headersFile.trim()));
        }
        catch (KsqlException e) {
            throw new MigrationException("Could not parse headers file '" + headersFile + "'.");
        }
    }
}

