/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.internal;

import com.google.api.client.util.Beta;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

@Beta
public class QuotaProjectIdHidingCredentials
extends Credentials {
    private static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";
    private final Credentials wrappedCredentials;

    public QuotaProjectIdHidingCredentials(Credentials credentials) {
        this.wrappedCredentials = credentials;
    }

    public String getAuthenticationType() {
        return this.wrappedCredentials.getAuthenticationType();
    }

    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        ImmutableMap.Builder metaBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.wrappedCredentials.getRequestMetadata(uri).entrySet()) {
            if (((String)entry.getKey()).equals(QUOTA_PROJECT_ID_HEADER_KEY)) continue;
            metaBuilder.put(entry);
        }
        return metaBuilder.build();
    }

    public Map<String, List<String>> getRequestMetadata() throws IOException {
        return this.getRequestMetadata(null);
    }

    public boolean hasRequestMetadata() {
        return this.wrappedCredentials.hasRequestMetadata();
    }

    public boolean hasRequestMetadataOnly() {
        return this.wrappedCredentials.hasRequestMetadataOnly();
    }

    public void refresh() throws IOException {
        this.wrappedCredentials.refresh();
    }
}

