/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientContext {
    private final Map<String, Object> context = new HashMap<String, Object>();
    private static final Logger log = LoggerFactory.getLogger(ClientContext.class);

    public static ClientContext fromMap(Map<String, Object> context) {
        ClientContext ctx = new ClientContext();
        ctx.addAll(context);
        return ctx;
    }

    public Object add(String key, Object val) {
        return this.context.put(key, val);
    }

    public Object add(Map.Entry<String, Object> entry) {
        return this.context.put(entry.getKey(), entry.getValue());
    }

    public void addAll(Map<String, Object> entries) {
        this.context.putAll(entries);
    }

    public Map<String, Object> getContextMap() {
        return Collections.unmodifiableMap(this.context);
    }

    public String strVal(String key, String defValue) {
        return this.typeVal(key, String.class, defValue);
    }

    public String strVal(String key, String defValue, boolean emptyIsNull) {
        String val = this.typeVal(key, String.class);
        if (val == null || val.trim().equals("") && emptyIsNull) {
            return defValue;
        }
        return val;
    }

    public Integer intVal(String key, Integer defValue) {
        return this.typeVal(key, Integer.class);
    }

    public Double doubleVal(String key, Double defValue) {
        return this.typeVal(key, Double.class);
    }

    public <T> T typeVal(String key, Class<T> type, T defValue) {
        T val = this.typeVal(key, type);
        return val != null ? val : defValue;
    }

    private <T> T typeVal(String key, Class<T> type) {
        if (!this.context.containsKey(key)) {
            return null;
        }
        Object val = this.context.get(key);
        try {
            return type.cast(val);
        }
        catch (ClassCastException e) {
            log.error(String.format("Could not cast value for key %s to type %s", key, type.getName()), (Throwable)e);
            return null;
        }
    }

    public <T> T get(Function<Map<String, Object>, T> mapper) {
        return mapper.apply(Collections.unmodifiableMap(this.context));
    }
}

