/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.availability.AllThreadsStuck$;
import kafka.availability.AnyThreadStuck$;
import kafka.availability.BrokerHealthManager$;
import kafka.availability.BrokerHealthManagerConfig;
import kafka.availability.BrokerHealthManagerConfig$;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.HealthSamplesWindow;
import kafka.availability.HealthStatusAggregationOperator;
import kafka.availability.HealthStatusAggregationOperator_And$;
import kafka.availability.HealthStatusAggregationOperator_Or$;
import kafka.availability.Healthy$;
import kafka.availability.Suspect$;
import kafka.availability.ThreadCountersHealthStatusCriteria;
import kafka.availability.ThreadCountersHealthStatusCriteria$;
import kafka.availability.Unhealthy$;
import kafka.common.ControlledShutdownRequestReason;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.WeakHashMap;
import scala.collection.mutable.WeakHashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t=h\u0001B!C\u0001\u001dC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\ta\u0002\u0011\t\u0011)A\u0005c\"Aq\u000f\u0001B\u0001B\u0003%\u0001\u0010\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003\u0000\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013A\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u00033A\u0011\"a\n\u0001\u0001\u0004%\t!!\u000b\t\u0013\u0005E\u0002\u00011A\u0005\u0002\u0005M\u0002\u0002CA\u001d\u0001\u0001\u0006K!a\u000b\t\u0013\u0005\r\u0003\u00011A\u0005\u0002\u0005\u0015\u0003\"CA'\u0001\u0001\u0007I\u0011AA(\u0011!\t\u0019\u0006\u0001Q!\n\u0005\u001d\u0003\"CA,\u0001\u0001\u0007I\u0011AA-\u0011%\tY\u0006\u0001a\u0001\n\u0003\ti\u0006C\u0004\u0002b\u0001\u0001\u000b\u0015B>\t\u0013\u0005\u0015\u0004\u00011A\u0005\u0002\u0005\u001d\u0004\"CA5\u0001\u0001\u0007I\u0011AA6\u0011\u001d\ty\u0007\u0001Q!\n}D\u0011\"a\u001d\u0001\u0001\u0004%\t!!\u001e\t\u0013\u0005-\u0006\u00011A\u0005\u0002\u00055\u0006\u0002CAY\u0001\u0001\u0006K!a\u001e\t\u0013\u0005M\u0006\u00011A\u0005\n\u0005%\u0002\"CA[\u0001\u0001\u0007I\u0011BA\\\u0011!\tY\f\u0001Q!\n\u0005-\u0002\"CA_\u0001\u0001\u0007I\u0011BA`\u0011%\t9\r\u0001a\u0001\n\u0013\tI\r\u0003\u0005\u0002N\u0002\u0001\u000b\u0015BAa\u0011%\ty\r\u0001a\u0001\n\u0013\ty\fC\u0005\u0002R\u0002\u0001\r\u0011\"\u0003\u0002T\"A\u0011q\u001b\u0001!B\u0013\t\t\rC\u0005\u0002Z\u0002\u0011\r\u0011\"\u0003\u0002\\\"A!\u0011\u0004\u0001!\u0002\u0013\ti\u000eC\u0005\u0003\u001c\u0001\u0011\r\u0011\"\u0003\u0003\u001e!A!Q\u0005\u0001!\u0002\u0013\u0011y\u0002C\u0005\u0003(\u0001\u0001\r\u0011\"\u0003\u0002@\"I!\u0011\u0006\u0001A\u0002\u0013%!1\u0006\u0005\t\u0005_\u0001\u0001\u0015)\u0003\u0002B\"I!\u0011\u0007\u0001A\u0002\u0013%\u0011q\u0018\u0005\n\u0005g\u0001\u0001\u0019!C\u0005\u0005kA\u0001B!\u000f\u0001A\u0003&\u0011\u0011\u0019\u0005\n\u0005w\u0001\u0001\u0019!C\u0005\u0003\u007fC\u0011B!\u0010\u0001\u0001\u0004%IAa\u0010\t\u0011\t\r\u0003\u0001)Q\u0005\u0003\u0003DqA!\u0012\u0001\t\u0003\tI\u0006C\u0004\u0003H\u0001!\tA!\u0013\t\u000f\t-\u0003\u0001\"\u0011\u0003J!I!Q\n\u0001C\u0002\u0013%!q\n\u0005\t\u0005/\u0002\u0001\u0015!\u0003\u0003R!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B3\u0001\u0011\u0005!\u0011\n\u0005\b\u0005O\u0002A\u0011AA-\u0011\u001d\u0011I\u0007\u0001C!\u0005\u0013BqAa\u001b\u0001\t\u0003\u0011i\u0007C\u0004\u0003\u000e\u0002!\tAa$\t\u000f\t]\u0005\u0001\"\u0011\u0003J!9!\u0011\u0014\u0001\u0005B\tm\u0005b\u0002B[\u0001\u0011\u0005#q\u0017\u0005\b\u0005\u0007\u0004A\u0011\tBc\u000f\u001d\u0011iM\u0011E\u0001\u0005\u001f4a!\u0011\"\t\u0002\tE\u0007bBA\u0004{\u0011\u0005!\u0011\u001c\u0005\n\u00057l$\u0019!C\u0001\u0005;D\u0001B!<>A\u0003%!q\u001c\u0002\u0014\u0005J|7.\u001a:IK\u0006dG\u000f['b]\u0006<WM\u001d\u0006\u0003\u0007\u0012\u000bA\"\u0019<bS2\f'-\u001b7jifT\u0011!R\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001*V.\u0011\u0005%\u001bV\"\u0001&\u000b\u0005-c\u0015\u0001B;uS2T!!\u0014(\u0002\rM,'O^3s\u0015\t)uJ\u0003\u0002Q#\u00061\u0011\r]1dQ\u0016T\u0011AU\u0001\u0004_J<\u0017B\u0001+K\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\u0005YKV\"A,\u000b\u0005a#\u0015!B;uS2\u001c\u0018B\u0001.X\u0005\u001daunZ4j]\u001e\u0004\"\u0001\u00180\u000e\u0003uS!!\u0014#\n\u0005}k&\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW-\u0001\fd_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007j\\8l!\u0011\u0011WmZ7\u000e\u0003\rT\u0011\u0001Z\u0001\u0006g\u000e\fG.Y\u0005\u0003M\u000e\u0014\u0011BR;oGRLwN\\\u0019\u0011\u0005!\\W\"A5\u000b\u0005)$\u0015AB2p[6|g.\u0003\u0002mS\ny2i\u001c8ue>dG.\u001a3TQV$Hm\\<o%\u0016\fX/Z:u%\u0016\f7o\u001c8\u0011\u0005\tt\u0017BA8d\u0005\u0011)f.\u001b;\u0002\u0011i\\7\t\\5f]R\u0004\"A];\u000e\u0003MT!\u0001\u001e#\u0002\u0005i\\\u0017B\u0001<t\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006\u0011\u0012n]!di&4XmQ8oiJ|G\u000e\\3s!\r\u0011\u0017p_\u0005\u0003u\u000e\u0014\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\td\u0018BA?d\u0005\u001d\u0011un\u001c7fC:\fQ\"\u001b8ji&\fGnQ8oM&<\u0007\u0003BA\u0001\u0003\u0007i\u0011AQ\u0005\u0004\u0003\u000b\u0011%!\u0007\"s_.,'\u000fS3bYRDW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fa\u0001P5oSRtDCCA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014A\u0019\u0011\u0011\u0001\u0001\t\u000b\u0001,\u0001\u0019A1\t\u000bA,\u0001\u0019A9\t\u000b],\u0001\u0019\u0001=\t\u000by,\u0001\u0019A@\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}A*A\u0004nKR\u0014\u0018nY:\n\t\u0005\r\u0012Q\u0004\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!D7fiJL7m]$s_V\u0004\b%\u0001\u0007u_R\fGnU1na2,7/\u0006\u0002\u0002,A\u0019!-!\f\n\u0007\u0005=2M\u0001\u0003M_:<\u0017\u0001\u0005;pi\u0006d7+Y7qY\u0016\u001cx\fJ3r)\ri\u0017Q\u0007\u0005\n\u0003oI\u0011\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u00035!x\u000e^1m'\u0006l\u0007\u000f\\3tA!\u001a!\"!\u0010\u0011\u0007\t\fy$C\u0002\u0002B\r\u0014\u0001B^8mCRLG.Z\u0001\u0013EJ|7.\u001a:IK\u0006dG\u000f[*uCR,8/\u0006\u0002\u0002HA!\u0011\u0011AA%\u0013\r\tYE\u0011\u0002\u0013\u0005J|7.\u001a:IK\u0006dG\u000f[*uCR,8/\u0001\fce>\\WM\u001d%fC2$\bn\u0015;biV\u001cx\fJ3r)\ri\u0017\u0011\u000b\u0005\n\u0003oa\u0011\u0011!a\u0001\u0003\u000f\n1C\u0019:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;vg\u0002B3!DA\u001f\u0003MI7/T5uS\u001e\fG/[8o\u000b:\f'\r\\3e+\u0005Y\u0018aF5t\u001b&$\u0018nZ1uS>tWI\\1cY\u0016$w\fJ3r)\ri\u0017q\f\u0005\t\u0003oy\u0011\u0011!a\u0001w\u0006!\u0012n]'ji&<\u0017\r^5p]\u0016s\u0017M\u00197fI\u0002B3\u0001EA\u001f\u0003\u0019\u0019wN\u001c4jOV\tq0\u0001\u0006d_:4\u0017nZ0%KF$2!\\A7\u0011!\t9DEA\u0001\u0002\u0004y\u0018aB2p]\u001aLw\r\t\u0015\u0004'\u0005u\u0012a\b9sKZ$\u0006N]3bI2{7-\u00197D_VtG/\u001a:t':\f\u0007o\u001d5piV\u0011\u0011q\u000f\t\t\u0003s\n\t)!\"\u0002\u00126\u0011\u00111\u0010\u0006\u0004\u0017\u0006u$BAA@\u0003\u0011Q\u0017M^1\n\t\u0005\r\u00151\u0010\u0002\u0004\u001b\u0006\u0004\b\u0003BAD\u0003\u001bk!!!#\u000b\t\u0005-\u0015QP\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0010\u0006%%A\u0002+ie\u0016\fG\r\u0005\u0004\u0002z\u0005M\u0015qS\u0005\u0005\u0003+\u000bYH\u0001\u0003MSN$\b\u0003BAM\u0003Ok!!a'\u000b\u0007\r\u000biJC\u0002F\u0003?SA!!)\u0002$\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u0003K\u000b!![8\n\t\u0005%\u00161\u0014\u0002\u0014)\"\u0014X-\u00193M_\u000e\fGnQ8v]R,'o]\u0001$aJ,g\u000f\u00165sK\u0006$Gj\\2bY\u000e{WO\u001c;feN\u001cf.\u00199tQ>$x\fJ3r)\ri\u0017q\u0016\u0005\n\u0003o)\u0012\u0011!a\u0001\u0003o\n\u0001\u0005\u001d:fmRC'/Z1e\u0019>\u001c\u0017\r\\\"pk:$XM]:T]\u0006\u00048\u000f[8uA\u0005Q\u0002O]3w\u001dVl7i\\7qY\u0016$X\rZ*u_J\fw-Z(qg\u0006q\u0002O]3w\u001dVl7i\\7qY\u0016$X\rZ*u_J\fw-Z(qg~#S-\u001d\u000b\u0004[\u0006e\u0006\"CA\u001c1\u0005\u0005\t\u0019AA\u0016\u0003m\u0001(/\u001a<Ok6\u001cu.\u001c9mKR,Gm\u0015;pe\u0006<Wm\u00149tA\u0005Q2m\u001c8uS\u001e,x.^:V]\",\u0017\r\u001c;isN\u000bW\u000e\u001d7fgV\u0011\u0011\u0011\u0019\t\u0004E\u0006\r\u0017bAAcG\n\u0019\u0011J\u001c;\u0002=\r|g\u000e^5hk>,8/\u00168iK\u0006dG\u000f[=TC6\u0004H.Z:`I\u0015\fHcA7\u0002L\"I\u0011qG\u000e\u0002\u0002\u0003\u0007\u0011\u0011Y\u0001\u001cG>tG/[4v_V\u001cXK\u001c5fC2$\b._*b[BdWm\u001d\u0011\u00021\r|g\u000e^5hk>,8\u000fS3bYRD\u0017pU1na2,7/\u0001\u000fd_:$\u0018nZ;pkNDU-\u00197uQf\u001c\u0016-\u001c9mKN|F%Z9\u0015\u00075\f)\u000eC\u0005\u00028y\t\t\u00111\u0001\u0002B\u0006I2m\u001c8uS\u001e,x.^:IK\u0006dG\u000f[=TC6\u0004H.Z:!\u0003I\"\bN]3bIN#XoY6TC6\u0004H.Z:Cs\u000e{W\u000e]8oK:$H+\u001f9f\u0005f$\u0006N]3bI\u001e\u0013x.\u001e9UsB,WCAAo!!\ty.!;\u0002l\n=QBAAq\u0015\u0011\t\u0019/!:\u0002\u000f5,H/\u00192mK*\u0019\u0011q]2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0004\u0006\u0005\b\u0003BAw\u0005\u0013qA!a<\u0003\u00069!\u0011\u0011\u001fB\u0002\u001d\u0011\t\u0019P!\u0001\u000f\t\u0005U\u0018q \b\u0005\u0003o\fi0\u0004\u0002\u0002z*\u0019\u00111 $\u0002\rq\u0012xn\u001c;?\u0013\t\t)+\u0003\u0003\u0002\"\u0006\r\u0016bA#\u0002 &\u00191)!(\n\t\t\u001d\u00111T\u0001\u0014)\"\u0014X-\u00193M_\u000e\fGnQ8v]R,'o]\u0005\u0005\u0005\u0017\u0011iAA\bUQJ,\u0017\rZ$s_V\u0004H+\u001f9f\u0015\u0011\u00119!a'\u0011\u0011\u0005}\u0017\u0011\u001eB\t\u0005/\u0001B!!<\u0003\u0014%!!Q\u0003B\u0007\u0005MiU\r\u001e:jG\u000e{W\u000e]8oK:$H+\u001f9f!!\ty.!;\u0002\u0006\u0006-\u0012a\r;ie\u0016\fGm\u0015;vG.\u001c\u0016-\u001c9mKN\u0014\u0015pQ8na>tWM\u001c;UsB,')\u001f+ie\u0016\fGm\u0012:pkB$\u0016\u0010]3!\u0003q)h\u000e[3bYRD\u0017p\u0015;pe\u0006<WmU1na2,w+\u001b8e_^,\"Aa\b\u0011\t\u0005\u0005!\u0011E\u0005\u0004\u0005G\u0011%a\u0005%fC2$\bnU1na2,7oV5oI><\u0018!H;oQ\u0016\fG\u000e\u001e5z'R|'/Y4f'\u0006l\u0007\u000f\\3XS:$wn\u001e\u0011\u0002Q\r|g\u000e^5hk>,8oU1na2,7/\u00128hS:,G\u000b\u001b:fC\u0012<%o\\;qgN#XoY6\u0002Y\r|g\u000e^5hk>,8oU1na2,7/\u00128hS:,G\u000b\u001b:fC\u0012<%o\\;qgN#XoY6`I\u0015\fHcA7\u0003.!I\u0011qG\u0013\u0002\u0002\u0003\u0007\u0011\u0011Y\u0001*G>tG/[4v_V\u001c8+Y7qY\u0016\u001cXI\\4j]\u0016$\u0006N]3bI\u001e\u0013x.\u001e9t'R,8m\u001b\u0011\u0002S\r|g\u000e^5hk>,8oU1na2,7o\u0015;pe\u0006<W\r\u00165sK\u0006$wI]8vaN\u001cF/^2l\u00035\u001awN\u001c;jOV|Wo]*b[BdWm]*u_J\fw-\u001a+ie\u0016\fGm\u0012:pkB\u001c8\u000b^;dW~#S-\u001d\u000b\u0004[\n]\u0002\"CA\u001cQ\u0005\u0005\t\u0019AAa\u0003)\u001awN\u001c;jOV|Wo]*b[BdWm]*u_J\fw-\u001a+ie\u0016\fGm\u0012:pkB\u001c8\u000b^;dW\u0002\nafY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t\u001d>\u001cFo\u001c:bO\u0016$\u0006N]3bI6\u000b7.\u001b8h!J|wM]3tg\u0006\u00114m\u001c8uS\u001e,x.^:TC6\u0004H.Z:O_N#xN]1hKRC'/Z1e\u001b\u0006\\\u0017N\\4Qe><'/Z:t?\u0012*\u0017\u000fF\u0002n\u0005\u0003B\u0011\"a\u000e,\u0003\u0003\u0005\r!!1\u0002_\r|g\u000e^5hk>,8oU1na2,7OT8Ti>\u0014\u0018mZ3UQJ,\u0017\rZ'bW&tw\r\u0015:pOJ,7o\u001d\u0011\u0002\u0013%\u001c\b*Z1mi\"L\u0018!\u0004:f[>4X-T3ue&\u001c7\u000fF\u0001n\u0003!\u0019\b.\u001e;e_^t\u0017!\u00065be\u0012\u001c\u0006.\u001e;e_^t7k\u00195fIVdWM]\u000b\u0003\u0005#\u00022!\u0013B*\u0013\r\u0011)F\u0013\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003YA\u0017M\u001d3TQV$Hm\\<o'\u000eDW\rZ;mKJ\u0004\u0013aB5t'R,8m\u001b\u000b\u0006w\nu#\u0011\r\u0005\b\u0005?\u0012\u0004\u0019AAC\u0003\u0019!\bN]3bI\"9!1\r\u001aA\u0002\u0005]\u0015\u0001D2veJ\u001cu.\u001e8uKJ\u001c\u0018a\u00047pON#XoY6UQJ,\u0017\rZ:\u0002#%\u001c(I]8lKJ,f\u000e[3bYRD\u00170\u0001\u0004e_^{'o[\u0001\u0011gR\fG/^:Ue\u0006t7/\u001b;j_:$r!\u001cB8\u0005g\u00129\bC\u0004\u0003rY\u0002\r!a\u0012\u0002'\r,(O]3oi\"+\u0017\r\u001c;i'R\fG/^:\t\u000f\tUd\u00071\u0001\u0002H\u0005ya.Z<IK\u0006dG\u000f[*uCR,8\u000fC\u0004\u0003zY\u0002\rAa\u001f\u0002\u000fM\fW\u000e\u001d7fgB1!Q\u0010BD\u0003\u0003tAAa \u0003\u0004:!\u0011q\u001fBA\u0013\u0005!\u0017b\u0001BCG\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BE\u0005\u0017\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005\u000b\u001b\u0017a\u00077pO\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo]\"iC:<W\rF\u0004n\u0005#\u0013\u0019J!&\t\u000f\tEt\u00071\u0001\u0002H!9!QO\u001cA\u0002\u0005\u001d\u0003b\u0002B=o\u0001\u0007!1P\u0001\u0004eVt\u0017!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005;\u0003bAa(\u0003\"\n\u0015VBAAs\u0013\u0011\u0011\u0019+!:\u0003\u0007M+G\u000f\u0005\u0003\u0003(\n=f\u0002\u0002BU\u0005W\u00032!a>d\u0013\r\u0011ikY\u0001\u0007!J,G-\u001a4\n\t\tE&1\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t56-A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R\u0019QN!/\t\u000f\tm&\b1\u0001\u0003>\u0006Ia.Z<D_:4\u0017n\u001a\t\u00049\n}\u0016b\u0001Ba;\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\u000b5\u00149Ma3\t\u000f\t%7\b1\u0001\u0003>\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\b\u0005w[\u0004\u0019\u0001B_\u0003M\u0011%o\\6fe\"+\u0017\r\u001c;i\u001b\u0006t\u0017mZ3s!\r\t\t!P\n\u0004{\tM\u0007c\u00012\u0003V&\u0019!q[2\u0003\r\u0005s\u0017PU3g)\t\u0011y-A\u000bSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\t}\u0007C\u0002Bq\u0005O\u0014I/\u0004\u0002\u0003d*!!Q]As\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003$\n\r\b\u0003BAD\u0005WLAA!-\u0002\n\u00061\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\b\u0005")
public class BrokerHealthManager
extends ShutdownableThread
implements Logging,
BrokerReconfigurable {
    private final Function1<ControlledShutdownRequestReason, BoxedUnit> controlledShutdownHook;
    private final KafkaZkClient zkClient;
    private final Function0<Object> isActiveController;
    private final KafkaMetricsGroup metricsGroup;
    private volatile long totalSamples;
    private volatile BrokerHealthStatus brokerHealthStatus;
    private volatile boolean isMitigationEnabled;
    private volatile BrokerHealthManagerConfig config;
    private Map<Thread, List<ThreadLocalCounters>> prevThreadLocalCountersSnapshot;
    private long prevNumCompletedStorageOps;
    private int contiguousUnhealthySamples;
    private int contiguousHealthySamples;
    private final scala.collection.mutable.Map<ThreadLocalCounters.ThreadGroupType, scala.collection.mutable.Map<ThreadLocalCounters.MetricComponentType, scala.collection.mutable.Map<Thread, Object>>> threadStuckSamplesByComponentTypeByThreadGroupType;
    private final HealthSamplesWindow unhealthyStorageSampleWindow;
    private int contiguousSamplesEngineThreadGroupsStuck;
    private int contiguousSamplesStorageThreadGroupsStuck;
    private int contiguousSamplesNoStorageThreadMakingProgress;
    private final KafkaScheduler hardShutdownScheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return BrokerHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public long totalSamples() {
        return this.totalSamples;
    }

    public void totalSamples_$eq(long x$1) {
        this.totalSamples = x$1;
    }

    public BrokerHealthStatus brokerHealthStatus() {
        return this.brokerHealthStatus;
    }

    public void brokerHealthStatus_$eq(BrokerHealthStatus x$1) {
        this.brokerHealthStatus = x$1;
    }

    public boolean isMitigationEnabled() {
        return this.isMitigationEnabled;
    }

    public void isMitigationEnabled_$eq(boolean x$1) {
        this.isMitigationEnabled = x$1;
    }

    public BrokerHealthManagerConfig config() {
        return this.config;
    }

    public void config_$eq(BrokerHealthManagerConfig x$1) {
        this.config = x$1;
    }

    public Map<Thread, List<ThreadLocalCounters>> prevThreadLocalCountersSnapshot() {
        return this.prevThreadLocalCountersSnapshot;
    }

    public void prevThreadLocalCountersSnapshot_$eq(Map<Thread, List<ThreadLocalCounters>> x$1) {
        this.prevThreadLocalCountersSnapshot = x$1;
    }

    private long prevNumCompletedStorageOps() {
        return this.prevNumCompletedStorageOps;
    }

    private void prevNumCompletedStorageOps_$eq(long x$1) {
        this.prevNumCompletedStorageOps = x$1;
    }

    private int contiguousUnhealthySamples() {
        return this.contiguousUnhealthySamples;
    }

    private void contiguousUnhealthySamples_$eq(int x$1) {
        this.contiguousUnhealthySamples = x$1;
    }

    private int contiguousHealthySamples() {
        return this.contiguousHealthySamples;
    }

    private void contiguousHealthySamples_$eq(int x$1) {
        this.contiguousHealthySamples = x$1;
    }

    private scala.collection.mutable.Map<ThreadLocalCounters.ThreadGroupType, scala.collection.mutable.Map<ThreadLocalCounters.MetricComponentType, scala.collection.mutable.Map<Thread, Object>>> threadStuckSamplesByComponentTypeByThreadGroupType() {
        return this.threadStuckSamplesByComponentTypeByThreadGroupType;
    }

    private HealthSamplesWindow unhealthyStorageSampleWindow() {
        return this.unhealthyStorageSampleWindow;
    }

    private int contiguousSamplesEngineThreadGroupsStuck() {
        return this.contiguousSamplesEngineThreadGroupsStuck;
    }

    private void contiguousSamplesEngineThreadGroupsStuck_$eq(int x$1) {
        this.contiguousSamplesEngineThreadGroupsStuck = x$1;
    }

    private int contiguousSamplesStorageThreadGroupsStuck() {
        return this.contiguousSamplesStorageThreadGroupsStuck;
    }

    private void contiguousSamplesStorageThreadGroupsStuck_$eq(int x$1) {
        this.contiguousSamplesStorageThreadGroupsStuck = x$1;
    }

    private int contiguousSamplesNoStorageThreadMakingProgress() {
        return this.contiguousSamplesNoStorageThreadMakingProgress;
    }

    private void contiguousSamplesNoStorageThreadMakingProgress_$eq(int x$1) {
        this.contiguousSamplesNoStorageThreadMakingProgress = x$1;
    }

    public boolean isHealthy() {
        block3: {
            block2: {
                if (!this.isMitigationEnabled()) break block2;
                BrokerHealthStatus brokerHealthStatus = this.brokerHealthStatus();
                Healthy$ healthy$ = Healthy$.MODULE$;
                if (brokerHealthStatus == null || !brokerHealthStatus.equals(healthy$)) break block3;
            }
            return true;
        }
        return false;
    }

    public void removeMetrics() {
        this.metricsGroup().removeMetric("ContiguousUnhealthySamples");
        this.metricsGroup().removeMetric("ContiguousSamplesEngineThreadGroupsStuck");
        this.metricsGroup().removeMetric("ContiguousSamplesStorageThreadGroupsStuck");
        this.metricsGroup().removeMetric("ContiguousSamplesNoStorageThreadMakingProgress");
        this.metricsGroup().removeMetric("UnhealthinessCount");
        this.metricsGroup().removeMetric("StorageHealthStatus");
    }

    public void shutdown() {
        this.removeMetrics();
        super.shutdown();
    }

    private KafkaScheduler hardShutdownScheduler() {
        return this.hardShutdownScheduler;
    }

    public boolean isStuck(Thread thread, ThreadLocalCounters currCounters) {
        return this.isPrevCountersPresent$1() && this.isThreadStuck$1(thread, currCounters);
    }

    public void logStuckThreads() {
        this.threadStuckSamplesByComponentTypeByThreadGroupType().foreach((Function1 & Serializable)x0$1 -> {
            BrokerHealthManager.$anonfun$logStuckThreads$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isBrokerUnhealthy() {
        Map currentThreadLocalCounterSnapshotForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        LongRef currNumCompletedStorageOps = LongRef.create((long)0L);
        currentThreadLocalCounterSnapshotForAllThreads.forEach((thread, threadLocalCountersList) -> threadLocalCountersList.forEach(threadLocalCounters -> {
            boolean isThreadStuck = this.isStuck((Thread)thread, (ThreadLocalCounters)threadLocalCounters);
            ThreadLocalCounters.MetricComponentType metricComponentType = threadLocalCounters.metricComponentType;
            ThreadLocalCounters.MetricComponentType metricComponentType2 = ThreadLocalCounters.MetricComponentType.STORAGE;
            if (!(metricComponentType != null ? !metricComponentType.equals(metricComponentType2) : metricComponentType2 != null)) {
                currNumCompletedStorageOps$1.elem += threadLocalCounters.numSuccessOps + threadLocalCounters.numFailedOps;
            }
            scala.collection.mutable.Map threadToNumStuckSamplesMap = (scala.collection.mutable.Map)((scala.collection.mutable.Map)this.threadStuckSamplesByComponentTypeByThreadGroupType().getOrElseUpdate((Object)threadLocalCounters.threadGroupType, (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$))).getOrElseUpdate((Object)threadLocalCounters.metricComponentType, (Function0 & Serializable)() -> (WeakHashMap)WeakHashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            long stuckCount = BoxesRunTime.unboxToLong((Object)threadToNumStuckSamplesMap.getOrElseUpdate(thread, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            if (isThreadStuck) {
                threadToNumStuckSamplesMap.update(thread, (Object)BoxesRunTime.boxToLong((long)(stuckCount + 1L)));
                return;
            }
            threadToNumStuckSamplesMap.update(thread, (Object)BoxesRunTime.boxToLong((long)0L));
        }));
        this.prevThreadLocalCountersSnapshot_$eq(currentThreadLocalCounterSnapshotForAllThreads);
        boolean engineThreadsStuck = this.isThreadGroupStuck$1(this.config().engineThreadStatusCriteria(), ThreadLocalCounters.MetricComponentType.ENGINE, HealthStatusAggregationOperator_Or$.MODULE$);
        boolean storageThreadsStuck = this.isThreadGroupStuck$1(this.config().storageThreadStatusCriteria(), ThreadLocalCounters.MetricComponentType.STORAGE, HealthStatusAggregationOperator_Or$.MODULE$);
        boolean noStorageThreadMakingProgress = this.prevNumCompletedStorageOps() == currNumCompletedStorageOps.elem;
        this.prevNumCompletedStorageOps_$eq(currNumCompletedStorageOps.elem);
        if (engineThreadsStuck) {
            this.contiguousSamplesEngineThreadGroupsStuck_$eq(this.contiguousSamplesEngineThreadGroupsStuck() + 1);
        } else {
            this.contiguousSamplesEngineThreadGroupsStuck_$eq(0);
        }
        if (storageThreadsStuck) {
            this.contiguousSamplesStorageThreadGroupsStuck_$eq(this.contiguousSamplesStorageThreadGroupsStuck() + 1);
        } else {
            this.contiguousSamplesStorageThreadGroupsStuck_$eq(0);
        }
        if (noStorageThreadMakingProgress) {
            this.contiguousSamplesNoStorageThreadMakingProgress_$eq(this.contiguousSamplesNoStorageThreadMakingProgress() + 1);
        } else {
            this.contiguousSamplesNoStorageThreadMakingProgress_$eq(0);
        }
        return engineThreadsStuck && storageThreadsStuck && noStorageThreadMakingProgress;
    }

    public void doWork() {
        this.pause(this.config().brokerHealthManagerSampleDurationMs(), TimeUnit.MILLISECONDS);
        this.totalSamples_$eq(this.totalSamples() + 1L);
        int isSampleUnhealthy = 0;
        if (this.isBrokerUnhealthy()) {
            isSampleUnhealthy = 1;
            this.contiguousUnhealthySamples_$eq(this.contiguousUnhealthySamples() + 1);
            this.contiguousHealthySamples_$eq(0);
        } else {
            this.contiguousUnhealthySamples_$eq(0);
            this.contiguousHealthySamples_$eq(this.contiguousHealthySamples() + 1);
        }
        BrokerHealthStatus brokerHealthStatus = this.brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        if (brokerHealthStatus != null && brokerHealthStatus.equals(healthy$)) {
            this.unhealthyStorageSampleWindow().addSample(isSampleUnhealthy);
            int numOfSamplesBeforeSuspect = this.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect();
            this.unhealthyStorageSampleWindow().maybeShrinkSampleWindow(numOfSamplesBeforeSuspect);
            if (this.unhealthyStorageSampleWindow().size() == numOfSamplesBeforeSuspect && this.unhealthyStorageSampleWindow().countedSamples() * 100 / this.unhealthyStorageSampleWindow().size() >= this.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition()) {
                this.statusTransition(Healthy$.MODULE$, Suspect$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
            }
        } else {
            BrokerHealthStatus brokerHealthStatus2 = this.brokerHealthStatus();
            Suspect$ suspect$ = Suspect$.MODULE$;
            if (brokerHealthStatus2 != null && brokerHealthStatus2.equals(suspect$)) {
                int numOfSampleBeforeUnhealthy = this.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy();
                this.unhealthyStorageSampleWindow().addSample(isSampleUnhealthy);
                this.unhealthyStorageSampleWindow().maybeShrinkSampleWindow(numOfSampleBeforeUnhealthy);
                int minUnhealthySamples = numOfSampleBeforeUnhealthy * this.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() / 100;
                int minHealthySamples = numOfSampleBeforeUnhealthy - minUnhealthySamples;
                if (this.unhealthyStorageSampleWindow().size() - this.unhealthyStorageSampleWindow().countedSamples() > minHealthySamples) {
                    this.statusTransition(Suspect$.MODULE$, Healthy$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
                } else if (this.unhealthyStorageSampleWindow().countedSamples() >= minUnhealthySamples) {
                    this.statusTransition(Suspect$.MODULE$, Unhealthy$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
                }
            }
        }
        BrokerHealthStatus brokerHealthStatus3 = this.brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        if (brokerHealthStatus3 == null) {
            return;
        }
        if (brokerHealthStatus3.equals(unhealthy$)) {
            if (this.isMitigationEnabled()) {
                this.hardShutdownScheduler().startup();
                this.hardShutdownScheduler().scheduleOnce("Hard-Kill-Broker", () -> {
                    throw Exit$.MODULE$.halt(1, (Option<String>)None$.MODULE$);
                }, (long)this.config().brokerHealthManagerHardKillDurationMs());
                this.logStuckThreads();
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(205).append("[BrokerHealth] Broker has remained unhealthy for ").append(this.config().brokerHealthManagerSampleDurationMs() * this.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy()).append(" ms. ").append("(1) Calling controlled shutdown to move leadership away if not controller. (2) Killing the ZK Connection. (3) Then will exit. Is the node controller - ").append($this.isActiveController.apply$mcZ$sp()).toString());
                if (!this.isActiveController.apply$mcZ$sp()) {
                    this.controlledShutdownHook.apply((Object)ControlledShutdownRequestReason.UNHEALTHY);
                }
                if (this.zkClient != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.zkClient.close(), this, Level.ERROR);
                }
                this.hardShutdownScheduler().shutdown();
                throw Exit$.MODULE$.halt(1, (Option<String>)None$.MODULE$);
            }
            if (this.contiguousHealthySamples() > this.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
                Queue healthySamples = (Queue)Queue$.MODULE$.fill(this.contiguousHealthySamples(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
                this.statusTransition(Unhealthy$.MODULE$, Healthy$.MODULE$, (Iterable<Object>)healthySamples);
                return;
            }
            return;
        }
    }

    public void statusTransition(BrokerHealthStatus currentHealthStatus, BrokerHealthStatus newHealthStatus, Iterable<Object> samples) {
        this.brokerHealthStatus_$eq(newHealthStatus);
        this.logBrokerHealthStatusChange(currentHealthStatus, newHealthStatus, samples);
        this.unhealthyStorageSampleWindow().reset();
    }

    public void logBrokerHealthStatusChange(BrokerHealthStatus currentHealthStatus, BrokerHealthStatus newHealthStatus, Iterable<Object> samples) {
        if (!this.isMitigationEnabled()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(109).append("[BrokerHealth] Broker health status changed. Previous Health Status: ").append(currentHealthStatus).append(" New Health Status: ").append(newHealthStatus).append(" Unhealthy Samples: ").append(samples).toString());
            this.logStuckThreads();
            return;
        }
    }

    public void run() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
        super.run();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return BrokerHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (ThreadCountersHealthStatusCriteria$.MODULE$.fromString(newConfig.confluentConfig().brokerHealthManagerEngineRequestHandlerThreadsStuckCriteria()).isEmpty()) {
            throw new ConfigException("Engine Request Handler Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (ThreadCountersHealthStatusCriteria$.MODULE$.fromString(newConfig.confluentConfig().brokerHealthManagerStorageRequestHandlerThreadsStuckCriteria()).isEmpty()) {
            throw new ConfigException("Storage Request Handler Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (ThreadCountersHealthStatusCriteria$.MODULE$.fromString(newConfig.confluentConfig().brokerHealthManagerStorageBackgroundThreadsStuckCriteria()).isEmpty()) {
            throw new ConfigException("Storage Background Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (ThreadCountersHealthStatusCriteria$.MODULE$.fromString(newConfig.confluentConfig().brokerHealthManagerStorageNetworkThreadsStuckCriteria()).isEmpty()) {
            throw new ConfigException("Storage Network Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(BrokerHealthManagerConfig$.MODULE$.apply(newConfig));
        this.isMitigationEnabled_$eq(this.config().isBrokerHealthManagerMitigationEnabled());
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$1() {
        return this.contiguousUnhealthySamples();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$2() {
        return this.contiguousSamplesEngineThreadGroupsStuck();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$3() {
        return this.contiguousSamplesStorageThreadGroupsStuck();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$4() {
        return this.contiguousSamplesNoStorageThreadMakingProgress();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$5() {
        return this.unhealthyStorageSampleWindow().countedSamples();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$6() {
        return this.brokerHealthStatus().id();
    }

    private final boolean isPrevCountersPresent$1() {
        return this.prevThreadLocalCountersSnapshot() != null;
    }

    private final boolean isThreadStuck$1(Thread thread$1, ThreadLocalCounters currCounters$1) {
        ObjectRef prevCounters = ObjectRef.create(null);
        ((java.lang.Iterable)this.prevThreadLocalCountersSnapshot().getOrDefault(thread$1, new ArrayList())).forEach(threadLocalCounters -> {
            block7: {
                block6: {
                    ThreadLocalCounters.MetricComponentType metricComponentType;
                    ThreadLocalCounters.MetricComponentType metricComponentType2;
                    block5: {
                        metricComponentType2 = threadLocalCounters.metricComponentType;
                        metricComponentType = currCounters$1.metricComponentType;
                        if (metricComponentType2 != null) break block5;
                        if (metricComponentType != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!metricComponentType2.equals(metricComponentType)) break block7;
                }
                prevCounters$1.elem = threadLocalCounters;
                return;
            }
        });
        if ((ThreadLocalCounters)prevCounters.elem != null) {
            return currCounters$1.numSuccessOps + currCounters$1.numFailedOps == ((ThreadLocalCounters)prevCounters.elem).numSuccessOps + ((ThreadLocalCounters)prevCounters.elem).numFailedOps && currCounters$1.numInProgressOps == ((ThreadLocalCounters)prevCounters.elem).numInProgressOps && currCounters$1.numInProgressOps >= 1L;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$3(BrokerHealthManager $this, ThreadLocalCounters.ThreadGroupType threadGroupType$1, ThreadLocalCounters.MetricComponentType metricComponentType$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Thread thread = (Thread)x0$3._1();
            long numStuckSamples = x0$3._2$mcJ$sp();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(121).append("[BrokerHealthManager] Broker has stuck threads. Thread Group type stuck = ").append(threadGroupType$1).append(" Component type = ").append(metricComponentType$1).append(" Thread = ").append(thread.getName()).append(" num stuck samples ").append(numStuckSamples).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$2(BrokerHealthManager $this, ThreadLocalCounters.ThreadGroupType threadGroupType$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            ThreadLocalCounters.MetricComponentType metricComponentType = (ThreadLocalCounters.MetricComponentType)x0$2._1();
            ((scala.collection.mutable.Map)x0$2._2()).foreach((Function1 & Serializable)x0$3 -> {
                BrokerHealthManager.$anonfun$logStuckThreads$3($this, threadGroupType$1, metricComponentType, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$1(BrokerHealthManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ThreadLocalCounters.ThreadGroupType threadGroupType = (ThreadLocalCounters.ThreadGroupType)x0$1._1();
            ((scala.collection.mutable.Map)x0$1._2()).foreach((Function1 & Serializable)x0$2 -> {
                BrokerHealthManager.$anonfun$logStuckThreads$2($this, threadGroupType, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$8(ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, boolean x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (x1$1 != null) {
            long numStuckSamples = x1$1._2$mcJ$sp();
            if (AnyThreadStuck$.MODULE$.equals(countersHealthStatusCriteria$1)) {
                return x0$1 || numStuckSamples > 0L;
            }
            if (AllThreadsStuck$.MODULE$.equals(countersHealthStatusCriteria$1)) {
                return x0$1 && numStuckSamples > 0L;
            }
            return x0$1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$7(boolean initialValue$1, ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, scala.collection.mutable.Map threadToNumStuckSamples) {
        return BoxesRunTime.unboxToBoolean((Object)threadToNumStuckSamples.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)initialValue$1), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$8(countersHealthStatusCriteria$1, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))));
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$6(ThreadLocalCounters.MetricComponentType componentType$1, boolean initialValue$1, ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, scala.collection.mutable.Map threadGroup) {
        return threadGroup.get((Object)componentType$1).exists((Function1 & Serializable)threadToNumStuckSamples -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$7(initialValue$1, countersHealthStatusCriteria$1, threadToNumStuckSamples)));
    }

    private final boolean isThreadGroupStuckAccordingToCriteria$1(boolean initialValue, ThreadLocalCounters.ThreadGroupType threadGroupType, ThreadLocalCounters.MetricComponentType componentType, ThreadCountersHealthStatusCriteria countersHealthStatusCriteria) {
        return this.threadStuckSamplesByComponentTypeByThreadGroupType().get((Object)threadGroupType).exists((Function1 & Serializable)threadGroup -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$6(componentType, initialValue, countersHealthStatusCriteria, threadGroup)));
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$9(BrokerHealthManager $this, HealthStatusAggregationOperator healthStatusAggregationOperator$1, ThreadLocalCounters.MetricComponentType componentType$2, boolean x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (x1$1 != null) {
            ThreadCountersHealthStatusCriteria criteria;
            ThreadLocalCounters.ThreadGroupType groupType = (ThreadLocalCounters.ThreadGroupType)x1$1._1();
            ThreadCountersHealthStatusCriteria threadCountersHealthStatusCriteria = criteria = (ThreadCountersHealthStatusCriteria)x1$1._2();
            AllThreadsStuck$ allThreadsStuck$ = AllThreadsStuck$.MODULE$;
            boolean initialValue = threadCountersHealthStatusCriteria != null && threadCountersHealthStatusCriteria.equals(allThreadsStuck$);
            HealthStatusAggregationOperator healthStatusAggregationOperator = healthStatusAggregationOperator$1;
            HealthStatusAggregationOperator_And$ healthStatusAggregationOperator_And$ = HealthStatusAggregationOperator_And$.MODULE$;
            if (healthStatusAggregationOperator != null && healthStatusAggregationOperator.equals(healthStatusAggregationOperator_And$)) {
                return x0$1 && $this.isThreadGroupStuckAccordingToCriteria$1(initialValue, groupType, componentType$2, criteria);
            }
            HealthStatusAggregationOperator healthStatusAggregationOperator2 = healthStatusAggregationOperator$1;
            HealthStatusAggregationOperator_Or$ healthStatusAggregationOperator_Or$ = HealthStatusAggregationOperator_Or$.MODULE$;
            if (healthStatusAggregationOperator2 != null && healthStatusAggregationOperator2.equals(healthStatusAggregationOperator_Or$)) {
                return x0$1 || $this.isThreadGroupStuckAccordingToCriteria$1(initialValue, groupType, componentType$2, criteria);
            }
            return false;
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isThreadGroupStuck$1(scala.collection.immutable.Map threadStatusCriteria, ThreadLocalCounters.MetricComponentType componentType, HealthStatusAggregationOperator healthStatusAggregationOperator) {
        boolean threadGroupStuckInitialValue;
        HealthStatusAggregationOperator healthStatusAggregationOperator2 = healthStatusAggregationOperator;
        HealthStatusAggregationOperator_And$ healthStatusAggregationOperator_And$ = HealthStatusAggregationOperator_And$.MODULE$;
        boolean bl = threadGroupStuckInitialValue = healthStatusAggregationOperator2 != null && healthStatusAggregationOperator2.equals(healthStatusAggregationOperator_And$);
        return threadStatusCriteria.nonEmpty() && BoxesRunTime.unboxToBoolean((Object)threadStatusCriteria.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)threadGroupStuckInitialValue), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$9(this, healthStatusAggregationOperator, componentType, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))));
    }

    public BrokerHealthManager(Function1<ControlledShutdownRequestReason, BoxedUnit> controlledShutdownHook, KafkaZkClient zkClient, Function0<Object> isActiveController, BrokerHealthManagerConfig initialConfig) {
        this.controlledShutdownHook = controlledShutdownHook;
        this.zkClient = zkClient;
        this.isActiveController = isActiveController;
        super("BrokerHealthManager", true);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.totalSamples = 0L;
        this.brokerHealthStatus = Healthy$.MODULE$;
        this.isMitigationEnabled = initialConfig.isBrokerHealthManagerMitigationEnabled();
        this.config = initialConfig;
        this.prevThreadLocalCountersSnapshot = null;
        this.prevNumCompletedStorageOps = 0L;
        this.contiguousUnhealthySamples = 0;
        this.contiguousHealthySamples = 0;
        this.threadStuckSamplesByComponentTypeByThreadGroupType = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.unhealthyStorageSampleWindow = new HealthSamplesWindow();
        this.contiguousSamplesEngineThreadGroupsStuck = 0;
        this.contiguousSamplesStorageThreadGroupsStuck = 0;
        this.contiguousSamplesNoStorageThreadMakingProgress = 0;
        this.metricsGroup().newGauge("ContiguousUnhealthySamples", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("ContiguousSamplesEngineThreadGroupsStuck", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("ContiguousSamplesStorageThreadGroupsStuck", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("ContiguousSamplesNoStorageThreadMakingProgress", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("UnhealthinessCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("StorageHealthStatus", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$6();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.hardShutdownScheduler = new KafkaScheduler(1);
    }
}

