/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaState$;
import kafka.log.MergedLog$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b\u0001B\b\u0011\u0001UA\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\tO\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u0003+\u0011\u00151\u0004\u0001\"\u00018\u0011\u001da\u0004A1A\u0005\nuBa!\u0014\u0001!\u0002\u0013q\u0004\"\u0002(\u0001\t\u0003y\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u00027\u0001\t\u0003i\u0007\"\u0002=\u0001\t\u0003I\b\"\u0002?\u0001\t\u0003j\bbBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003C\u0001A\u0011IA\u0012\u0005\u001d\u0011V\r\u001d7jG\u0006T!!\u0005\n\u0002\u000f\rdWo\u001d;fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0003?I\tQ!\u001e;jYNL!!\t\u0010\u0003\u000f1{wmZ5oO\u0006A!M]8lKJLE-F\u0001%!\t9R%\u0003\u0002'1\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002UA\u00111fM\u0007\u0002Y)\u0011QFL\u0001\u0007G>lWn\u001c8\u000b\u0005My#B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001eL!\u0001\u000e\u0017\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004qiZ\u0004CA\u001d\u0001\u001b\u0005\u0001\u0002\"\u0002\u0012\u0006\u0001\u0004!\u0003\"\u0002\u0015\u0006\u0001\u0004Q\u0013\u0001\u0004:fa2L7-Y*uCR,W#\u0001 \u0011\u0007}B%*D\u0001A\u0015\t\t%)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0007\u0012\u000b!bY8oGV\u0014(/\u001a8u\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0002\u0013q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0003s-K!\u0001\u0014\t\u0003\u0019I+\u0007\u000f\\5dCN#\u0018\r^3\u0002\u001bI,\u0007\u000f\\5dCN#\u0018\r^3!\u00035\u0019H/\u0019;f':\f\u0007o\u001d5piV\t!*\u0001\tva\u0012\fG/\u001a$fi\u000eD7\u000b^1uKR1!+V1gQ*\u0004\"aF*\n\u0005QC\"\u0001B+oSRDQAV\u0005A\u0002]\u000b1DZ8mY><XM\u001d$fi\u000eDwJ\u001a4tKRlU\r^1eCR\f\u0007C\u0001-`\u001b\u0005I&B\u0001.\\\u0003\rawn\u001a\u0006\u00039v\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005ys\u0013aB:u_J\fw-Z\u0005\u0003Af\u0013\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011\u0015\u0011\u0017\u00021\u0001d\u0003M1w\u000e\u001c7po\u0016\u00148\u000b^1si>3gm]3u!\t9B-\u0003\u0002f1\t!Aj\u001c8h\u0011\u00159\u0017\u00021\u0001d\u0003M1w\u000e\u001c7po\u0016\u0014h)\u001a;dQRKW.Z't\u0011\u0015I\u0017\u00021\u0001d\u0003=aW-\u00193fe\u0016sGm\u00144gg\u0016$\b\"B6\n\u0001\u0004\u0019\u0017a\u00032s_.,'/\u00129pG\"\f\u0011C]3tKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)\u0015\u0011f\u000e]9w\u0011\u0015y'\u00021\u0001d\u00035\u0019WO\u001d:f]R$\u0016.\\3Ng\")\u0011N\u0003a\u0001G\")!O\u0003a\u0001g\u0006Y\u0011n\u001d(fo2+\u0017\rZ3s!\t9B/\u0003\u0002v1\t9!i\\8mK\u0006t\u0007\"B<\u000b\u0001\u0004\u0019\u0018\u0001E5t\r>dGn\\<fe&s7+\u001f8d\u0003ii\u0017-\u001f2f%\u0016\u001cX\r\u001e'bgR\u001c\u0015-^4iiV\u0003H+[7f)\r\u0011&p\u001f\u0005\u0006_.\u0001\ra\u0019\u0005\u0006S.\u0001\raY\u0001\ti>\u001cFO]5oOR\ta\u0010E\u0002\u0000\u0003\u001bqA!!\u0001\u0002\nA\u0019\u00111\u0001\r\u000e\u0005\u0005\u0015!bAA\u0004)\u00051AH]8pizJ1!a\u0003\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA\t\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0002\r\u0002\r\u0015\fX/\u00197t)\r\u0019\u0018q\u0003\u0005\b\u00033i\u0001\u0019AA\u000e\u0003\u0011!\b.\u0019;\u0011\u0007]\ti\"C\u0002\u0002 a\u00111!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0013")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private final AtomicReference<ReplicaState> replicaState;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private AtomicReference<ReplicaState> replicaState() {
        return this.replicaState;
    }

    public ReplicaState stateSnapshot() {
        return this.replicaState().get();
    }

    public void updateFetchState(LogOffsetMetadata followerFetchOffsetMetadata, long followerStartOffset, long followerFetchTimeMs, long leaderEndOffset, long brokerEpoch) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            long lastCaughtUpTime = followerFetchOffsetMetadata$1.messageOffset >= leaderEndOffset ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), followerFetchTimeMs) : (followerFetchOffsetMetadata$1.messageOffset >= currentReplicaState.lastFetchLeaderLogEndOffset() ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), currentReplicaState.lastFetchTimeMs()) : currentReplicaState.lastCaughtUpTimeMs());
            return new ReplicaState(followerStartOffset, followerFetchOffsetMetadata, package$.MODULE$.max(leaderEndOffset, currentReplicaState.lastFetchLeaderLogEndOffset()), followerFetchTimeMs, lastCaughtUpTime, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)brokerEpoch)));
        });
    }

    public void resetReplicaState(long currentTimeMs, long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            long lastCaughtUpTimeMs;
            long l = lastCaughtUpTimeMs = isFollowerInSync ? currentTimeMs : 0L;
            if (isNewLeader) {
                return new ReplicaState(MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, MergedLog$.MODULE$.UnknownOffset(), 0L, lastCaughtUpTimeMs, (Option<Object>)Option$.MODULE$.empty());
            }
            return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), leaderEndOffset, isFollowerInSync ? currentTimeMs : 0L, lastCaughtUpTimeMs, currentReplicaState.brokerEpoch());
        });
        this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(26).append("Reset state of replica to ").append(this).toString());
    }

    public void maybeResetLastCaughtUpTime(long currentTimeMs, long leaderEndOffset) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            if (currentReplicaState.logEndOffset() == currentReplicaState.lastFetchLeaderLogEndOffset() && currentReplicaState.logEndOffset() < leaderEndOffset && currentReplicaState.lastCaughtUpTimeMs() > 0L) {
                return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), leaderEndOffset, package$.MODULE$.max(currentTimeMs, currentReplicaState.lastFetchTimeMs()), package$.MODULE$.max(currentTimeMs, currentReplicaState.lastCaughtUpTimeMs()), currentReplicaState.brokerEpoch());
            }
            return currentReplicaState;
        });
    }

    public String toString() {
        ReplicaState replicaState = this.replicaState().get();
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new java.lang.StringBuilder(18).append("Replica(replicaId=").append(this.brokerId()).toString());
        replicaString.append(new java.lang.StringBuilder(8).append(", topic=").append(this.topicPartition().topic()).toString());
        replicaString.append(new java.lang.StringBuilder(12).append(", partition=").append(this.topicPartition().partition()).toString());
        replicaString.append(new java.lang.StringBuilder(21).append(", lastCaughtUpTimeMs=").append(replicaState.lastCaughtUpTimeMs()).toString());
        replicaString.append(new java.lang.StringBuilder(17).append(", logStartOffset=").append(replicaState.logStartOffset()).toString());
        replicaString.append(new java.lang.StringBuilder(15).append(", logEndOffset=").append(replicaState.logEndOffsetMetadata().messageOffset).toString());
        replicaString.append(new java.lang.StringBuilder(23).append(", logEndOffsetMetadata=").append(replicaState.logEndOffsetMetadata()).toString());
        replicaString.append(new java.lang.StringBuilder(30).append(", lastFetchLeaderLogEndOffset=").append(replicaState.lastFetchLeaderLogEndOffset()).toString());
        replicaString.append(new java.lang.StringBuilder(14).append(", brokerEpoch=").append(replicaState.brokerEpoch().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -2L)).toString());
        replicaString.append(new java.lang.StringBuilder(18).append(", lastFetchTimeMs=").append(replicaState.lastFetchTimeMs()).toString());
        replicaString.append(")");
        return replicaString.toString();
    }

    public boolean equals(Object that) {
        if (that instanceof Replica) {
            Replica replica = (Replica)that;
            if (this.brokerId() == replica.brokerId()) {
                TopicPartition topicPartition = this.topicPartition();
                TopicPartition topicPartition2 = replica.topicPartition();
                if (!(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public Replica(int brokerId, TopicPartition topicPartition) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.replicaState = new AtomicReference<ReplicaState>(ReplicaState$.MODULE$.Empty());
    }
}

