/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit.manager;

import io.confluent.kafka.raft.RaftTracer;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import kafka.durability.audit.manager.ControllerAuditManager$;
import kafka.durability.audit.manager.ControllerAuditManagerTrait;
import kafka.durability.audit.request.KRaftHWMChangeRequest;
import kafka.durability.audit.request.KRaftLeaderChangeRequest;
import kafka.durability.audit.request.KRaftLogSnapshotGenerationRequest;
import kafka.durability.audit.request.KRaftLogStartOffsetChangeRequest;
import kafka.durability.audit.request.KRaftNodeStartUpRequest;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.raft.OffsetAndEpoch;
import scala.runtime.BoxesRunTime;

public final class KRaftDurabilityAuditor$
implements RaftTracer {
    public static final KRaftDurabilityAuditor$ MODULE$ = new KRaftDurabilityAuditor$();

    public void leaderChanged(TopicIdPartition tpid, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, Supplier<Map<Integer, Long>> epochChain, Set<Integer> yesVoters, Set<Integer> currentVoters) {
        if (!this.shouldSubmitAuditRequest(nodeId, currentVoters)) {
            return;
        }
        ControllerAuditManagerTrait.submitAuditRequest$(ControllerAuditManager$.MODULE$, new KRaftLeaderChangeRequest(tpid, epoch, nodeId.getAsInt(), hwm, logStartOffset, logEndOffset, epochChain, yesVoters, currentVoters));
    }

    public void highWatermarkChanged(TopicIdPartition tpid, int epoch, OptionalInt nodeId, long hwm, long logStartOffset, Map<Integer, OptionalLong> quorumFetchOffsets, Set<Integer> currentVoters) {
        if (!this.shouldSubmitAuditRequest(nodeId, currentVoters)) {
            return;
        }
        ControllerAuditManagerTrait.submitAuditRequest$(ControllerAuditManager$.MODULE$, new KRaftHWMChangeRequest(tpid, epoch, nodeId.getAsInt(), hwm, logStartOffset, quorumFetchOffsets, currentVoters));
    }

    public void logStartOffsetChanged(TopicIdPartition tpid, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, Optional<OffsetAndEpoch> latestSnapshotId, OptionalInt leaderId, Set<Integer> currentVoters) {
        if (!this.shouldSubmitAuditRequest(nodeId, currentVoters)) {
            return;
        }
        ControllerAuditManagerTrait.submitAuditRequest$(ControllerAuditManager$.MODULE$, new KRaftLogStartOffsetChangeRequest(tpid, epoch, nodeId.getAsInt(), hwm, logStartOffset, logEndOffset, latestSnapshotId, leaderId));
    }

    public void snapshotGenerated(TopicIdPartition tpid, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, OffsetAndEpoch newSnapshotId, OptionalInt leaderId, Set<Integer> currentVoters) {
        if (!this.shouldSubmitAuditRequest(nodeId, currentVoters)) {
            return;
        }
        ControllerAuditManagerTrait.submitAuditRequest$(ControllerAuditManager$.MODULE$, new KRaftLogSnapshotGenerationRequest(tpid, epoch, nodeId.getAsInt(), hwm, logStartOffset, logEndOffset, newSnapshotId, leaderId));
    }

    public void nodeStartedUp(TopicIdPartition tpid, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, SortedSet<OffsetAndEpoch> snapshotIds, OptionalInt leaderId, Set<Integer> currentVoters) {
        if (!this.shouldSubmitAuditRequest(nodeId, currentVoters)) {
            return;
        }
        ControllerAuditManagerTrait.submitAuditRequest$(ControllerAuditManager$.MODULE$, new KRaftNodeStartUpRequest(tpid, epoch, nodeId.getAsInt(), hwm, logStartOffset, logEndOffset, snapshotIds.isEmpty() ? Optional.empty() : Optional.of(snapshotIds.last()), leaderId));
    }

    private boolean shouldSubmitAuditRequest(OptionalInt nodeId, Set<Integer> currentVoters) {
        return nodeId.isPresent() && currentVoters.contains(BoxesRunTime.boxToInteger((int)nodeId.getAsInt()));
    }

    private KRaftDurabilityAuditor$() {
    }
}

