/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.TopicState;
import kafka.durability.db.TopicState$;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.db.kraft.KRaftQuorumState;
import kafka.durability.db.kraft.KRaftQuorumState$;
import kafka.durability.db.serdes.Database;
import kafka.durability.db.serdes.Header;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.durability.exceptions.DurabilityObjectNotFoundException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rEca\u0002\u0017.!\u0003\r\t\u0001\u000e\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011!)\u0005A1A\u0005\u00025\n\u0005\u0002\u0003$\u0001\u0001\u0004%\t!L$\t\u0011Q\u0003\u0001\u0019!C\u0001[UC\u0001\u0002\u0017\u0001C\u0002\u0013\u0005Q&\u0017\u0005\ta\u0002\u0001\r\u0011\"\u00010c\"A\u0001\u0010\u0001a\u0001\n\u0003y\u0013\u0010\u0003\u0005|\u0001\u0001\u0007I\u0011A\u0017}\u0011)\t\t\u0001\u0001a\u0001\n\u0003i\u00131\u0001\u0005\t\u0003\u000f\u0001a\u0011A\u0017\u0002\n!I\u0011\u0011\b\u0001C\u0002\u001b\u0005\u00111\b\u0005\u000b\u0003\u001b\u0002\u0001\u0019!D\t[\u0005=\u0003BCA,\u0001\u0001\u0007i\u0011C\u0017\u0002Z!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003BBA1\u0001\u0019\u0005A\bC\u0004\u0002\"\u0002!I!a)\t\r\u0005U\u0006A\"\u0001=\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!a?\u0001\t\u0003\ti\u0010C\u0004\u0003\u001c\u0001!\tA!\b\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!Q\u0007\u0001\u0005\u0002\t]\u0002b\u0002B0\u0001\u0011\u0005!\u0011\r\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0011\u001d\u00119\n\u0001C\u0001\u00053CqA!*\u0001\t\u0003\u00119\u000bC\u0004\u00034\u0002!\tA!.\t\u000f\t\u0005\u0007\u0001\"\u0001\u0003D\"9!\u0011\u001a\u0001\u0005\u0002\t-\u0007b\u0002Bh\u0001\u0011\u0005!\u0011\u001b\u0005\b\u0005+\u0004A\u0011\u0001Bl\u0011\u001d\u0011I\u000e\u0001C\u0001\u00057DqA!9\u0001\t\u0003\u00119\u000e\u0003\u0004\u0003d\u0002!\t\u0001\u0010\u0005\t\u0005K\u0004A\u0011C\u0017\u0003h\"A!Q\u001f\u0001\u0005\u00125\u00129\u0010C\u0004\u0003~\u0002!\tAa@\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n!911\u0007\u0001\u0005\u0002\rU\u0002\u0002CB\u001d\u0001\u0019\u0005Qfa\u000f\t\u000f\r}\u0002A\"\u0001\u0004B!111\t\u0001\u0005\u0002q\u0012q\u0001\u00122Ue\u0006LGO\u0003\u0002/_\u0005\u0011AM\u0019\u0006\u0003aE\n!\u0002Z;sC\nLG.\u001b;z\u0015\u0005\u0011\u0014!B6bM.\f7\u0001A\n\u0003\u0001U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001>!\t1d(\u0003\u0002@o\t!QK\\5u\u0003U!%i\u0018\"V\r\u001a+%kX%O\u0013R{F*\u0012(H)\"+\u0012A\u0011\t\u0003m\rK!\u0001R\u001c\u0003\u0007%sG/A\u0014E+J\u000b%)\u0013'J)f{VIV#O)N{Fk\u0014)J\u0007~\u0003\u0016I\u0015+J)&{ejX\"P+:#\u0016AB:uCR,8/F\u0001I!\tIUJ\u0004\u0002K\u00176\tQ&\u0003\u0002M[\u0005AAIY*uCR,8/\u0003\u0002O\u001f\nAAIY*uCR,8O\u0003\u0002M[!\u0012A!\u0015\t\u0003mIK!aU\u001c\u0003\u0011Y|G.\u0019;jY\u0016\f!b\u001d;biV\u001cx\fJ3r)\tid\u000bC\u0004X\u000b\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0013'A\u0006u_BL7m\u0015;bi\u0016\u001cX#\u0001.\u0011\tm\u0003'-\\\u0007\u00029*\u0011QLX\u0001\b[V$\u0018M\u00197f\u0015\tyv'\u0001\u0006d_2dWm\u0019;j_:L!!\u0019/\u0003\u000f!\u000b7\u000f['baB\u00111M\u001b\b\u0003I\"\u0004\"!Z\u001c\u000e\u0003\u0019T!aZ\u001a\u0002\rq\u0012xn\u001c;?\u0013\tIw'\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA58!\tQe.\u0003\u0002p[\tQAk\u001c9jGN#\u0018\r^3\u0002!-\u0014\u0018M\u001a;Rk>\u0014X/\\*uCR,W#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005Ul\u0013!B6sC\u001a$\u0018BA<u\u0005AY%+\u00194u#V|'/^7Ti\u0006$X-\u0001\u000ble\u00064G/U;peVl7\u000b^1uK~#S-\u001d\u000b\u0003{iDqa\u0016\u0005\u0002\u0002\u0003\u0007!/\u0001\u0004eENK'0Z\u000b\u0002{B\u0011aG`\u0005\u0003\u007f^\u0012A\u0001T8oO\u0006QAMY*ju\u0016|F%Z9\u0015\u0007u\n)\u0001C\u0004X\u0015\u0005\u0005\t\u0019A?\u00025\u001d,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d$pe\u0006+H-\u001b;\u0016\u0005\u0005-\u0001CBA\u0007\u0003/\tiB\u0004\u0003\u0002\u0010\u0005MabA3\u0002\u0012%\t\u0001(C\u0002\u0002\u0016]\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001a\u0005m!aA*fc*\u0019\u0011QC\u001c\u0011\rY\ny\"a\t~\u0013\r\t\tc\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\u0015\u0012QG\u0007\u0003\u0003OQA!!\u000b\u0002,\u000511m\\7n_:T1AMA\u0017\u0015\u0011\ty#!\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019$A\u0002pe\u001eLA!a\u000e\u0002(\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u00013jeV\u0011\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\tIwN\u0003\u0002\u0002H\u0005!!.\u0019<b\u0013\u0011\tY%!\u0011\u0003\t\u0019KG.Z\u0001\u0007Q\u0016\fG-\u001a:\u0016\u0005\u0005E\u0003c\u0001&\u0002T%\u0019\u0011QK\u0017\u0003\u0011\u0011\u0013\u0007*Z1eKJ\f!\u0002[3bI\u0016\u0014x\fJ3r)\ri\u00141\f\u0005\t/:\t\t\u00111\u0001\u0002R\u0005Iq-\u001a;EENK'0\u001a\u000b\u0002{\u0006Q1\r[3dWB|\u0017N\u001c;)\u000bA\t)'!\u001d\u0011\u000bY\n9'a\u001b\n\u0007\u0005%tG\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u007f\ti'\u0003\u0003\u0002p\u0005\u0005#aC%P\u000bb\u001cW\r\u001d;j_:\fdA\b2\u0002t\u0005}\u0015'C\u0012\u0002v\u0005u\u0014QSA@+\u0011\t9(!\u001f\u0016\u0003\t$q!a\u001f4\u0005\u0004\t)IA\u0001U\u0013\u0011\ty(!!\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\t\u0019iN\u0001\u0007i\"\u0014xn^:\u0012\t\u0005\u001d\u0015Q\u0012\t\u0004m\u0005%\u0015bAAFo\t9aj\u001c;iS:<\u0007\u0003BAH\u0003#s1ANA\n\u0013\u0011\t\u0019*a\u0007\u0003\u0013QC'o\\<bE2,\u0017'C\u0012\u0002\u0018\u0006e\u00151TAB\u001d\r1\u0014\u0011T\u0005\u0004\u0003\u0007;\u0014'\u0002\u00127o\u0005u%!B:dC2\f\u0017g\u0001\u0014\u0002l\u0005i!/Z2pm\u0016\u0014\b*Z1eKJ$B!!\u0015\u0002&\"9\u0011qU\tA\u0002\u0005%\u0016a\u00015eeB!\u00111VAY\u001b\t\tiKC\u0002\u000206\naa]3sI\u0016\u001c\u0018\u0002BAZ\u0003[\u0013a\u0001S3bI\u0016\u0014\u0018a\u0002:fG>4XM\u001d\u0015\u0006%\u0005\u0015\u0014\u0011X\u0019\u0007=\t\fY,!12\u0013\r\n)(! \u0002>\u0006}\u0014'C\u0012\u0002\u0018\u0006e\u0015qXABc\u0015\u0011cgNAOc\r1\u00131N\u0001\u0013o&$\bNU3bI&tWm]:DQ\u0016\u001c7.\u0006\u0003\u0002H\u00065G\u0003BAe\u0003/\u0004B!a3\u0002N2\u0001AaBA>'\t\u0007\u0011qZ\t\u0005\u0003\u000f\u000b\t\u000eE\u00027\u0003'L1!!68\u0005\r\te.\u001f\u0005\t\u00033\u001cB\u00111\u0001\u0002\\\u0006\u0019a-\u001e8\u0011\u000bY\ni.!3\n\u0007\u0005}wG\u0001\u0005=Eft\u0017-\\3?Q\u0015\u0019\u00121]Ay!\u00151\u0014qMAs!\u0011\t9/!<\u000e\u0005\u0005%(bAAv_\u0005QQ\r_2faRLwN\\:\n\t\u0005=\u0018\u0011\u001e\u0002\u001e\tV\u0014\u0018MY5mSRLHI\u0011(piJ+\u0017\rZ=Fq\u000e,\u0007\u000f^5p]F2aDYAz\u0003s\f\u0014bIA;\u0003{\n)0a 2\u0013\r\n9*!'\u0002x\u0006\r\u0015'\u0002\u00127o\u0005u\u0015g\u0001\u0014\u0002f\u0006\u0019b-\u001a;dQB\u000b'\u000f^5uS>t7\u000b^1uKR!\u0011q B\u0006!\u00151$\u0011\u0001B\u0003\u0013\r\u0011\u0019a\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007)\u00139!C\u0002\u0003\n5\u0012a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0003\u000eQ\u0001\r!a\t\u0002\u0005%$\u0007&\u0002\u000b\u0002d\nE\u0011G\u0002\u0010c\u0005'\u0011I\"M\u0005$\u0003k\niH!\u0006\u0002\u0000EJ1%a&\u0002\u001a\n]\u00111Q\u0019\u0006EY:\u0014QT\u0019\u0004M\u0005\u0015\u0018\u0001\u00064fi\u000eDg*\u001a=u\u0003V$\u0017\u000e^(gMN,G\u000f\u0006\u0003\u0003 \t\u0005\u0002\u0003\u0002\u001c\u0003\u0002uDqA!\u0004\u0016\u0001\u0004\t\u0019\u0003K\u0003\u0016\u0003G\u0014)#\r\u0004\u001fE\n\u001d\"QF\u0019\nG\u0005U\u0014Q\u0010B\u0015\u0003\u007f\n\u0014bIAL\u00033\u0013Y#a!2\u000b\t2t'!(2\u0007\u0019\n)/A\beK2,G/\u001a)beRLG/[8o)\ri$1\u0007\u0005\b\u0005\u001b1\u0002\u0019AA\u0012\u00031\tG\r\u001a)beRLG/[8o)\u0019\tyP!\u000f\u0003<!9!QB\fA\u0002\u0005\r\u0002b\u0002B\u001f/\u0001\u0007!QA\u0001\u0006gR\fG/\u001a\u0015\u0006/\u0005\r(\u0011I\u0019\u0007=\t\u0014\u0019E!\u00132\u0013\r\n)(! \u0003F\u0005}\u0014'C\u0012\u0002\u0018\u0006e%qIABc\u0015\u0011cgNAOc\r1\u0013Q\u001d\u0015\u0006/\t5#Q\u000b\t\u0006m\u0005\u001d$q\n\t\u0005\u0003O\u0014\t&\u0003\u0003\u0003T\u0005%(!\t#ve\u0006\u0014\u0017\u000e\\5us>\u0013'.Z2u\u001d>$hi\\;oI\u0016C8-\u001a9uS>t\u0017G\u0002\u0010c\u0005/\u0012i&M\u0005$\u0003k\niH!\u0017\u0002\u0000EJ1%a&\u0002\u001a\nm\u00131Q\u0019\u0006EY:\u0014QT\u0019\u0004M\t=\u0013\u0001D1eI\u0006+H-\u001b;J]\u001a|GCBA\u0000\u0005G\u0012)\u0007C\u0004\u0003\u000ea\u0001\r!a\t\t\u000f\tu\u0002\u00041\u0001\u0003\u0006!*\u0001$a9\u0003jE2aD\u0019B6\u0005c\n\u0014bIA;\u0003{\u0012i'a 2\u0013\r\n9*!'\u0003p\u0005\r\u0015'\u0002\u00127o\u0005u\u0015g\u0001\u0014\u0002f\"*\u0001D!\u0014\u0003vE2aD\u0019B<\u0005{\n\u0014bIA;\u0003{\u0012I(a 2\u0013\r\n9*!'\u0003|\u0005\r\u0015'\u0002\u00127o\u0005u\u0015g\u0001\u0014\u0003P\u0005A\u0011\r\u001a3U_BL7\r\u0006\u0004\u0003\u0004\n\u0015%\u0011\u0012\t\u0005m\t\u0005Q\u000e\u0003\u0004\u0003\bf\u0001\rAY\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0007\u0005{I\u0002\u0019A7)\u000be\t\u0019O!$2\ry\u0011'q\u0012BKc%\u0019\u0013QOA?\u0005#\u000by(M\u0005$\u0003/\u000bIJa%\u0002\u0004F*!EN\u001c\u0002\u001eF\u001aa%!:\u0002-\u0005$Gm\u0013*bMR\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$BAa'\u0003$B)aG!\u0001\u0003\u001eB\u00191Oa(\n\u0007\t\u0005FOA\nL%\u00064G\u000fU1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0003>i\u0001\rA!(\u00021\u0019,Go\u00195L%\u00064G\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0003\u001c\n%\u0006b\u0002BV7\u0001\u0007!QV\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004B!!\n\u00030&!!\u0011WA\u0014\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\nbI\u0012\\%+\u00194u\u000bB|7\r\u001b'fC\u0012,'\u000f\u0006\u0004\u00038\ne&Q\u0018\t\u0005m\t\u0005!\t\u0003\u0004\u0003<r\u0001\rAQ\u0001\u0006KB|7\r\u001b\u0005\u0007\u0005\u007fc\u0002\u0019\u0001\"\u0002\u00111,\u0017\rZ3s\u0013\u0012\f\u0011\u0004\u001e:v]\u000e\fG/Z&SC\u001a$X\t]8dQ2+\u0017\rZ3sgR\u0019QH!2\t\r\t\u001dW\u00041\u0001C\u0003!i\u0017N\\#q_\u000eD\u0017!\u00064fi\u000eD7JU1gi\u0016\u0003xn\u00195MK\u0006$WM\u001d\u000b\u0005\u0005o\u0013i\r\u0003\u0004\u0003<z\u0001\rAQ\u0001\u0013g\u0016$8JU1gi2{7-\u00197Fa>\u001c\u0007\u000e\u0006\u0003\u00038\nM\u0007B\u0002B^?\u0001\u0007!)\u0001\nhKR\\%+\u00194u\u0019>\u001c\u0017\r\\#q_\u000eDGC\u0001B\\\u0003M\u0019X\r^&SC\u001a$Hj\\2bY:{G-Z%e)\u0011\u00119L!8\t\r\t}\u0017\u00051\u0001C\u0003\u0019qw\u000eZ3JI\u0006\u0019r-\u001a;L%\u00064G\u000fT8dC2tu\u000eZ3JI\u0006)2\r\\3be.\u0013\u0016M\u001a;Rk>\u0014X/\\*uCR,\u0017!C:fe&\fG.\u001b>f)\t\u0011I\u000f\u0005\u0003\u0003l\nEXB\u0001Bw\u0015\u0011\u0011y/!\u0012\u0002\u00079Lw.\u0003\u0003\u0003t\n5(A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006YA-Z:fe&\fG.\u001b>f)\ri$\u0011 \u0005\b\u0005w,\u0003\u0019\u0001Bu\u0003\u0019\u0011WO\u001a4fe\u0006A\u0011n](oY&tW-\u0006\u0002\u0004\u0002A\u0019aga\u0001\n\u0007\r\u0015qGA\u0004C_>dW-\u00198\u0002IU\u0004H-\u0019;f\tV\u0014\u0018MY5mSRLHk\u001c9jGB\u000b'\u000f^5uS>twJ\u001a4tKR$R!PB\u0006\u0007\u001fAaa!\u0004(\u0001\u0004\u0011\u0015!\u00039beRLG/[8o\u0011\u0019\u0019\tb\na\u0001{\u00061qN\u001a4tKRDSaJAr\u0007+\tdA\b2\u0004\u0018\ru\u0011'C\u0012\u0002v\u0005u4\u0011DA@c%\u0019\u0013qSAM\u00077\t\u0019)M\u0003#m]\ni*M\u0002'\u0003KDSaJB\u0011\u0007S\u0001RANA4\u0007G\u0001B!!\u0004\u0004&%!1qEA\u000e\u0005eIe\u000eZ3y\u001fV$xJ\u001a\"pk:$7/\u0012=dKB$\u0018n\u001c82\ry\u001171FB\u0019c%\u0019\u0013QOA?\u0007[\ty(M\u0005$\u0003/\u000bIja\f\u0002\u0004F*!EN\u001c\u0002\u001eF\u001aaea\t\u0002E\u001d,G\u000fR;sC\nLG.\u001b;z)>\u0004\u0018n\u0019)beRLG/[8o\u001f\u001a47/\u001a;t+\t\u00199\u0004E\u0003\u0002\u000e\u0005]Q0\u0001\thKR\fE\u000e\u001c)beRLG/[8ogV\u00111Q\b\t\u0007\u0003\u001b\t9\"a\t\u0002!\u0019,Go\u00195U_BL7m\u0015;bi\u0016\u001cH#\u0001.\u0002\u000b\rdwn]3)\u000b-\n)ga\u00122\ry\u00117\u0011JB(c%\u0019\u0013QOA?\u0007\u0017\ny(M\u0005$\u0003/\u000bIj!\u0014\u0002\u0004F*!EN\u001c\u0002\u001eF\u001aa%a\u001b")
public interface DbTrait {
    public void kafka$durability$db$DbTrait$_setter_$kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH_$eq(int var1);

    public void kafka$durability$db$DbTrait$_setter_$DURABILITY_EVENTS_TOPIC_PARTITION_COUNT_$eq(int var1);

    public void kafka$durability$db$DbTrait$_setter_$topicStates_$eq(HashMap<String, TopicState> var1);

    public int kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH();

    public int DURABILITY_EVENTS_TOPIC_PARTITION_COUNT();

    public Enumeration.Value status();

    public void status_$eq(Enumeration.Value var1);

    public HashMap<String, TopicState> topicStates();

    public KRaftQuorumState kraftQuorumState();

    public void kraftQuorumState_$eq(KRaftQuorumState var1);

    public long dbSize();

    public void dbSize_$eq(long var1);

    public Seq<Tuple2<TopicPartition, Object>> getTopicPartitionsForAudit();

    public File dir();

    public DbHeader header();

    public void header_$eq(DbHeader var1);

    public static /* synthetic */ long getDbSize$(DbTrait $this) {
        return $this.getDbSize();
    }

    default public long getDbSize() {
        return this.dbSize();
    }

    public void checkpoint() throws IOException;

    private DbHeader recoverHeader(Header hdr) {
        long[] committedOffsets = (long[])Array$.MODULE$.fill(this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), hdr.durabilityPartitionsOffsetsLength()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ii -> {
            committedOffsets$1[ii] = hdr.durabilityPartitionsOffsets(ii);
        });
        return new DbHeader(hdr.version(), hdr.durabilityRunId(), committedOffsets);
    }

    public void recover() throws IOException;

    private <T> T withReadinessCheck(Function0<T> fun) throws DurabilityDBNotReadyException {
        Enumeration.Value value = this.status();
        Enumeration.Value value2 = DbStatus$.MODULE$.Online();
        if (!(value2 != null ? !value2.equals(value) : value != null)) {
            return (T)fun.apply();
        }
        throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
    }

    public static /* synthetic */ Option fetchPartitionState$(DbTrait $this, TopicPartition id) {
        return $this.fetchPartitionState(id);
    }

    default public Option<PartitionState> fetchPartitionState(TopicPartition id) throws DurabilityDBNotReadyException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchPartitionState$1(this, id);
            return option;
        }
    }

    public static /* synthetic */ Option fetchNextAuditOffset$(DbTrait $this, TopicPartition id) {
        return $this.fetchNextAuditOffset(id);
    }

    default public Option<Object> fetchNextAuditOffset(TopicPartition id) throws DurabilityDBNotReadyException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchNextAuditOffset$1(this, id);
            return option;
        }
    }

    public static /* synthetic */ void deletePartition$(DbTrait $this, TopicPartition id) {
        $this.deletePartition(id);
    }

    default public void deletePartition(TopicPartition id) {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            DbTrait.$anonfun$deletePartition$1(this, id);
            return;
        }
    }

    public static /* synthetic */ Option addPartition$(DbTrait $this, TopicPartition id, PartitionState state) {
        return $this.addPartition(id, state);
    }

    default public Option<PartitionState> addPartition(TopicPartition id, PartitionState state) throws DurabilityDBNotReadyException, DurabilityObjectNotFoundException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addPartition$1(this, id, state);
            return option;
        }
    }

    public static /* synthetic */ Option addAuditInfo$(DbTrait $this, TopicPartition id, PartitionState state) {
        return $this.addAuditInfo(id, state);
    }

    default public Option<PartitionState> addAuditInfo(TopicPartition id, PartitionState state) throws DurabilityDBNotReadyException, DurabilityObjectNotFoundException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addAuditInfo$1(this, id, state);
            return option;
        }
    }

    private Option<TopicState> addTopic(String topic, TopicState state) throws DurabilityDBNotReadyException {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addTopic$1(this, topic, state);
            return option;
        }
    }

    public static /* synthetic */ Option addKRaftPartitionState$(DbTrait $this, KRaftPartitionState state) {
        return $this.addKRaftPartitionState(state);
    }

    default public Option<KRaftPartitionState> addKRaftPartitionState(KRaftPartitionState state) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addKRaftPartitionState$1(this, state);
            return option;
        }
    }

    public static /* synthetic */ Option fetchKRaftPartitionState$(DbTrait $this, TopicIdPartition topicIdPartition) {
        return $this.fetchKRaftPartitionState(topicIdPartition);
    }

    default public Option<KRaftPartitionState> fetchKRaftPartitionState(TopicIdPartition topicIdPartition) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchKRaftPartitionState$1(this, topicIdPartition);
            return option;
        }
    }

    public static /* synthetic */ Option addKRaftEpochLeader$(DbTrait $this, int epoch, int leaderId) {
        return $this.addKRaftEpochLeader(epoch, leaderId);
    }

    default public Option<Object> addKRaftEpochLeader(int epoch, int leaderId) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addKRaftEpochLeader$1(this, epoch, leaderId);
            return option;
        }
    }

    public static /* synthetic */ void truncateKRaftEpochLeaders$(DbTrait $this, int minEpoch) {
        $this.truncateKRaftEpochLeaders(minEpoch);
    }

    default public void truncateKRaftEpochLeaders(int minEpoch) {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            DbTrait.$anonfun$truncateKRaftEpochLeaders$1(this, minEpoch);
            return;
        }
    }

    public static /* synthetic */ Option fetchKRaftEpochLeader$(DbTrait $this, int epoch) {
        return $this.fetchKRaftEpochLeader(epoch);
    }

    default public Option<Object> fetchKRaftEpochLeader(int epoch) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchKRaftEpochLeader$1(this, epoch);
            return option;
        }
    }

    public static /* synthetic */ Option setKRaftLocalEpoch$(DbTrait $this, int epoch) {
        return $this.setKRaftLocalEpoch(epoch);
    }

    default public Option<Object> setKRaftLocalEpoch(int epoch) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$setKRaftLocalEpoch$1(this, epoch);
            return option;
        }
    }

    public static /* synthetic */ Option getKRaftLocalEpoch$(DbTrait $this) {
        return $this.getKRaftLocalEpoch();
    }

    default public Option<Object> getKRaftLocalEpoch() {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$getKRaftLocalEpoch$1(this);
            return option;
        }
    }

    public static /* synthetic */ Option setKRaftLocalNodeId$(DbTrait $this, int nodeId) {
        return $this.setKRaftLocalNodeId(nodeId);
    }

    default public Option<Object> setKRaftLocalNodeId(int nodeId) {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$setKRaftLocalNodeId$1(this, nodeId);
            return option;
        }
    }

    public static /* synthetic */ Option getKRaftLocalNodeId$(DbTrait $this) {
        return $this.getKRaftLocalNodeId();
    }

    default public Option<Object> getKRaftLocalNodeId() {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$getKRaftLocalNodeId$1(this);
            return option;
        }
    }

    public static /* synthetic */ void clearKRaftQuorumState$(DbTrait $this) {
        $this.clearKRaftQuorumState();
    }

    default public void clearKRaftQuorumState() {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            this.kraftQuorumState_$eq(KRaftQuorumState$.MODULE$.apply());
            return;
        }
    }

    public static /* synthetic */ ByteBuffer serialize$(DbTrait $this) {
        return $this.serialize();
    }

    default public ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH()).forceDefaults(true);
        Iterable topicIdx = (Iterable)this.topicStates().values().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.serialize(builder)));
        int topicOffsets = Database.createTopicsVector(builder, (int[])topicIdx.toArray((ClassTag)ClassTag$.MODULE$.Int()));
        int kraftQuorumStateOffset = this.kraftQuorumState().serialize(builder);
        int hdrOffset = this.header().serialize(builder);
        int end = Database.createDatabase(builder, hdrOffset, topicOffsets, kraftQuorumStateOffset);
        builder.finish(end);
        return Database.getRootAsDatabase(builder.dataBuffer()).getByteBuffer().duplicate();
    }

    public static /* synthetic */ void deserialize$(DbTrait $this, ByteBuffer buffer) {
        $this.deserialize(buffer);
    }

    default public void deserialize(ByteBuffer buffer) {
        Database database = Database.getRootAsDatabase(buffer);
        Header hdr = database.header();
        this.header_$eq(this.recoverHeader(hdr));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), database.topicsLength()).foreach((Function1 & Serializable)i -> DbTrait.$anonfun$deserialize$1(this, database, BoxesRunTime.unboxToInt((Object)i)));
        if (database.kraftQuorumState() != null) {
            this.kraftQuorumState_$eq(KRaftQuorumState$.MODULE$.fromKRaftQuorumInfo(database.kraftQuorumState()));
            return;
        }
    }

    public static /* synthetic */ boolean isOnline$(DbTrait $this) {
        return $this.isOnline();
    }

    default public boolean isOnline() {
        Enumeration.Value value = this.status();
        Enumeration.Value value2 = DbStatus$.MODULE$.Online();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static /* synthetic */ void updateDurabilityTopicPartitionOffset$(DbTrait $this, int partition, long offset) {
        $this.updateDurabilityTopicPartitionOffset(partition, offset);
    }

    default public void updateDurabilityTopicPartitionOffset(int partition, long offset) throws DurabilityDBNotReadyException, IndexOutOfBoundsException {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            this.header().offsets()[partition] = offset;
            return;
        }
    }

    public static /* synthetic */ Seq getDurabilityTopicPartitionOffsets$(DbTrait $this) {
        return $this.getDurabilityTopicPartitionOffsets();
    }

    default public Seq<Object> getDurabilityTopicPartitionOffsets() {
        synchronized (this) {
            block6: {
                block7: {
                    Enumeration.Value value;
                    Enumeration.Value value2;
                    block5: {
                        value2 = this.status();
                        value = DbStatus$.MODULE$.Online();
                        if (value != null) break block5;
                        if (value2 == null) break block6;
                        break block7;
                    }
                    if (value.equals(value2)) break block6;
                }
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Seq seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.longArrayOps(this.header().offsets()));
            return seq;
        }
    }

    public Seq<TopicPartition> getAllPartitions();

    public HashMap<String, TopicState> fetchTopicStates();

    public static /* synthetic */ void close$(DbTrait $this) {
        $this.close();
    }

    default public void close() throws IOException {
        this.checkpoint();
    }

    public static /* synthetic */ Option $anonfun$fetchPartitionState$1(DbTrait $this, TopicPartition id$1) {
        TopicState s;
        Option option = $this.topicStates().get((Object)id$1.topic());
        if (option instanceof Some && (s = (TopicState)((Some)option).value()) != null) {
            return s.partitions().get((Object)BoxesRunTime.boxToInteger((int)id$1.partition()));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public static /* synthetic */ Option $anonfun$fetchNextAuditOffset$1(DbTrait $this, TopicPartition id$2) {
        TopicState s;
        Option option = $this.topicStates().get((Object)id$2.topic());
        if (option instanceof Some && (s = (TopicState)((Some)option).value()) != null) {
            Option option2 = s.partitions().get((Object)BoxesRunTime.boxToInteger((int)id$2.partition()));
            if (option2 instanceof Some) {
                PartitionState value = (PartitionState)((Some)option2).value();
                if (value.auditInfo().readTierPartitionOffset() != -1L) {
                    return new Some((Object)BoxesRunTime.boxToLong((long)(value.auditInfo().readTierPartitionOffset() + 1L)));
                }
                return new Some((Object)BoxesRunTime.boxToLong((long)value.auditInfo().readTierPartitionOffset()));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public static /* synthetic */ Object $anonfun$deletePartition$1(DbTrait $this, TopicPartition id$3) {
        TopicState s;
        Option option = $this.topicStates().get((Object)id$3.topic());
        if (option instanceof Some && (s = (TopicState)((Some)option).value()) != null) {
            s.partitions().remove((Object)BoxesRunTime.boxToInteger((int)id$3.partition()));
            if (s.partitions().isEmpty()) {
                return $this.topicStates().remove((Object)id$3.topic());
            }
            return BoxedUnit.UNIT;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Option $anonfun$addPartition$1(DbTrait $this, TopicPartition id$4, PartitionState state$1) {
        if (!$this.topicStates().contains((Object)id$4.topic())) {
            void apply_partitions;
            HashMap hashMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            String apply_topic = id$4.topic();
            Object var5_4 = null;
            hashMap = null;
            $this.addTopic(id$4.topic(), new TopicState(apply_topic, (HashMap<Object, PartitionState>)apply_partitions));
            return ((TopicState)$this.topicStates().apply((Object)id$4.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$4.partition()), (Object)state$1);
        }
        Option option = ((TopicState)$this.topicStates().apply((Object)id$4.topic())).partitions().get((Object)BoxesRunTime.boxToInteger((int)id$4.partition()));
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            state$1.auditInfo_$eq(value.auditInfo());
            return ((TopicState)$this.topicStates().apply((Object)id$4.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$4.partition()), (Object)state$1);
        }
        return ((TopicState)$this.topicStates().apply((Object)id$4.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$4.partition()), (Object)state$1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Option $anonfun$addAuditInfo$1(DbTrait $this, TopicPartition id$5, PartitionState state$2) {
        if (!$this.topicStates().contains((Object)id$5.topic())) {
            void apply_partitions;
            HashMap hashMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            String apply_topic = id$5.topic();
            Object var5_4 = null;
            hashMap = null;
            $this.addTopic(id$5.topic(), new TopicState(apply_topic, (HashMap<Object, PartitionState>)apply_partitions));
            return ((TopicState)$this.topicStates().apply((Object)id$5.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$5.partition()), (Object)state$2);
        }
        Option option = ((TopicState)$this.topicStates().apply((Object)id$5.topic())).partitions().get((Object)BoxesRunTime.boxToInteger((int)id$5.partition()));
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            value.auditInfo_$eq(state$2.auditInfo());
            return ((TopicState)$this.topicStates().apply((Object)id$5.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$5.partition()), (Object)value);
        }
        return ((TopicState)$this.topicStates().apply((Object)id$5.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$5.partition()), (Object)state$2);
    }

    public static /* synthetic */ Option $anonfun$addTopic$1(DbTrait $this, String topic$1, TopicState state$3) {
        return $this.topicStates().put((Object)topic$1, (Object)state$3);
    }

    public static /* synthetic */ Option $anonfun$addKRaftPartitionState$1(DbTrait $this, KRaftPartitionState state$4) {
        return $this.kraftQuorumState().kRaftPartitionStates().put((Object)state$4.topicIdPartition(), (Object)state$4);
    }

    public static /* synthetic */ Option $anonfun$fetchKRaftPartitionState$1(DbTrait $this, TopicIdPartition topicIdPartition$1) {
        return $this.kraftQuorumState().kRaftPartitionStates().get((Object)topicIdPartition$1);
    }

    public static /* synthetic */ Option $anonfun$addKRaftEpochLeader$1(DbTrait $this, int epoch$1, int leaderId$1) {
        return $this.kraftQuorumState().epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)epoch$1), (Object)BoxesRunTime.boxToInteger((int)leaderId$1));
    }

    public static /* synthetic */ boolean $anonfun$truncateKRaftEpochLeaders$2(int minEpoch$1, Tuple2 epochAndLeader) {
        return epochAndLeader._1$mcI$sp() >= minEpoch$1;
    }

    public static /* synthetic */ void $anonfun$truncateKRaftEpochLeaders$1(DbTrait $this, int minEpoch$1) {
        $this.kraftQuorumState().epochLeaderIds_$eq((HashMap<Object, Object>)((HashMap)$this.kraftQuorumState().epochLeaderIds().filter((Function1 & Serializable)epochAndLeader -> BoxesRunTime.boxToBoolean((boolean)DbTrait.$anonfun$truncateKRaftEpochLeaders$2(minEpoch$1, epochAndLeader)))));
    }

    public static /* synthetic */ Option $anonfun$fetchKRaftEpochLeader$1(DbTrait $this, int epoch$2) {
        return $this.kraftQuorumState().epochLeaderIds().get((Object)BoxesRunTime.boxToInteger((int)epoch$2));
    }

    public static /* synthetic */ Option $anonfun$setKRaftLocalEpoch$1(DbTrait $this, int epoch$3) {
        int n = $this.kraftQuorumState().epoch();
        switch (n) {
            case -1: {
                $this.kraftQuorumState().epoch_$eq(epoch$3);
                return None$.MODULE$;
            }
        }
        $this.kraftQuorumState().epoch_$eq(epoch$3);
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static /* synthetic */ Option $anonfun$getKRaftLocalEpoch$1(DbTrait $this) {
        int n = $this.kraftQuorumState().epoch();
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static /* synthetic */ Option $anonfun$setKRaftLocalNodeId$1(DbTrait $this, int nodeId$1) {
        int n = $this.kraftQuorumState().localNodeId();
        switch (n) {
            case -1: {
                $this.kraftQuorumState().localNodeId_$eq(nodeId$1);
                return None$.MODULE$;
            }
        }
        $this.kraftQuorumState().localNodeId_$eq(nodeId$1);
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static /* synthetic */ Option $anonfun$getKRaftLocalNodeId$1(DbTrait $this) {
        int n = $this.kraftQuorumState().localNodeId();
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static /* synthetic */ Option $anonfun$deserialize$1(DbTrait $this, Database database$1, int i) {
        TopicState topicState = TopicState$.MODULE$.apply(database$1.topics(i));
        return $this.topicStates().put((Object)topicState.topic(), (Object)topicState);
    }

    public static void $init$(DbTrait $this) {
        $this.kafka$durability$db$DbTrait$_setter_$kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH_$eq(0x100000);
        $this.kafka$durability$db$DbTrait$_setter_$DURABILITY_EVENTS_TOPIC_PARTITION_COUNT_$eq(50);
        $this.status_$eq(DbStatus$.MODULE$.Init());
        $this.kafka$durability$db$DbTrait$_setter_$topicStates_$eq((HashMap<String, TopicState>)((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$)));
        $this.kraftQuorumState_$eq(KRaftQuorumState$.MODULE$.apply());
        $this.dbSize_$eq(0L);
    }
}

