/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kafka.log.AbstractLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.MapOps;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r=d\u0001\u0002\u001f>\u0005\tC\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005;\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003m\u0011!!\bA!A!\u0002\u0013)\bBCA\r\u0001\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u00111\u0005\u0001\u0003\u0002\u0003\u0006I!!\n\t\u0015\u00055\u0002A!A!\u0002\u0013\ty\u0003\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0005\u0003\u000bBq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAR\u0001\u0011%\u0011Q\u0015\u0005\b\u0003w\u0003A\u0011IA_\u0011\u001d\ty\f\u0001C!\u0003\u0003Dq!!2\u0001\t\u0003\n9\rC\u0004\u0002j\u0001!\t%a4\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"9\u0011q\u001c\u0001\u0005B\u0005\u0005\bbBAu\u0001\u0011\u0005\u00131\u001e\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\t9\u0010\u0001C!\u0003\u000fDq!!?\u0001\t\u0003\nY\u0010C\u0004\u0002\u001a\u0001!\tE!\u0001\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006!9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0011\u001d\u00119\u0004\u0001C!\u0005sAqAa\u000f\u0001\t\u0003\u0012i\u0004C\u0004\u0003D\u0001!\tE!\u0012\t\u000f\t%\u0003\u0001\"\u0011\u0003F!9!1\n\u0001\u0005B\t5\u0003b\u0002B+\u0001\u0011\u0005#q\u000b\u0005\b\u00057\u0002A\u0011\tB/\u0011\u001d\u0011\t\u0007\u0001C!\u0005GBqAa\u001e\u0001\t\u0013\u0011I\bC\u0004\u0003\u001a\u0002!IAa'\t\u000f\t\u0005\u0006\u0001\"\u0011\u0002b\"9!1\u0015\u0001\u0005\n\t\u0015\u0006b\u0002BY\u0001\u0011%\u0011\u0011\u001d\u0005\b\u0005g\u0003A\u0011BAq\u0011\u001d\u0011)\f\u0001C\u0005\u0005oCqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003F\u0002!\tEa2\t\u0011\t%\u0007\u0001\"\u0001>\u0003{;qAa3>\u0011\u0003\u0011iM\u0002\u0004={!\u0005!q\u001a\u0005\b\u0003\u000f\nD\u0011\u0001Bl\u0011\u001d\u0011I.\rC\u0001\u00057D\u0011b!\u00032#\u0003%\taa\u0003\t\u0013\r\u0005\u0012'%A\u0005\u0002\r\r\u0002bBB\u0014c\u0011\u00051\u0011\u0006\u0005\n\u0007{\t\u0014\u0013!C\u0001\u0007\u0017A\u0011ba\u00102#\u0003%\taa\t\t\u000f\r\u0005\u0013\u0007\"\u0003\u0004D!I11J\u0019\u0012\u0002\u0013%1Q\n\u0005\b\u0007#\nD\u0011BB*\u0005AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{wM\u0003\u0002?\u007f\u0005!!/\u00194u\u0015\u0005\u0001\u0015!B6bM.\f7\u0001A\n\u0005\u0001\r[U\u000b\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u0006!A.\u00198h\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS#\u0003\r=\u0013'.Z2u!\ta5+D\u0001N\u0015\tqdJ\u0003\u0002A\u001f*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!VJA\u0007SKBd\u0017nY1uK\u0012dun\u001a\t\u0003-fk\u0011a\u0016\u0006\u00031~\nQ!\u001e;jYNL!AW,\u0003\u000f1{wmZ5oO\u0006\u0019An\\4\u0016\u0003u\u0003\"A\u00181\u000e\u0003}S!aW \n\u0005\u0005|&aC!cgR\u0014\u0018m\u0019;M_\u001e\fA\u0001\\8hA\u0005!A/[7f!\t)\u0017.D\u0001g\u0015\tAvM\u0003\u0002i\u001d\u000611m\\7n_:L!A\u001b4\u0003\tQKW.Z\u0001\ng\u000eDW\rZ;mKJ\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\tU$\u0018\u000e\u001c\u0006\u0003c:\u000baa]3sm\u0016\u0014\u0018BA:o\u0005%\u00196\r[3ek2,'/A\u0005t]\u0006\u00048\u000f[8ugB)a/`@\u0002\u00065\tqO\u0003\u0002ys\u00069Q.\u001e;bE2,'B\u0001>|\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002y\u0006)1oY1mC&\u0011ap\u001e\u0002\b)J,W-T1q!\ra\u0015\u0011A\u0005\u0004\u0003\u0007i%AD(gMN,G/\u00118e\u000bB|7\r\u001b\t\u0007\u0003\u000f\tI!!\u0004\u000e\u0003mL1!a\u0003|\u0005\u0019y\u0005\u000f^5p]B!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u00149\u000b\u0001b\u001d8baNDw\u000e^\u0005\u0005\u0003/\t\tBA\u000bGS2,'+Y<T]\u0006\u00048\u000f[8u%\u0016\fG-\u001a:\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011QDA\u0010\u001b\u00059\u0017bAA\u0011O\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AB2p]\u001aLw\r\u0005\u0003\u0002(\u0005%R\"A\u001f\n\u0007\u0005-RHA\tNKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\fA\u0004\\8h'R\f'\u000f^(gMN,Go\u00115b]\u001e,7)\u00197mE\u0006\u001c7\u000e\u0005\u0004\u00022\u0005e\u0012QH\u0007\u0003\u0003gQA!!\u000e\u00028\u0005Aa-\u001e8di&|gN\u0003\u0002p\u000f&!\u00111HA\u001a\u0005!\u0019uN\\:v[\u0016\u0014\bc\u0001#\u0002@%\u0019\u0011\u0011I#\u0003\t1{gnZ\u0001\u001dY><7K\\1qg\"|GoR3oKJ\fG/\u001a3DC2d'-Y2l!\u0015\t\t$!\u000f\u0000\u0003\u0019a\u0014N\\5u}Q\u0011\u00121JA'\u0003\u001f\n\t&a\u0015\u0002V\u0005]\u0013\u0011LA.!\r\t9\u0003\u0001\u0005\u00067*\u0001\r!\u0018\u0005\u0006G*\u0001\r\u0001\u001a\u0005\u0006W*\u0001\r\u0001\u001c\u0005\u0006i*\u0001\r!\u001e\u0005\b\u00033Q\u0001\u0019AA\u000e\u0011\u001d\t\u0019C\u0003a\u0001\u0003KAq!!\f\u000b\u0001\u0004\ty\u0003C\u0004\u0002D)\u0001\r!!\u0012\u0002\tI,\u0017\r\u001a\u000b\u0007\u0003C\n9'a\u001c\u0011\u00071\u000b\u0019'C\u0002\u0002f5\u0013A\u0002T8h\r\u0016$8\r[%oM>Dq!!\u001b\f\u0001\u0004\tY'A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\b\u0003BA\u0004\u0003[J1!!\u0011|\u0011\u001d\t\th\u0003a\u0001\u0003g\nQB]3bI&\u001bx\u000e\\1uS>t\u0007c\u0001'\u0002v%\u0019\u0011qO'\u0003\u0013%\u001bx\u000e\\1uS>t\u0017AD1qa\u0016tG-Q:MK\u0006$WM\u001d\u000b\u0007\u0003{\n\u0019)a%\u0011\u00071\u000by(C\u0002\u0002\u00026\u0013Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bBAC\u0019\u0001\u0007\u0011qQ\u0001\be\u0016\u001cwN\u001d3t!\u0011\tI)a$\u000e\u0005\u0005-%bAAGO\u00061!/Z2pe\u0012LA!!%\u0002\f\n9!+Z2pe\u0012\u001c\bbBAK\u0019\u0001\u0007\u0011qS\u0001\u0006KB|7\r\u001b\t\u0005\u0003\u000f\tI*C\u0002\u0002\u001cn\u00141!\u00138u\u0003A\t\u0007\u000f]3oI\u0006\u001bhi\u001c7m_^,'\u000f\u0006\u0003\u0002~\u0005\u0005\u0006bBAC\u001b\u0001\u0007\u0011qQ\u0001\u001eQ\u0006tG\r\\3B]\u0012\u001cuN\u001c<feRdunZ!qa\u0016tG-\u00138g_R!\u0011QPAT\u0011\u001d\tIK\u0004a\u0001\u0003W\u000b!\"\u00199qK:$\u0017J\u001c4p!\u0011\ti+!/\u000e\u0005\u0005=&bA.\u00022*!\u00111WA[\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u00028:\u000bqa\u001d;pe\u0006<W-\u0003\u0003\u0002\u0002\u0006=\u0016\u0001\u00057bgR4U\r^2iK\u0012,\u0005o\\2i)\t\t9*A\tf]\u0012|eMZ:fi\u001a{'/\u00129pG\"$2a`Ab\u0011\u001d\t)\n\u0005a\u0001\u0003/\u000b\u0011\"\u001a8e\u001f\u001a47/\u001a;\u0015\u0005\u0005%\u0007c\u0001'\u0002L&\u0019\u0011QZ'\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\r\u0006\u0002\u0002l\u0005QAO];oG\u0006$X\rV8\u0015\t\u0005U\u00171\u001c\t\u0005\u0003\u000f\t9.C\u0002\u0002Zn\u0014A!\u00168ji\"9\u0011Q\\\nA\u0002\u0005-\u0014AB8gMN,G/\u0001\rueVt7-\u0019;f)>d\u0015\r^3tiNs\u0017\r]:i_R$\"!a9\u0011\t\u0005\u001d\u0011Q]\u0005\u0004\u0003O\\(a\u0002\"p_2,\u0017M\\\u0001\u0016S:LG/[1mSj,G*Z1eKJ,\u0005o\\2i)\u0011\t).!<\t\u000f\u0005UU\u00031\u0001\u0002\u0018\u0006\u0019R\u000f\u001d3bi\u0016D\u0015n\u001a5XCR,'/\\1sWR!\u0011Q[Az\u0011\u001d\t)P\u0006a\u0001\u0003\u0013\fab\u001c4gg\u0016$X*\u001a;bI\u0006$\u0018-A\u0007iS\u001eDw+\u0019;fe6\f'o[\u0001\u0006M2,8\u000f\u001b\u000b\u0005\u0003+\fi\u0010C\u0004\u0002\u0000b\u0001\r!a9\u0002/\u0019|'oY3GYV\u001c\b.Q2uSZ,7+Z4nK:$HCAA\u000e\u0003\u001d!x\u000e]5d\u0013\u0012$\"Aa\u0002\u0011\t\u0005u!\u0011B\u0005\u0004\u0005\u00179'\u0001B+vS\u0012\f\u0011c\u0019:fCR,g*Z<T]\u0006\u00048\u000f[8u)\u0011\u0011\tBa\b\u0011\r\tM!Q\u0003B\r\u001b\t\t9$\u0003\u0003\u0003\u0018\u0005]\"\u0001C(qi&|g.\u00197\u0011\t\u0005=!1D\u0005\u0005\u0005;\t\tBA\tSC^\u001cf.\u00199tQ>$xK]5uKJDaA!\t\u001c\u0001\u0004y\u0018AC:oCB\u001c\bn\u001c;JI\u0006i1\u000f^8sKNs\u0017\r]:i_R$BA!\u0005\u0003(!1!\u0011\u0005\u000fA\u0002}\fAB]3bINs\u0017\r]:i_R$BA!\f\u00036A1!1\u0003B\u000b\u0005_\u0001B!a\u0004\u00032%!!1GA\t\u0005E\u0011\u0016m^*oCB\u001c\bn\u001c;SK\u0006$WM\u001d\u0005\u0007\u0005Ci\u0002\u0019A@\u0002\u001d1\fG/Z:u':\f\u0007o\u001d5piR\u0011!QF\u0001\u0018Y\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u\u0003R|%OQ3m_^$BA!\f\u0003@!9!\u0011I\u0010A\u0002\u0005-\u0014!C7bq>3gm]3u\u0003Aa\u0017\r^3tiNs\u0017\r]:i_RLE\r\u0006\u0002\u0003HA)!1\u0003B\u000b\u007f\u0006\u0011R-\u0019:mS\u0016\u001cHo\u00158baNDw\u000e^%e\u0003-\u0019h.\u00199tQ>$\u0018\nZ:\u0015\u0005\t=\u0003#\u0002B\n\u0005#z\u0018\u0002\u0002B*\u0003o\u0011\u0011bU8si\u0016$7+\u001a;\u0002!=t7K\\1qg\"|GO\u0012:pu\u0016tG\u0003BAk\u00053BaA!\t$\u0001\u0004y\u0018\u0001\u00063fY\u0016$XMQ3g_J,7K\\1qg\"|G\u000f\u0006\u0003\u0002d\n}\u0003B\u0002B\u0011I\u0001\u0007q0\u0001\rmK\u0006$WM]#q_\u000eD7\t[1j]N+\b\u000f\u001d7jKJ$\"A!\u001a\u0011\r\u0005E\"q\rB6\u0013\u0011\u0011I'a\r\u0003\u0011M+\b\u000f\u001d7jKJ\u0004\u0002Ba\u0005\u0003n\tE\u0014QH\u0005\u0005\u0005_\n9DA\u0002NCB\u00042\u0001\u0012B:\u0013\r\u0011)(\u0012\u0002\b\u0013:$XmZ3s\u0003Eaw.\u00193T]\u0006\u00048\u000f[8u'&TXm\u001d\u000b\u0003\u0005w\u0002bA! \u0003\u000e\nMe\u0002\u0002B@\u0005\u0013sAA!!\u0003\b6\u0011!1\u0011\u0006\u0004\u0005\u000b\u000b\u0015A\u0002\u001fs_>$h(C\u0001}\u0013\r\u0011Yi_\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yI!%\u0003\u0007M+\u0017OC\u0002\u0003\fn\u0004r!a\u0002\u0003\u0016~\fY'C\u0002\u0003\u0018n\u0014a\u0001V;qY\u0016\u0014\u0014!\u0006:fC\u0012\u001cf.\u00199tQ>$H+[7fgR\fW\u000e\u001d\u000b\u0005\u0005;\u0013y\n\u0005\u0004\u0002\b\u0005%\u00111\u000e\u0005\u0007\u0005C9\u0003\u0019A@\u0002\u00155\f\u0017PY3DY\u0016\fg.\u0001\bdY\u0016\fgn\u00158baNDw\u000e^:\u0015\t\u0005\r(q\u0015\u0005\b\u0005SK\u0003\u0019\u0001BV\u0003%\u0001(/\u001a3jG\u0006$X\rE\u0004\u0002\b\t5v0a9\n\u0007\t=6PA\u0005Gk:\u001cG/[8oc\u0005I2\r\\3b]Ns\u0017\r]:i_R\u001c(+\u001a;f]RLwN\\'t\u0003m\u0019G.Z1o':\f\u0007o\u001d5piN\u0014V\r^3oi&|gnU5{K\u0006)bm\u001c:hKR\u001cf.\u00199tQ>$8OQ3g_J,GcA;\u0003:\"1!1\u0018\u0017A\u0002}\f!\u0003\\8h'R\f'\u000f^*oCB\u001c\bn\u001c;JI\u0006y!/Z7pm\u0016\u001cf.\u00199tQ>$8\u000f\u0006\u0003\u0002V\n\u0005\u0007B\u0002Bb[\u0001\u0007Q/\u0001\tfqBL'/\u001a3T]\u0006\u00048\u000f[8ug\u0006)1\r\\8tKR\u0011\u0011Q[\u0001\u000eg:\f\u0007o\u001d5pi\u000e{WO\u001c;\u0002!-\u000bgm[1NKR\fG-\u0019;b\u0019><\u0007cAA\u0014cM!\u0011G!5V!\u0011\t9Aa5\n\u0007\tU7P\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u001b\fQ!\u00199qYf$B#a\u0013\u0003^\n}'\u0011\u001dBy\u0005g\u001c\taa\u0001\u0004\u0006\r\u001d\u0001bBA\rg\u0001\u0007\u00111\u0004\u0005\b\u0005\u0007\u0019\u0004\u0019\u0001B\u0004\u0011\u001d\u0011\u0019o\ra\u0001\u0005K\fq\u0001Z1uC\u0012K'\u000f\u0005\u0003\u0003h\n5XB\u0001Bu\u0015\r\u0011YoR\u0001\u0003S>LAAa<\u0003j\n!a)\u001b7f\u0011\u0015\u00197\u00071\u0001e\u0011\u001d\u0011)p\ra\u0001\u0005o\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0003z\nuXB\u0001B~\u0015\r\u0011)pZ\u0005\u0005\u0005\u007f\u0014YPA\u0004NKR\u0014\u0018nY:\t\u000b-\u001c\u0004\u0019\u00017\t\u000f\u0005\r2\u00071\u0001\u0002&!I\u0011QF\u001a\u0011\u0002\u0003\u0007\u0011q\u0006\u0005\n\u0003\u0007\u001a\u0004\u0013!a\u0001\u0003\u000b\nq\"\u00199qYf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0007\u001bQC!a\f\u0004\u0010-\u00121\u0011\u0003\t\u0005\u0007'\u0019i\"\u0004\u0002\u0004\u0016)!1qCB\r\u0003%)hn\u00195fG.,GMC\u0002\u0004\u001cm\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019yb!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0019)C\u000b\u0003\u0002F\r=\u0011!F2sK\u0006$XmV5uQ>,HOU3d_Z,'/\u001f\u000b\u0015\u0003\u0017\u001aYc!\f\u00040\rE21GB\u001b\u0007o\u0019Ida\u000f\t\u000f\u0005ea\u00071\u0001\u0002\u001c!9!1\u0001\u001cA\u0002\t\u001d\u0001b\u0002Brm\u0001\u0007!Q\u001d\u0005\u0006GZ\u0002\r\u0001\u001a\u0005\b\u0005k4\u0004\u0019\u0001B|\u0011\u0015Yg\u00071\u0001m\u0011\u001d\t\u0019C\u000ea\u0001\u0003KA\u0011\"!\f7!\u0003\u0005\r!a\f\t\u0013\u0005\rc\u0007%AA\u0002\u0005\u0015\u0013aH2sK\u0006$XmV5uQ>,HOU3d_Z,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u0005y2M]3bi\u0016<\u0016\u000e\u001e5pkR\u0014VmY8wKJLH\u0005Z3gCVdG\u000fJ\u001d\u0002!I,7m\u001c<feNs\u0017\r]:i_R\u001cH#B;\u0004F\r\u001d\u0003\"B.:\u0001\u0004i\u0006\"CB%sA\u0005\t\u0019AAr\u0003-\tG\u000e\\8x\t\u0016dW\r^3\u00025I,7m\u001c<feNs\u0017\r]:i_R\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r=#\u0006BAr\u0007\u001f\t1\u0003Z3mKR,7K\\1qg\"|GOR5mKN$\u0002\"!6\u0004V\r%41\u000e\u0005\b\u0007/Z\u0004\u0019AB-\u0003\u0019awn\u001a#jeB!11LB3\u001b\t\u0019iF\u0003\u0003\u0004`\r\u0005\u0014\u0001\u00024jY\u0016T1aa\u0019H\u0003\rq\u0017n\\\u0005\u0005\u0007O\u001aiF\u0001\u0003QCRD\u0007B\u0002Bbw\u0001\u0007Q\u000f\u0003\u0004\u0004nm\u0002\r!V\u0001\bY><w-\u001b8h\u0001")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final AbstractLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private final Consumer<Long> logStartOffsetChangeCallback;
    private final Consumer<OffsetAndEpoch> logSnapshotGeneratedCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Consumer<OffsetAndEpoch> createWithoutRecovery$default$9() {
        return KafkaMetadataLog$.MODULE$.createWithoutRecovery$default$9();
    }

    public static Consumer<Long> createWithoutRecovery$default$8() {
        return KafkaMetadataLog$.MODULE$.createWithoutRecovery$default$8();
    }

    public static KafkaMetadataLog createWithoutRecovery(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config, Consumer<Long> logStartOffsetChangeCallback, Consumer<OffsetAndEpoch> logSnapshotGeneratedCallback) {
        return KafkaMetadataLog$.MODULE$.createWithoutRecovery(topicPartition, topicId, dataDir, time, metrics, scheduler, config, logStartOffsetChangeCallback, logSnapshotGeneratedCallback);
    }

    public static Consumer<OffsetAndEpoch> apply$default$9() {
        return KafkaMetadataLog$.MODULE$.apply$default$9();
    }

    public static Consumer<Long> apply$default$8() {
        return KafkaMetadataLog$.MODULE$.apply$default$8();
    }

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config, Consumer<Long> logStartOffsetChangeCallback, Consumer<OffsetAndEpoch> logSnapshotGeneratedCallback) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, topicId, dataDir, time, metrics, scheduler, config, logStartOffsetChangeCallback, logSnapshotGeneratedCallback);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AbstractLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        FetchIsolation fetchIsolation;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.HIGH_WATERMARK;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.LOG_END;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        FetchIsolation isolation = fetchIsolation;
        AbstractFetchDataInfo abstractFetchDataInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), isolation, true, false);
        if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
            throw new IllegalStateException("Raft log should not have fetched tiered data");
        }
        FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
        return new LogFetchInfo(fetchDataInfo.records, new LogOffsetMetadata(fetchDataInfo.fetchOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(fetchDataInfo.fetchOffsetMetadata.segmentBaseOffset, fetchDataInfo.fetchOffsetMetadata.relativePositionInSegment))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        MetadataVersion x$5 = this.log().appendAsLeader$default$4();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, AppendOrigin.RAFT_LEADER, x$5, x$4));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        if (appendInfo.firstOffset().isPresent()) {
            return new org.apache.kafka.raft.LogAppendInfo(((org.apache.kafka.storage.internals.log.LogOffsetMetadata)appendInfo.firstOffset().get()).messageOffset, appendInfo.lastOffset());
        }
        throw new KafkaException(new StringBuilder(28).append("Append failed unexpectedly: ").append(appendInfo.errorMessage()).toString());
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<org.apache.kafka.server.common.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset() && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
                }
            }
        }
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public LogOffsetMetadata endOffset() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new LogOffsetMetadata(endOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset, endOffsetMetadata.relativePositionInSegment)));
    }

    public long startOffset() {
        return this.log().localLogStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset) {
            throw new IllegalArgumentException(new StringBuilder(74).append("Attempt to truncate to offset ").append(offset).append(", which is below ").append("the current high watermark ").append(this.highWatermark().offset).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * WARNING - void declaration
     */
    public boolean truncateToLatestSnapshot() {
        void var5_8;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap;
        boolean bl;
        OffsetAndEpoch snapshotId;
        int latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (option instanceof Some && ((snapshotId = (OffsetAndEpoch)((Some)option).value()).epoch() > latestEpoch || snapshotId.epoch() == latestEpoch && snapshotId.offset() > this.endOffset().offset)) {
            this.log().truncateFullyAndStartAt(snapshotId.offset());
            TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap2 = this.snapshots;
            synchronized (treeMap2) {
                TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap3 = this.forgetSnapshotsBefore(snapshotId);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
                treeMap = treeMap3;
            }
        } else {
            bl = false;
            treeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        }
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap4 = treeMap;
        boolean truncated = bl;
        this.removeSnapshots(treeMap4);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            this.log().updateHighWatermark(new org.apache.kafka.storage.internals.log.LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
            return;
        }
        this.log().updateHighWatermark(offsetMetadata.offset);
    }

    public LogOffsetMetadata highWatermark() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata hwm = this.log().fetchOffsetSnapshot().highWatermark;
        Optional segmentPosition = hwm.messageOffsetOnly() ? Optional.of(new SegmentPosition(hwm.segmentBaseOffset, hwm.relativePositionInSegment)) : Optional.empty();
        return new LogOffsetMetadata(hwm.messageOffset, segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId);
                Object var6_2 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset;
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.storeSnapshot(snapshotId);
    }

    public Optional<RawSnapshotWriter> storeSnapshot(OffsetAndEpoch snapshotId) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId, Optional.of(this)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshotAtOrBelow(long maxOffset) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(((IterableOps)this.snapshots.keys().filter((Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$latestSnapshotAtOrBelow$1(maxOffset, snapshotId)))).lastOption())).flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SortedSet<OffsetAndEpoch> snapshotIds() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            void var2_2;
            TreeSet snapshotIds = new TreeSet();
            snapshotIds.addAll(CollectionConverters$.MODULE$.SetHasAsJava((Set)this.snapshots.keySet()).asJava());
            return var2_2;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
        }
        this.logSnapshotGeneratedCallback.accept(snapshotId);
    }

    /*
     * Unable to fully structure code
     */
    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            var3_3 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var3_3 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var3_3).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset() && snapshotId.offset() <= latestSnapshotId.offset() && this.log().maybeIncrementLogStartOffset(snapshotId.offset(), LogStartOffsetIncrementReason.SnapshotGenerated)) {
                this.log().deleteOldSegments();
                this.logStartOffsetChangeCallback.accept(Predef$.MODULE$.long2Long(this.log().logStartOffset()));
                v0 = true;
                v1 = this.forgetSnapshotsBefore(snapshotId);
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            }
            var6_5 = v1;
            var5_6 = v0;
        }
        this.removeSnapshots(var6_5);
        return var5_6;
    }

    public Supplier<Map<Integer, Long>> leaderEpochChainSupplier() {
        return (Supplier)this.log().leaderEpochCache().map((Function1 & Serializable)cache -> () -> cache.copyEpochEntries()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Illegal state encountered: leader epoch cache does not exist.");
        });
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable)snapshotId -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes()))));
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).map((Function1 & Serializable)reader -> BoxesRunTime.boxToLong((long)KafkaMetadataLog.$anonfun$readSnapshotTimestamp$1(reader)));
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Object> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, object, x0$1)));
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$1(snapshotId));
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, object, x0$1)));
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        scala.collection.immutable.Map snapshotSizes = this.loadSnapshotSizes().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$2(snapshotId, snapshotSizes, snapshotTotalSize));
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, object, x0$1)));
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapOps)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((IterableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$removeSnapshots$2(snapshotId);
                    Object var3_3 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.scheduleOnce("delete-snapshot-files", () -> KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableOnceOps)this.snapshots.values().flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset() == $this.startOffset() && snapshotId.offset() == logEndOffset) {
            return snapshotId.epoch();
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ boolean $anonfun$latestSnapshotAtOrBelow$1(long maxOffset$1, OffsetAndEpoch snapshotId) {
        return snapshotId.offset() <= maxOffset$1;
    }

    public static final /* synthetic */ long $anonfun$readSnapshotTimestamp$1(RawSnapshotReader reader) {
        return Snapshots.lastContainedLogTimestamp((RawSnapshotReader)reader);
    }

    public static final /* synthetic */ boolean $anonfun$cleanSnapshots$1(KafkaMetadataLog $this, Function1 predicate$1, BooleanRef didClean$1, Object nonLocalReturnKey1$1, Seq x0$1) {
        SeqOps seqOps;
        if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
            new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (snapshot != null && nextSnapshot != null) {
                    if (BoxesRunTime.unboxToBoolean((Object)predicate$1.apply((Object)snapshot)) && $this.deleteBeforeSnapshot(nextSnapshot)) {
                        didClean$1.elem = true;
                        return true;
                    }
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, didClean$1.elem);
                }
            }
        }
        return false;
    }

    private final boolean shouldClean$1(OffsetAndEpoch snapshotId) {
        long now = this.time.milliseconds();
        return this.readSnapshotTimestamp(snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)timestamp -> now - timestamp > $this.config.retentionMillis());
    }

    private final boolean shouldClean$2(OffsetAndEpoch snapshotId, scala.collection.immutable.Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)snapshotSize -> {
            if (this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
                snapshotTotalSize$1.elem -= snapshotSize;
                return true;
            }
            return false;
        });
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(OffsetAndEpoch snapshotId$4) {
        return new StringBuilder(30).append("Marking snapshot ").append(snapshotId$4).append(" for deletion").toString();
    }

    public KafkaMetadataLog(AbstractLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config, Consumer<Long> logStartOffsetChangeCallback, Consumer<OffsetAndEpoch> logSnapshotGeneratedCallback) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        this.logStartOffsetChangeCallback = logStartOffsetChangeCallback;
        this.logSnapshotGeneratedCallback = logSnapshotGeneratedCallback;
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }
}

