/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.util.List;
import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaTierPartitionStatusRequest;
import kafka.restore.messages.KafkaUnfreezeResponse;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;
import kafka.tier.state.TierPartitionStatus;

public class PartitionRestoredToRestoreStartOffsetEventSentTransition
extends AbstractTransition {
    public PartitionRestoredToRestoreStartOffsetEventSentTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.PARTITION_RESTORED;
    }

    @Override
    public State getTargetState() {
        return State.RESTORE_START_OFFSET_EVENT_SENT;
    }

    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof KafkaUnfreezeResponse)) {
            return false;
        }
        KafkaUnfreezeResponse response = (KafkaUnfreezeResponse)event.getData("message_response");
        NodeConfig broker = (NodeConfig)fsm.getMetadata("partition_leader");
        List replicas = (List)fsm.getMetadata("partition_replicas");
        KafkaTierPartitionStatusRequest request = new KafkaTierPartitionStatusRequest(0, response.getTopic(), response.getPartition(), broker, replicas, TierPartitionStatus.ONLINE.ordinal());
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

