/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.metadata.ClusterLinkInfo;
import kafka.controller.KafkaController;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.metadata.ZkMetadataCache;
import kafka.zk.AdminZkClient;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r\rb\u0001\u0002\u00192\u0001aB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Ia\t\u0001B\u0001B\u0003%q)\u0014\u0005\n\u001d\u0002\u0011\t\u0011)A\u0005\u001fJC\u0001b\u0015\u0001\u0003\u0006\u0004%I\u0001\u0016\u0005\t7\u0002\u0011\t\u0011)A\u0005+\"AA\f\u0001BC\u0002\u0013%Q\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003_\u0011!)\u0007A!A!\u0002\u00131\u0007\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0011u\u0004!\u0011!Q\u0001\nyD!\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011\u001d\ty\u0002\u0001C\u0001\u0003CA\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003{Aq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002P\u0001!\t%!\u0015\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003\u000b\u0004A\u0011IAd\u0011\u001d\t)\r\u0001C!\u0003\u0017Dq!!2\u0001\t\u0003\n9\u000eC\u0004\u0002Z\u0002!\t%a7\t\u000f\u0005e\u0007\u0001\"\u0011\u0002`\"9\u0011\u0011\u001c\u0001\u0005B\u0005]\u0007bBAr\u0001\u0011\u0005\u0013Q\u001d\u0005\b\u0003O\u0004A\u0011IAu\u0011\u001d\ti\u000f\u0001C!\u0003_Dq!!?\u0001\t\u0003\nY\u0010C\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\u0005}\b\u0001\"\u0011\u0003\u000e!9!\u0011\u0003\u0001\u0005B\tM\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005[\u0001A\u0011\tB\u0018\u0011\u001d\u0011\u0019\u0005\u0001C!\u0005\u000bBqAa\u0015\u0001\t\u0003\u0012)\u0006C\u0004\u0003`\u0001!\tE!\u0019\t\u000f\t\u0015\u0004\u0001\"\u0011\u0003h!I!1\u0010\u0001\u0012\u0002\u0013\u0005!Q\u0010\u0005\b\u0005'\u0003A\u0011\tBK\u0011\u001d\u0011y\f\u0001C!\u0005\u0003DqA!2\u0001\t\u0003\u00129\rC\u0004\u0003\\\u0002!\tE!8\t\u000f\tm\u0007\u0001\"\u0001\u0003\u0000\"911\u0001\u0001\u0005\n\r\u0015\u0001\"DB\r\u0001A\u0005\u0019\u0011!A\u0005\n\rmQJA\u0014DYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'oV5uQj[7+\u001e9q_J$(B\u0001\u001a4\u0003\u0011a\u0017N\\6\u000b\u0005Q*\u0014AB:feZ,'OC\u00017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001d\u0011\u0005iZT\"A\u0019\n\u0005q\n$AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA A\u001b\u0005\u0019\u0014BA!4\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001\u001eE\u0013\t)\u0015G\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005![U\"A%\u000b\u0005)\u001b\u0014\u0001C7fi\u0006$\u0017\r^1\n\u00051K%a\u0004.l\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\n\u0005\u0019[\u0014\u0001G2p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feB\u0011q\bU\u0005\u0003#N\u0012\u0001E\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe&\u0011ajO\u0001\u0010W\u000647.Y\"p]R\u0014x\u000e\u001c7feV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002Yk\u0005Q1m\u001c8ue>dG.\u001a:\n\u0005i;&aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002!-\fgm[1D_:$(o\u001c7mKJ\u0004\u0013\u0001\u0003>l\u00072LWM\u001c;\u0016\u0003y\u0003\"a\u00182\u000e\u0003\u0001T!!Y\u001b\u0002\u0005i\\\u0017BA2a\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006I!p[\"mS\u0016tG\u000fI\u0001\u0012Y>\u001c\u0017\r\\!e[&tg)Y2u_JL\bcA4kY6\t\u0001NC\u0001j\u0003\u0015\u00198-\u00197b\u0013\tY\u0007NA\u0005Gk:\u001cG/[8oaA\u0011Qn^\u0007\u0002]*\u0011q\u000e]\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003cJ\fqa\u00197jK:$8O\u0003\u00027g*\u0011A/^\u0001\u0007CB\f7\r[3\u000b\u0003Y\f1a\u001c:h\u0013\tAhNA\u0003BI6Lg.\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005}Z\u0018B\u0001?4\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!b]3sm\u0016\u0014\u0018J\u001c4p!\ry\u0018qA\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005Q\u0012\u0018\u0002BA\u0005\u0003\u0003\u0011A#Q;uQ>\u0014\u0018N_3s'\u0016\u0014h/\u001a:J]\u001a|\u0017a\u0005>l\u001b\u0016$\u0018\rZ1uC\u000e{G\u000e\\3di>\u0014\b#B4\u0002\u0010\u0005M\u0011bAA\tQ\n1q\n\u001d;j_:\u0004B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033)\u0014aB2bi\u0006dwnZ\u0005\u0005\u0003;\t9BA\n[\u00176+G/\u00193bi\u0006\u001cu\u000e\u001c7fGR|'/\u0001\u0004=S:LGO\u0010\u000b\u0017\u0003G\t)#a\n\u0002*\u0005-\u0012QFA\u0018\u0003c\t\u0019$!\u000e\u00028A\u0011!\b\u0001\u0005\u0006{5\u0001\rA\u0010\u0005\u0006\u00056\u0001\ra\u0011\u0005\u0006\r6\u0001\ra\u0012\u0005\u0006\u001d6\u0001\ra\u0014\u0005\u0006'6\u0001\r!\u0016\u0005\u000696\u0001\rA\u0018\u0005\u0006K6\u0001\rA\u001a\u0005\u0006s6\u0001\rA\u001f\u0005\u0006{6\u0001\rA \u0005\b\u0003\u0017i\u0001\u0019AA\u0007\u00035\tG-\\5o5.\u001cE.[3oiV\u0011\u0011Q\b\t\u0004?\u0006}\u0012bAA!A\ni\u0011\tZ7j]j[7\t\\5f]R\fa\"\u00193nS:T6n\u00117jK:$\b%\u0001\rjg2Kgn[\"p_J$\u0017N\\1u_J,e.\u00192mK\u0012,\"!!\u0013\u0011\u0007\u001d\fY%C\u0002\u0002N!\u0014qAQ8pY\u0016\fg.A\tjg2Kgn[\"p_J$\u0017N\\1u_J$B!!\u0013\u0002T!9\u0011QK\tA\u0002\u0005]\u0013\u0001\u00037j].t\u0015-\\3\u0011\t\u0005e\u0013q\r\b\u0005\u00037\n\u0019\u0007E\u0002\u0002^!l!!a\u0018\u000b\u0007\u0005\u0005t'\u0001\u0004=e>|GOP\u0005\u0004\u0003KB\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002j\u0005-$AB*ue&twMC\u0002\u0002f!\fq\u0002\\5oW\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0007\u0003c\ny(!!\u0011\u000b\u001d\fy!a\u001d\u0011\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001fs\u0003\u0019\u0019w.\\7p]&!\u0011QPA<\u0005\u0011qu\u000eZ3\t\u000f\u0005U#\u00031\u0001\u0002X!9\u00111\u0011\nA\u0002\u0005\u0015\u0015\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BAD\u0003\u001bk!!!#\u000b\t\u0005-\u0015qO\u0001\b]\u0016$xo\u001c:l\u0013\u0011\ty)!#\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u00175L'O]8s)>\u0004\u0018n\u0019\u000b\u0005\u0003+\u000b\t\u000bE\u0003h\u0003\u001f\t9\n\u0005\u0003\u0002\u001a\u0006uUBAAN\u0015\tQ%/\u0003\u0003\u0002 \u0006m%aC'jeJ|'\u000fV8qS\u000eDq!a)\u0014\u0001\u0004\t9&A\u0003u_BL7-\u0001\u0012nSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKN4%o\\7NKR\fG-\u0019;b'R|'/\u001a\u000b\u0005\u0003S\u000bY\f\u0005\u0005\u0002,\u0006E\u0016qKA[\u001b\t\tiKC\u0002\u00020\"\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019,!,\u0003\u00075\u000b\u0007\u000fE\u0002;\u0003oK1!!/2\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016Dq!!0\u0015\u0001\u0004\ty,\u0001\u0004u_BL7m\u001d\t\u0007\u00033\n\t-a\u0016\n\t\u0005\r\u00171\u000e\u0002\u0004'\u0016$\u0018AJ7jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fg\u001a\u0013x.\\\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiR!\u0011\u0011VAe\u0011\u001d\ti,\u0006a\u0001\u0003\u007f#B!!+\u0002N\"9\u0011q\u001a\fA\u0002\u0005E\u0017A\u00027j].LE\r\u0005\u0003\u0002v\u0005M\u0017\u0002BAk\u0003o\u0012A!V;jIR\u0011\u0011\u0011V\u0001#[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u001chI]8n\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0015\t\u0005%\u0016Q\u001c\u0005\b\u0003\u001fD\u0002\u0019AAi)\u0011\tI+!9\t\u000f\u0005u\u0016\u00041\u0001\u0002@\u0006)r-\u001a;BY2$v\u000e]5dg&s7\t\\;ti\u0016\u0014HCAA`\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\u0011\tI%a;\t\u000f\u0005\rF\u00041\u0001\u0002X\u00059RM\\:ve\u0016\u001cE.^:uKJd\u0015N\\6Fq&\u001cHo\u001d\u000b\u0005\u0003c\f9\u0010E\u0002h\u0003gL1!!>i\u0005\u0011)f.\u001b;\t\u000f\u0005=W\u00041\u0001\u0002R\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u000bbL7\u000f^:\u0015\t\u0005%\u0013Q \u0005\b\u0003\u001ft\u0002\u0019AAi\u0003I9W\r^\"mkN$XM\u001d'j].$\u0015\r^1\u0015\t\t\r!1\u0002\t\u0006O\u0006=!Q\u0001\t\u0004?\n\u001d\u0011b\u0001B\u0005A\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018\rC\u0004\u0002P~\u0001\r!!5\u0015\t\t\r!q\u0002\u0005\b\u0003+\u0002\u0003\u0019AA,\u0003e9W\r^\"mkN$XM\u001d'j].\u001cuN\u001c4jOB\u0013x\u000e]:\u0015\t\tU!Q\u0005\t\u0005\u0005/\u0011\t#\u0004\u0002\u0003\u001a)!!1\u0004B\u000f\u0003\u0011)H/\u001b7\u000b\u0005\t}\u0011\u0001\u00026bm\u0006LAAa\t\u0003\u001a\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005=\u0017\u00051\u0001\u0002R\u0006qq-\u001a;U_BL7mQ8oM&<G\u0003\u0002B\u000b\u0005WAq!a)#\u0001\u0004\t9&A\u000ebYR,'o\u00117vgR,'\u000fT5oW\u000e{gNZ5h5:{G-\u001a\u000b\u000b\u0003c\u0014\tDa\r\u00036\te\u0002bBAhG\u0001\u0007\u0011\u0011\u001b\u0005\b\u0003+\u001a\u0003\u0019AA,\u0011\u001d\u00119d\ta\u0001\u0005+\tq\u0002]3sg&\u001cH/\u001a8u!J|\u0007o\u001d\u0005\b\u0005w\u0019\u0003\u0019\u0001B\u001f\u0003)a\u0017N\\6D_:4\u0017n\u001a\t\u0004u\t}\u0012b\u0001B!c\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002A5\f\u0017PY3SK\u0016t7M]=qi\u000ecWo\u001d;fe2Kgn[\"p]\u001aLwm\u001d\u000b\u0005\u0003c\u00149\u0005C\u0004\u0003J\u0011\u0002\rAa\u0013\u0002#\r|gNZ5h)J\fgn\u001d4pe6,'\u000fE\u0004h\u0005\u001b\u0012)B!\u0015\n\u0007\t=\u0003NA\u0005Gk:\u001cG/[8ocA)q-a\u0004\u0003\u0016\u000512M]3bi\u0016\u001cE.^:uKJd\u0015N\\6[\u001d>$W\r\u0006\u0004\u0002r\n]#1\f\u0005\b\u00053*\u0003\u0019\u0001B\u0003\u0003=\u0019G.^:uKJd\u0015N\\6ECR\f\u0007b\u0002B/K\u0001\u0007!QC\u0001\u0006aJ|\u0007o]\u0001\u0014g\u0016$8\t\\;ti\u0016\u0014H*\u001b8l5:{G-\u001a\u000b\u0005\u0003c\u0014\u0019\u0007C\u0004\u0003Z\u0019\u0002\rA!\u0002\u0002+\u0005dG/\u001a:NSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKRQ\u0011\u0011\u001fB5\u0005W\u0012\u0019Ha\u001e\t\u000f\u0005\rv\u00051\u0001\u0002X!9!QN\u0014A\u0002\t=\u0014\u0001D:uCR,W\u000b\u001d3bi\u0016\u0014\bcB4\u0003N\u0005U&\u0011\u000f\t\u0006O\u0006=\u0011Q\u0017\u0005\b\u0005k:\u0003\u0019AA%\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011%\u0011Ih\nI\u0001\u0002\u0004\tI%A\bgC&d\u0017J\u001a(pi6K'O]8s\u0003}\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u007fRC!!\u0013\u0003\u0002.\u0012!1\u0011\t\u0005\u0005\u000b\u0013y)\u0004\u0002\u0003\b*!!\u0011\u0012BF\u0003%)hn\u00195fG.,GMC\u0002\u0003\u000e\"\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tJa\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nde\u0016\fG/Z\"mkN$XM\u001d'j].\u001cH\u0003\u0002BL\u0005_\u0003bA!'\u0003 \n\rVB\u0001BN\u0015\u0011\u0011iJ!\u0007\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003\"\nm%!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!!Q\u0015BV\u001b\t\u00119K\u0003\u0003\u0003*\u0006]\u0014\u0001\u0003:fcV,7\u000f^:\n\t\t5&q\u0015\u0002\u001b\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\7OU3ta>t7/\u001a\u0005\b\u0005cK\u0003\u0019\u0001BZ\u0003u\u0019'/Z1uK\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;ECR\f\u0007\u0003\u0002B[\u0005wk!Aa.\u000b\t\te\u0016qO\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011iLa.\u0003;\r\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7n\u001d*fcV,7\u000f\u001e#bi\u0006\fa\u0003Z3mKR,7\t\\;ti\u0016\u0014H*\u001b8l5:{G-\u001a\u000b\u0005\u0003c\u0014\u0019\rC\u0004\u0002P*\u0002\r!!5\u0002/\u001d,G/\u00117m\u0019&t7n\u001d$s_6lU\r^1eCR\fGC\u0001Be!\u0019\u0011YM!6\u0003\u00069!!Q\u001aBi\u001d\u0011\tiFa4\n\u0003%L1Aa5i\u0003\u001d\u0001\u0018mY6bO\u0016LAAa6\u0003Z\n\u00191+Z9\u000b\u0007\tM\u0007.A\bti>\u0004X*\u001b:s_J$v\u000e]5d)\u0019\u0011yN!=\u0003tB1\u0011Q\u000fBq\u0005KLAAa9\u0002x\tY1*\u00194lC\u001a+H/\u001e:f!\u0011\u00119O!<\u000e\u0005\t%(\u0002\u0002Bv\u0005;\tA\u0001\\1oO&!!q\u001eBu\u0005\u00111v.\u001b3\t\u000f\u0005\rF\u00061\u0001\u0002X!9!Q\u001f\u0017A\u0002\t]\u0018!\u00047pO\u0016sGm\u00144gg\u0016$8\u000f\u0005\u0004\u0003L\nU'\u0011 \t\u0004O\nm\u0018b\u0001B\u007fQ\n!Aj\u001c8h)\u0011\u0011yn!\u0001\t\u000f\u0005\rV\u00061\u0001\u0002X\u0005\u0011r-\u001a;DYV\u001cH/\u001a:MS:\\\u0017J\u001c4p)\u0019\u00199a!\u0005\u0004\u0016A!1\u0011BB\u0007\u001b\t\u0019YAC\u0002K\u0003/IAaa\u0004\u0004\f\ty1\t\\;ti\u0016\u0014H*\u001b8l\u0013:4w\u000eC\u0004\u0004\u00149\u0002\rA!\u0002\u0002\u0007\rdG\rC\u0004\u0004\u00189\u0002\rA!\u0010\u0002\r\r|gNZ5h\u0003M\u0019X\u000f]3sI5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\u0019i\u0002E\u0002@\u0007?I1a!\t4\u00055iU\r^1eCR\f7)Y2iK\u0002")
public class ClusterLinkMetadataManagerWithZkSupport
extends ClusterLinkMetadataManager {
    private final KafkaConfig brokerConfig;
    private final KafkaController kafkaController;
    private final KafkaZkClient zkClient;
    private final ReplicaManager replicaManager;
    private final Option<ZKMetadataCollector> zkMetadataCollector;
    private final AdminZkClient adminZkClient;

    private /* synthetic */ MetadataCache super$metadataCache() {
        return super.metadataCache();
    }

    private KafkaController kafkaController() {
        return this.kafkaController;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    @Override
    public boolean isLinkCoordinatorEnabled() {
        return ((ZkMetadataCache)super.metadataCache()).linkCoordinatorEnabled();
    }

    @Override
    public boolean isLinkCoordinator(String linkName) {
        if (this.isLinkCoordinatorEnabled()) {
            return super.isLinkCoordinator(linkName);
        }
        return this.kafkaController().isActive();
    }

    @Override
    public Option<Node> linkCoordinator(String linkName, ListenerName listenerName) {
        if (!Predef$.MODULE$.Boolean2boolean(this.brokerConfig.clusterLinkMetadataTopicEnable())) {
            int controllerId = ((ZkMetadataCache)super.metadataCache()).getZkControllerId(false);
            if (controllerId == Node.noNode().id()) {
                return None$.MODULE$;
            }
            return ((ZkMetadataCache)super.metadataCache()).getAliveBrokerNode(controllerId, listenerName);
        }
        return super.linkCoordinator(linkName, listenerName);
    }

    @Override
    public Option<MirrorTopic> mirrorTopic(String topic) {
        throw new IllegalStateException("TopicImage not supported with Zookeeper");
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(Set<String> topics) {
        return this.zkClient().getClusterLinkForTopics(topics);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Set<String> topics) {
        if (this.kafkaController().isActive()) {
            return ((IterableOnceOps)this.kafkaController().controllerContext().linkedTopics().filter((Function1 & Serializable)keyVal -> BoxesRunTime.boxToBoolean((boolean)topics.contains(keyVal._1())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return (Map)Map$.MODULE$.empty();
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid linkId) {
        if (this.kafkaController().isActive()) {
            return ((IterableOnceOps)this.kafkaController().controllerContext().linkedTopics().filter((Function1 & Serializable)cl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithZkSupport.$anonfun$mirrorTopicStatesFromControllerContext$2(linkId, cl)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return (Map)Map$.MODULE$.empty();
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext() {
        if (this.kafkaController().isActive()) {
            return this.kafkaController().controllerContext().linkedTopics();
        }
        return (Map)Map$.MODULE$.empty();
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid linkId) {
        if (!this.isLinkCoordinatorEnabled()) {
            return this.mirrorTopicStatesFromControllerContext(linkId);
        }
        return (Map)((ZkMetadataCache)super.metadataCache()).mirrorTopicStates().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithZkSupport.$anonfun$mirrorTopicStatesFromMetadataCache$1(linkId, x$1)));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Set<String> topics) {
        if (!this.isLinkCoordinatorEnabled()) {
            return this.mirrorTopicStatesFromControllerContext(topics);
        }
        return ((IterableOnceOps)((IterableOps)topics.map((Function1 & Serializable)topic -> new Tuple2(topic, ((ZkMetadataCache)this.super$metadataCache()).mirrorTopicStates().get(topic).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithZkSupport.$anonfun$mirrorTopicStatesFromMetadataCache$3(x$2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache() {
        if (!this.isLinkCoordinatorEnabled()) {
            return this.mirrorTopicStatesFromControllerContext();
        }
        return ((ZkMetadataCache)super.metadataCache()).mirrorTopicStates();
    }

    @Override
    public Set<String> getAllTopicsInCluster() {
        return this.zkClient().getAllTopicsInCluster(this.zkClient().getAllTopicsInCluster$default$1());
    }

    @Override
    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.kafkaController().controllerContext().isTopicQueuedUpForDeletion(topic);
    }

    @Override
    public void ensureClusterLinkExists(Uuid linkId) {
        this.adminZkClient().ensureClusterLinkExists(linkId);
    }

    @Override
    public boolean clusterLinkExists(Uuid linkId) {
        return this.zkClient().clusterLinkExists(linkId);
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(Uuid linkId) {
        return this.adminZkClient().getClusterLink(linkId);
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        return this.adminZkClient().getAllClusterLinks().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithZkSupport.$anonfun$getClusterLinkData$1(linkName, x$3)));
    }

    @Override
    public Properties getClusterLinkConfigProps(Uuid linkId) {
        return this.adminZkClient().fetchClusterLinkConfig(linkId);
    }

    @Override
    public Properties getTopicConfig(String topic) {
        Option<LogConfig> logConfigOpt = this.replicaManager.getLogConfig(new TopicPartition(topic, 0));
        if (logConfigOpt.isDefined()) {
            LogConfig logConfig = (LogConfig)logConfigOpt.get();
            scala.collection.mutable.Map props = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(logConfig.originals()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithZkSupport.$anonfun$getTopicConfig$1(logConfig, x0$1)));
            Properties properties = new Properties();
            properties.putAll((java.util.Map<?, ?>)CollectionConverters$.MODULE$.MutableMapHasAsJava(props).asJava());
            return properties;
        }
        return this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
    }

    @Override
    public void alterClusterLinkConfigZNode(Uuid linkId, String linkName, Properties persistentProps, ClusterLinkConfig linkConfig) {
        this.adminZkClient().changeClusterLinkConfig(linkId, persistentProps);
        this.zkMetadataCollector.foreach((Function1 & Serializable)x$4 -> {
            x$4.onClusterLinkConfigChange(linkName, linkConfig);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        this.adminZkClient().maybeReencryptClusterLinkConfigs(configTransformer);
    }

    @Override
    public void createClusterLinkZNode(ClusterLinkData clusterLinkData, Properties props) {
        this.adminZkClient().createClusterLink(clusterLinkData, props);
        this.zkMetadataCollector.foreach((Function1 & Serializable)metadataCollector -> {
            ClusterLinkMetadataManagerWithZkSupport.$anonfun$createClusterLinkZNode$1(this, props, clusterLinkData, metadataCollector);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setClusterLinkZNode(ClusterLinkData clusterLinkData) {
        this.adminZkClient().setClusterLink(clusterLinkData);
    }

    @Override
    public void alterMirrorTopicState(String topic, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> stateUpdater, boolean validateOnly, boolean failIfNotMirror) {
        this.zkClient().alterMirrorTopicState(topic, stateUpdater, validateOnly, failIfNotMirror, this.zkClient().alterMirrorTopicState$default$5()).foreach((Function1 & Serializable)mirror -> {
            ClusterLinkMetadataManagerWithZkSupport.$anonfun$alterMirrorTopicState$1(this, topic, mirror);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    @Override
    public CompletableFuture<CreateClusterLinksResponse> createClusterLinks(CreateClusterLinksRequestData createClusterLinksRequestData) {
        throw new IllegalStateException("Not supported in Zk mode");
    }

    @Override
    public void deleteClusterLinkZNode(Uuid linkId) {
        String linkName = this.getClusterLinkData(linkId).isDefined() ? ((ClusterLinkData)this.getClusterLinkData(linkId).get()).linkName() : "";
        this.adminZkClient().deleteClusterLink(linkId);
        this.zkMetadataCollector.foreach((Function1 & Serializable)metadataCollector -> {
            metadataCollector.onClusterLinkDelete(linkName);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public scala.collection.immutable.Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return this.adminZkClient().getAllClusterLinks().toSeq();
    }

    @Override
    public KafkaFuture<Void> stopMirrorTopic(String topic, scala.collection.immutable.Seq<Object> logEndOffsets) {
        if (this.isLinkCoordinatorEnabled()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Sending a request to set the mirror topic ").append(topic).append(" state to STOPPED to controller").toString());
            return this.stopMirrorTopic(topic);
        }
        this.alterMirrorTopicState(topic, (Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>>)(Function1 & Serializable)currentState -> ClusterLinkMetadataManagerWithZkSupport.toPendingStopped$1(currentState, logEndOffsets, topic), false, this.alterMirrorTopicState$default$4());
        return KafkaFuture.completedFuture(null);
    }

    public KafkaFuture<Void> stopMirrorTopic(String topic) {
        AlterMirrorsRequest.Builder builder = new AlterMirrorsRequest.Builder(Collections.singletonList(new AlterMirrorsRequestData.MirrorOperation().setTopic(topic).setOperationCode(AlterMirrorOp.STOP.id())), false, this.requestTimeoutMs());
        KafkaFutureImpl result = new KafkaFutureImpl();
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, topic, result){
            private final String topic$3;
            private final KafkaFutureImpl result$1;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("Received response for alterMirrorsRequest"));
                }
                AlterMirrorsResponse message = (AlterMirrorsResponse)response;
                LinkedHashMap<String, KafkaFutureImpl> resultMap = new LinkedHashMap<String, KafkaFutureImpl>();
                resultMap.put(this.topic$3, this.result$1);
                message.complete(resultMap);
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("alterMirrors request failed with exception"), ex);
                }
                this.result$1.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$1() {
                return "Received response for alterMirrorsRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$1() {
                return "alterMirrors request failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$2(Throwable ex$1) {
                return ex$1;
            }
            {
                this.topic$3 = topic$3;
                this.result$1 = result$1;
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)builder, requestHandler);
        return result;
    }

    private ClusterLinkInfo getClusterLinkInfo(ClusterLinkData cld, ClusterLinkConfig config) {
        return new ClusterLinkInfo(cld.linkName(), cld.linkId(), config.linkMode(), config.connectionMode(), (String)cld.clusterId().getOrElse((Function0 & Serializable)() -> ""), (String)this.zkClient().getClusterId().getOrElse((Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStatesFromControllerContext$2(Uuid linkId$1, Tuple2 cl) {
        return ((ClusterLinkTopicState)cl._2()).linkId().equals((Object)linkId$1);
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStatesFromMetadataCache$1(Uuid linkId$2, Tuple2 x$1) {
        Uuid uuid = ((ClusterLinkTopicState)x$1._2()).linkId();
        return !(uuid != null ? !uuid.equals(linkId$2) : linkId$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStatesFromMetadataCache$3(Tuple2 x$2) {
        return x$2._2() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterLinkData$1(String linkName$1, ClusterLinkData x$3) {
        String string = x$3.linkName();
        return !(string != null ? !string.equals(linkName$1) : linkName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicConfig$1(LogConfig logConfig$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return logConfig$1.overriddenConfigs.contains(k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$createClusterLinkZNode$1(ClusterLinkMetadataManagerWithZkSupport $this, Properties props$1, ClusterLinkData clusterLinkData$1, ZKMetadataCollector metadataCollector) {
        ClusterLinkConfig config = ClusterLinkConfig$.MODULE$.create(props$1, (Option<KafkaConfig>)new Some((Object)$this.brokerConfig), false);
        ClusterLinkInfo clusterLinkInfo = $this.getClusterLinkInfo(clusterLinkData$1, config);
        metadataCollector.onClusterLinkCreate(clusterLinkInfo);
    }

    public static final /* synthetic */ void $anonfun$alterMirrorTopicState$1(ClusterLinkMetadataManagerWithZkSupport $this, String topic$1, ClusterLinkTopicState mirror) {
        if (mirror != null) {
            $this.zkMetadataCollector.foreach((Function1 & Serializable)x$5 -> {
                x$5.onMirrorTopicStateChange(topic$1, mirror.state().name());
                return BoxedUnit.UNIT;
            });
            return;
        }
        $this.zkMetadataCollector.foreach((Function1 & Serializable)x$6 -> {
            x$6.onMirrorTopicStateChange(topic$1, null);
            return BoxedUnit.UNIT;
        });
    }

    private static final Option toPendingStopped$1(ClusterLinkTopicState currentState, scala.collection.immutable.Seq logEndOffsets$1, String topic$2) {
        if (currentState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
            ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)currentState;
            String linkName = pendingStoppedMirror.linkName();
            Uuid linkId = pendingStoppedMirror.linkId();
            Uuid sourceTopicId = pendingStoppedMirror.sourceTopicId();
            return new Some((Object)new ClusterLinkTopicState.StoppedMirror(linkName, linkId, sourceTopicId, (Seq<Object>)logEndOffsets$1, Time.SYSTEM.milliseconds()));
        }
        if (currentState instanceof ClusterLinkTopicState.Mirror ? true : (currentState instanceof ClusterLinkTopicState.PausedMirror ? true : (currentState instanceof ClusterLinkTopicState.StoppedMirror ? true : currentState instanceof ClusterLinkTopicState.FailedMirror))) {
            throw new InvalidRequestException(new StringBuilder(57).append("Topic ").append(topic$2).append(" is not promoted/failed over. Cannot stop the topic").toString());
        }
        throw new IllegalStateException(new StringBuilder(37).append("Unknown mirror state for topic ").append(topic$2).append(" found").toString());
    }

    public ClusterLinkMetadataManagerWithZkSupport(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, ZkMetadataCache metadataCache, BrokerToControllerChannelManager controllerChannelManager, KafkaController kafkaController, KafkaZkClient zkClient, Function0<Admin> localAdminFactory, ReplicaManager replicaManager, AuthorizerServerInfo serverInfo, Option<ZKMetadataCollector> zkMetadataCollector) {
        this.brokerConfig = brokerConfig;
        this.kafkaController = kafkaController;
        this.zkClient = zkClient;
        this.replicaManager = replicaManager;
        this.zkMetadataCollector = zkMetadataCollector;
        super(brokerConfig, scheduler, metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
        this.adminZkClient = new AdminZkClient(zkClient);
    }
}

