/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.raft.SimpleRaftTracer;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.raft.KRaftSnapshotObjectUtils;
import kafka.tier.raft.LocalSnapshotObject;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.apache.kafka.snapshot.Snapshots;
import org.slf4j.Logger;

public final class KRaftSnapshotManager
implements SimpleRaftTracer {
    private final EventExecutor executor;
    private final TierObjectStore objectStore;
    private final Logger logger;
    private final Function<TopicIdPartition, Optional<Path>> topicIdPath;
    private final FaultHandler faultHandler;
    private final String clusterId;
    final Context context = new Context();

    private KRaftSnapshotManager(EventExecutor executor, TierObjectStore objectStore, LogContext logContext, Function<TopicIdPartition, Optional<Path>> topicIdPath, String clusterId) {
        this.executor = executor;
        this.objectStore = objectStore;
        this.logger = logContext.logger(this.getClass());
        this.topicIdPath = topicIdPath;
        this.faultHandler = new LoggingFaultHandler("raftSnapshotManager", () -> {});
        this.clusterId = clusterId;
        this.scheduleListRemoteObjects();
    }

    private void scheduleListRemoteObjects() {
        Callable<Void> callable = () -> {
            try {
                Map<KRaftSnapshotObject, List<VersionInformation>> objects = KRaftSnapshotObjectUtils.listObjects(this.objectStore, false, "");
                this.context.remoteListRetries = 0;
                this.context.remoteObjects = Optional.of(new TreeSet<KRaftSnapshotObject>(objects.keySet()));
                this.scheduleUploadLocalObjects();
            }
            catch (TierObjectStoreRetriableException e) {
                ++this.context.remoteListRetries;
                this.scheduleListRemoteObjects();
            }
            return null;
        };
        if (this.context.remoteListRetries == 0) {
            this.executor.submit(this.createEvent("ListRemoteObject", callable));
        } else {
            this.executor.schedule(this.createEvent("ListRemoteObject", callable), (long)Math.min(10, this.context.remoteListRetries), TimeUnit.SECONDS);
        }
    }

    private Optional<LocalSnapshotObject> nextPendingLocal() {
        return this.context.remoteObjects.flatMap(remoteObjects -> {
            this.context.localObjects.removeIf(object -> remoteObjects.contains(object.snapshotObject()));
            if (this.context.localObjects.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.context.localObjects.last());
        });
    }

    private void scheduleUploadLocalObjects() {
        if (!this.context.uploadScheduled && this.nextPendingLocal().isPresent()) {
            Callable<Void> callable = () -> {
                this.context.uploadScheduled = false;
                try {
                    Optional<LocalSnapshotObject> snapshotObject = this.nextPendingLocal();
                    if (!snapshotObject.isPresent()) {
                        return null;
                    }
                    LocalSnapshotObject localObject = snapshotObject.get();
                    Optional<Path> logDir = this.topicIdPath.apply(localObject.topicIdPartition());
                    if (!logDir.isPresent()) {
                        throw new FileNotFoundException("logDir could not be found for object: " + snapshotObject);
                    }
                    Path snapshotPath = Snapshots.snapshotPath((Path)logDir.get(), (OffsetAndEpoch)localObject.snapshotObject().snapshotId());
                    TierObjectStore.KRaftSnapshotMetadata snapshotMetadata = new TierObjectStore.KRaftSnapshotMetadata(localObject.snapshotObject());
                    KRaftSnapshotObjectUtils.putObject(this.objectStore, snapshotMetadata, snapshotPath.toFile());
                    this.context.remotePutRetries = 0;
                    this.context.remoteObjects.get().add(localObject.snapshotObject());
                    this.context.localObjects.remove(localObject);
                    this.scheduleUploadLocalObjects();
                }
                catch (TierObjectStoreRetriableException e) {
                    ++this.context.remotePutRetries;
                    this.scheduleUploadLocalObjects();
                }
                return null;
            };
            if (this.context.remotePutRetries == 0) {
                this.executor.submit(this.createEvent("PutRemoteObject", callable));
            } else {
                this.executor.schedule(this.createEvent("PutRemoteObject", callable), (long)Math.min(10, this.context.remotePutRetries), TimeUnit.SECONDS);
            }
            this.context.uploadScheduled = true;
        }
    }

    public void nodeStartedUp(TopicIdPartition tpId, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, SortedSet<OffsetAndEpoch> snapshotIds, OptionalInt leaderId, Set<Integer> currentVoters) {
        this.executor.submit(this.createEvent("ReplicaStarted", () -> {
            this.logger.info("replica for topic partition {} started with {}", (Object)tpId, (Object)snapshotIds);
            for (OffsetAndEpoch snapshot : snapshotIds) {
                this.context.localObjects.add(new LocalSnapshotObject(new KRaftSnapshotObject(tpId.topicId(), tpId.partition(), this.clusterId, nodeId.orElse(-1), 0L, snapshot), tpId));
            }
            this.scheduleUploadLocalObjects();
            return null;
        }));
    }

    public void snapshotGenerated(TopicIdPartition tpId, int epoch, OptionalInt nodeId, OptionalLong hwm, long logStartOffset, long logEndOffset, OffsetAndEpoch newSnapshotId, OptionalInt leaderId, Set<Integer> currentVoters) {
        this.executor.submit(this.createEvent("SnapshotGenerated", () -> {
            this.logger.info("topic partition {} generated a snapshot at {}", (Object)tpId, (Object)newSnapshotId);
            this.context.localObjects.add(new LocalSnapshotObject(new KRaftSnapshotObject(tpId.topicId(), tpId.partition(), this.clusterId, nodeId.orElse(-1), 0L, newSnapshotId), tpId));
            this.scheduleUploadLocalObjects();
            return null;
        }));
    }

    private Callable<Void> createEvent(String message, Callable<Void> callable) {
        return () -> {
            this.logger.info("handling: {}", (Object)message);
            try {
                return (Void)callable.call();
            }
            catch (Throwable e) {
                throw this.faultHandler.handleFault(message, e);
            }
        };
    }

    public static KRaftSnapshotManager create(EventExecutor executor, TierObjectStore objectStore, LogContext logContext, Function<TopicIdPartition, Optional<Path>> topicIdPath, String clusterId) {
        return new KRaftSnapshotManager(executor, objectStore, logContext, topicIdPath, clusterId);
    }

    static final class Context {
        int remoteListRetries = 0;
        Optional<SortedSet<KRaftSnapshotObject>> remoteObjects = Optional.empty();
        boolean uploadScheduled = false;
        int remotePutRetries = 0;
        final SortedSet<LocalSnapshotObject> localObjects = new TreeSet<LocalSnapshotObject>();

        Context() {
        }
    }
}

