/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.assignor.TenantPartitionAssignorBuilder;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.policy.AlterConfigPolicy;
import io.confluent.kafka.server.plugins.policy.CreateTopicPolicy;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig;
import kafka.server.QuotaType;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;

@Tag(value="integration")
public abstract class AbstractMultiTenantKafkaIntegrationTest {
    protected static final int BROKER_COUNT = 2;
    protected static final int MAX_PARTITIONS_PER_REQUEST_COUNT = 100;
    protected IntegrationTestHarness testHarness;
    protected LogicalCluster logicalCluster1;
    protected LogicalCluster logicalCluster2;
    protected LogicalCluster logicalCluster3;
    protected PhysicalCluster physicalCluster;
    protected Path tempDir;
    protected File logDir;
    private TestInfo testInfo;

    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        this.testInfo = testInfo;
        this.tempDir = TestUtils.tempDirectory().toPath();
        this.logDir = TestUtils.tempDirectory((Path)this.tempDir, null);
    }

    public void setUp() {
        this.setUp(2, Collections.emptyList());
    }

    public void setUp(int brokerCount, List<String> brokerRacks) {
        this.setUp(brokerCount, brokerRacks, Collections.emptyList());
    }

    public void setUp(int brokerCount, List<String> brokerRacks, List<String> brokerCells) {
        this.testHarness = new IntegrationTestHarness(this.testInfo, brokerCount, brokerRacks, brokerCells);
    }

    public boolean isKraft() {
        return this.physicalCluster.isKRaft();
    }

    protected void createPhysicalAndLogicalClusters() {
        this.createPhysicalAndLogicalClusters(this.nodeProps());
    }

    protected void createPhysicalAndLogicalClusters(Map<String, String> additionalProps) {
        Properties allProps = this.nodeProps();
        allProps.putAll(additionalProps);
        this.createPhysicalAndLogicalClusters(allProps);
    }

    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        this.physicalCluster = this.testHarness.start(brokerProperties, brokerProperties, true, Optional.empty(), cluster -> {});
        this.logicalCluster1 = this.physicalCluster.createLogicalCluster("lkc-tenant1", 100, 9, 11, 12);
        this.logicalCluster2 = this.physicalCluster.createLogicalCluster("lkc-tenant2", 200, 9, 21, 22);
        this.logicalCluster3 = this.physicalCluster.createLogicalCluster("lkc-tenant3", 300, 9, 31, 32);
    }

    @AfterEach
    public void tearDown() {
        this.testHarness.shutdown();
    }

    protected Properties nodeProps() {
        Properties props = new Properties();
        props.put(KafkaConfig.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.max.acls.per.tenant", "100");
        props.put(AclAuthorizer.AllowEveryoneIfNoAclIsFoundProp(), "true");
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put("confluent.topic.replica.assignor.builder.class", TenantPartitionAssignorBuilder.class.getName());
        try {
            props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put(KafkaConfig.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class.getName());
        props.put(KafkaConfig.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class.getName());
        props.put("confluent.plugins.topic.policy.replication.factor", "1");
        props.put("confluent.multitenant.max.partitions.per.request", Integer.toString(100));
        props.put(KafkaConfig.AutoCreateTopicsEnableProp(), "false");
        props.put("confluent.broker.load.enabled", "true");
        props.put("confluent.broker.load.delay.metric.start.ms", "0");
        props.put("confluent.broker.load.update.metric.tags.interval.ms", "100");
        props.put("confluent.broker.load.window.size.ms", "100");
        props.put("confluent.apply.create.topic.policy.to.create.partitions", "true");
        props.put(KafkaConfig.LogDirProp(), this.logDir.getAbsolutePath());
        return props;
    }

    protected void awaitMetadataPropagation() {
        int numberOfBrokers = this.physicalCluster.kafkaCluster().kafkaBrokers().size();
        try {
            TestUtils.waitForCondition(() -> ((Collection)this.physicalCluster.superAdminClient().describeCluster().nodes().get()).size() == numberOfBrokers, (String)String.format("Metadata was not updated in time to reflect the %d brokers", numberOfBrokers));
            if (!this.isKraft()) {
                TestUtils.waitForCondition(() -> this.physicalCluster.kafkaCluster().controllerBrokerServer().adminManager().metadataCache().getAliveBrokers().size() == numberOfBrokers, (String)String.format("Metadata was not updated in time to reflect the %d brokers", numberOfBrokers));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void addLkcFileAndSyncMetadata(KafkaLogicalClusterMetadata lcm) throws Throwable {
        Utils.createLogicalClusterFile(lcm, this.tempDir);
        TestUtils.waitForCondition(() -> this.physicalCluster.kafkaCluster().kafkaBrokers().stream().allMatch(broker -> {
            PhysicalClusterMetadata physicalClustermetadata = (PhysicalClusterMetadata)broker.multiTenantMetadata().get();
            return physicalClustermetadata.metadata(lcm.logicalClusterId()) != null;
        }), (String)"Expected metadata of new logical cluster to be present in metadata cache");
    }

    protected void deleteLkcFileAndSyncMetadata(KafkaLogicalClusterMetadata lcm) throws Throwable {
        Utils.deleteLogicalClusterFile(lcm, this.tempDir);
        TestUtils.waitForCondition(() -> this.physicalCluster.kafkaCluster().kafkaBrokers().stream().allMatch(broker -> {
            PhysicalClusterMetadata physicalClustermetadata = (PhysicalClusterMetadata)broker.multiTenantMetadata().get();
            return physicalClustermetadata.metadata(lcm.logicalClusterId()) == null;
        }), (String)"Expected metadata of deleted logical cluster to not be present in metadata cache");
    }

    protected Set<AclBinding> describeAllAcls(AdminClient adminClient) throws Exception {
        Collection acls = (Collection)adminClient.describeAcls(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY))).values().get();
        return new HashSet<AclBinding>(acls);
    }

    protected void verifyQuotaCallbackLimit(ClientQuotaType quotaType, Map<String, String> tags, double expectedQuota) throws Exception {
        List quotaCallbacks = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (ClientQuotaCallback)kafkaServer.quotaManagers().clientQuotaCallback().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> quotaCallbacks.stream().allMatch(callback -> callback.quotaLimit(quotaType, tags) == expectedQuota), (String)String.format("Timed out waiting for quota callback to update quota %s for tenant %s to %s", quotaType, tags, expectedQuota));
    }

    protected void verifyQuota(ClientQuotaType quotaType, Map<String, String> tags, double expectedQuota) {
        this.verifyQuota(quotaType, tags, bound -> bound == expectedQuota);
    }

    protected void verifyQuota(ClientQuotaType quotaType, Map<String, String> tags, Predicate<Double> quotaPredicate) {
        Predicate<Map<Integer, KafkaMetric>> predicate = metricsByNodeId -> metricsByNodeId.values().stream().anyMatch(metric -> metric != null && quotaPredicate.test(metric.config().quota().bound()));
        String failureMessage = String.format("Timed out waiting for expected quota %s with tags %s to update", quotaType, tags);
        this.verifyQuotaMetric("tokens", quotaType, tags, predicate, failureMessage);
    }

    protected void verifyThrottle(ClientQuotaType quotaType, Map<String, String> tags, boolean expectThrottle) {
        Predicate<KafkaMetric> isThrottled = metric -> metric != null && (Double)metric.metricValue() > 0.0;
        Predicate<Map<Integer, KafkaMetric>> predicate = metricsByNodeId -> {
            if (expectThrottle) {
                return metricsByNodeId.values().stream().anyMatch(isThrottled);
            }
            return metricsByNodeId.values().stream().noneMatch(isThrottled);
        };
        String failureMessage = String.format("Timed out waiting for %s tenant throttle metric with tags %s to be %s", quotaType, tags, expectThrottle ? "non-zero" : "zero");
        this.verifyQuotaMetric("throttle-time", quotaType, tags, predicate, failureMessage);
    }

    protected void verifyCount(ClientQuotaType quotaType, Map<String, String> tags, double expectedCount) {
        Predicate<KafkaMetric> expected = metric -> metric != null && (Double)metric.metricValue() == expectedCount;
        Predicate<Map<Integer, KafkaMetric>> predicate = metricsByNodeId -> metricsByNodeId.values().stream().anyMatch(expected);
        String failureMessage = String.format("Timed out waiting for %s count metric with tags %s to be %s", quotaType, tags, expectedCount);
        this.verifyQuotaMetric("count", quotaType, tags, predicate, failureMessage);
    }

    private void verifyQuotaMetric(String name, ClientQuotaType quotaType, Map<String, String> tags, Predicate<Map<Integer, KafkaMetric>> predicate, String failureMessage) {
        try {
            Map<Integer, Metrics> metricsByNodeId;
            if (quotaType == ClientQuotaType.CONTROLLER_MUTATION) {
                ControllerServer controllerServer;
                if (this.isKraft()) {
                    controllerServer = this.physicalCluster.kafkaCluster().kraftController();
                    metricsByNodeId = Collections.singletonMap(controllerServer.config().nodeId(), controllerServer.metrics());
                } else {
                    controllerServer = this.physicalCluster.kafkaCluster().controllerBrokerServer();
                    metricsByNodeId = Collections.singletonMap(controllerServer.config().brokerId(), controllerServer.metrics());
                }
            } else {
                metricsByNodeId = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().collect(Collectors.toMap(broker -> broker.config().brokerId(), broker -> broker.metrics()));
            }
            TestCondition condition = () -> predicate.test(metricsByNodeId.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> this.quotaMetric((Metrics)entry.getValue(), name, quotaType, tags))));
            TestUtils.waitForCondition((TestCondition)condition, (String)failureMessage);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Test was interrupted while waiting for quota metric");
        }
    }

    protected KafkaMetric quotaMetric(Metrics metrics, String name, ClientQuotaType quotaType, Map<String, String> tags) {
        return metrics.metric(metrics.metricName(name, QuotaType.fromClientQuotaType((ClientQuotaType)quotaType).toString(), tags));
    }
}

