/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import kafka.metrics.BrokerWithMember;
import kafka.metrics.ConsumerLagEmitter;
import kafka.metrics.ConsumerLagEmitterIntegrationTest;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class MultiTenantConsumerLagEmitterIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private List<KafkaProducer<String, String>> producers = null;
    private List<KafkaConsumer<String, String>> consumers = null;
    private final SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
    private final String groupId = "test-group";
    private final String topic = "test-topic";

    @Override
    protected Properties nodeProps() {
        Properties props = super.nodeProps();
        props.put("confluent.consumer.lag.emitter.enabled", "true");
        props.put("confluent.consumer.lag.emitter.interval.ms", "1000");
        return props;
    }

    @Override
    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        super.setUpTempDir(testInfo);
        this.producers = new ArrayList<KafkaProducer<String, String>>(2);
        this.consumers = new ArrayList<KafkaConsumer<String, String>>(2);
    }

    @AfterEach
    void shutdown() {
        this.producers.forEach(KafkaProducer::close);
        this.consumers.forEach(KafkaConsumer::close);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMultiTenantConsumerLagMetrics(String quorum) throws Throwable {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        LogicalClusterUser user1 = this.logicalCluster1.user(11);
        LogicalClusterUser user2 = this.logicalCluster2.user(21);
        this.producers.add(this.testHarness.createProducer(user1, this.securityProtocol));
        this.producers.add(this.testHarness.createProducer(user2, this.securityProtocol));
        this.consumers.add(this.testHarness.createConsumer(user1, "test-group", this.securityProtocol));
        this.consumers.add(this.testHarness.createConsumer(user2, "test-group", this.securityProtocol));
        String prefixedTopic1 = user1.tenantPrefix() + "test-topic";
        String prefixedTopic2 = user2.tenantPrefix() + "test-topic";
        this.physicalCluster.kafkaCluster().createTopic(prefixedTopic1, 1, 1);
        this.physicalCluster.kafkaCluster().createTopic(prefixedTopic2, 1, 1);
        int firstMessageIndex = 0;
        KafkaTestUtils.sendRecords(this.producers.get(0), "test-topic", firstMessageIndex, 100);
        KafkaTestUtils.sendRecords(this.producers.get(1), "test-topic", firstMessageIndex, 200);
        KafkaTestUtils.consumeRecords(this.consumers.get(0), "test-topic", firstMessageIndex, 100);
        KafkaTestUtils.consumeRecords(this.consumers.get(1), "test-topic", firstMessageIndex, 200);
        this.consumers.forEach(KafkaConsumer::commitSync);
        BrokerWithMember serverWithMember1 = ConsumerLagEmitterIntegrationTest.findBrokerWithMember(this.physicalCluster.kafkaCluster().kafkaBrokers(), (String)(user1.tenantPrefix() + "test-group"));
        BrokerWithMember serverWithMember2 = ConsumerLagEmitterIntegrationTest.findBrokerWithMember(this.physicalCluster.kafkaCluster().kafkaBrokers(), (String)(user2.tenantPrefix() + "test-group"));
        this.assertConsumerLag(serverWithMember1, user1, 0L);
        this.assertConsumerLag(serverWithMember2, user2, 0L);
        KafkaTestUtils.sendRecords(this.producers.get(0), "test-topic", 100, 400);
        KafkaTestUtils.sendRecords(this.producers.get(1), "test-topic", 200, 500);
        this.assertConsumerLag(serverWithMember1, user1, 400L);
        this.assertConsumerLag(serverWithMember2, user2, 500L);
        this.assertConsumerLagEmitterLatency(serverWithMember1);
        KafkaTestUtils.consumeRecords(this.consumers.get(0), "test-topic", 100, 400);
        KafkaTestUtils.consumeRecords(this.consumers.get(1), "test-topic", 200, 500);
        this.consumers.forEach(KafkaConsumer::commitSync);
        this.assertConsumerLag(serverWithMember1, user1, 0L);
        this.assertConsumerLag(serverWithMember2, user2, 0L);
        this.assertConsumerLagEmitterLatency(serverWithMember1);
        this.assertConsumerLagEmitterLatency(serverWithMember2);
    }

    private void assertConsumerLag(BrokerWithMember serverWithMember, LogicalClusterUser user, long expectedLag) throws InterruptedException {
        TestUtils.waitForCondition(() -> this.verifyConsumerLagMetrics(serverWithMember, user, expectedLag), (String)String.format("consumer lag should be %d", expectedLag));
    }

    private void assertConsumerLagEmitterLatency(BrokerWithMember serverWithMember) throws InterruptedException {
        TestUtils.waitForCondition(() -> this.verifyConsumerLagEmitterLatency(serverWithMember), (String)String.format("consumer lag emitter run should take 0 - 1 seconds.", new Object[0]));
        Assertions.assertTrue((boolean)this.verifyConsumerLagEmitterTimeSinceLastSuccessfulRun(serverWithMember));
    }

    private boolean verifyConsumerLagMetrics(BrokerWithMember serverWithMember, LogicalClusterUser user, Long expectedLag) {
        DescribeGroupsResponseData.DescribedGroupMember member = serverWithMember.member();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tenant", user.logicalClusterId);
        tags.put("consumer-group", "test-group");
        tags.put("member", member.memberId());
        tags.put("client-id", member.clientId());
        tags.put("topic", "test-topic");
        tags.put("partition", "0");
        Metrics metrics = serverWithMember.broker().metrics();
        KafkaMetric kafkaMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName(ConsumerLagEmitter.ConsumerLagMetricName(), "tenant-metrics", tags));
        if (kafkaMetric == null) {
            return false;
        }
        return expectedLag.equals(kafkaMetric.metricValue());
    }

    private boolean verifyConsumerLagEmitterLatency(BrokerWithMember serverWithMember) {
        Metrics metrics = serverWithMember.broker().metrics();
        KafkaMetric kafkaMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName(ConsumerLagEmitter.ExecutionTimeMetricName(), ConsumerLagEmitter.MetricGroupName()));
        if (kafkaMetric == null) {
            return false;
        }
        return this.isMetricValueInRange(kafkaMetric);
    }

    private boolean verifyConsumerLagEmitterTimeSinceLastSuccessfulRun(BrokerWithMember serverWithMember) {
        Metrics metrics = serverWithMember.broker().metrics();
        KafkaMetric kafkaMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName(ConsumerLagEmitter.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter.MetricGroupName()));
        if (kafkaMetric == null) {
            return false;
        }
        return this.isMetricValueInRange(kafkaMetric);
    }

    private boolean isMetricValueInRange(KafkaMetric kafkaMetric) {
        return (Long)kafkaMetric.metricValue() >= 0L && (Long)kafkaMetric.metricValue() < 1000L;
    }
}

