/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authenticator;

import io.confluent.kafka.security.authenticator.OAuthKafkaPrincipalBuilder;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OAuthKafkaPrincipalBuilderTest {
    @Test
    public void testPrincipalBuilderOAuthBearer() throws Exception {
        OAuthBearerToken token = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"alice");
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)token);
        Mockito.when((Object)token.principalName()).thenReturn((Object)"alice");
        String tokenValue = this.createUnsecuredJws("Confluent", "alice", "g1", "g2").value();
        Mockito.when((Object)token.value()).thenReturn((Object)tokenValue);
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext((SaslServer)server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assertions.assertTrue((boolean)(principal instanceof ConfluentPrincipal));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)principal).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)principal).getGroups().containsAll(Arrays.asList("g1", "g2")));
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.never())).getAuthorizationID();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.never())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    @Test
    public void testOAuthKafkaPrincipalBuilderSerde_ConfluentPrincipal() {
        ConfluentPrincipal p = new ConfluentPrincipal("User", "Alice", "Alice", Optional.empty(), false, new HashSet<String>(Arrays.asList("g1", "g2")));
        OAuthKafkaPrincipalBuilder cpBuilder = new OAuthKafkaPrincipalBuilder();
        KafkaPrincipal copy = cpBuilder.deserialize(cpBuilder.serialize((KafkaPrincipal)p));
        Assertions.assertEquals((Object)p, (Object)copy);
        Assertions.assertTrue((boolean)(copy instanceof ConfluentPrincipal));
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)copy).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)copy).getGroups().containsAll(new HashSet<String>(Arrays.asList("g1", "g2"))));
    }

    @Test
    public void testOAuthKafkaPrincipalBuilderSerde_KafkaPrincipal() {
        KafkaPrincipal p = new KafkaPrincipal("User", "user");
        OAuthKafkaPrincipalBuilder cpBuilder = new OAuthKafkaPrincipalBuilder();
        cpBuilder.configure(Collections.emptyMap());
        KafkaPrincipal copy = cpBuilder.deserialize(cpBuilder.serialize(p));
        Assertions.assertEquals((Object)p, (Object)copy);
    }

    @Test
    public void testDefaultKafkaPrincipalBuilderSerde_ConfluentPrincipal() {
        ConfluentPrincipal p = new ConfluentPrincipal("User", "Alice", "Alice", Optional.empty(), false, new HashSet<String>(Arrays.asList("g1", "g2")));
        DefaultKafkaPrincipalBuilder defaultBuilder = new DefaultKafkaPrincipalBuilder(null, null);
        KafkaPrincipal copy = defaultBuilder.deserialize(defaultBuilder.serialize((KafkaPrincipal)p));
        Assertions.assertEquals(KafkaPrincipal.class, copy.getClass());
        Assertions.assertEquals((Object)p.getPrincipalType(), (Object)copy.getPrincipalType());
        Assertions.assertEquals((Object)p.getName(), (Object)copy.getName());
        Assertions.assertEquals((Object)p.tokenAuthenticated(), (Object)copy.tokenAuthenticated());
    }

    @Test
    public void testOAuthKafkaPrincipalBuilderSerde_KafkaPrincipalCompatibility() {
        KafkaPrincipal p = new KafkaPrincipal("User", "user");
        DefaultKafkaPrincipalBuilder defaultSerializer = new DefaultKafkaPrincipalBuilder(null, null);
        OAuthKafkaPrincipalBuilder cpDeserializer = new OAuthKafkaPrincipalBuilder();
        cpDeserializer.configure(Collections.emptyMap());
        KafkaPrincipal copy = cpDeserializer.deserialize(defaultSerializer.serialize(p));
        Assertions.assertEquals((Object)p, (Object)copy);
        Assertions.assertEquals(KafkaPrincipal.class, copy.getClass());
    }

    @Test
    public void testOAuthKafkaPrincipalBuilderSerde_KafkaPrincipalBuilderCompatibility() {
        ConfluentPrincipal p = new ConfluentPrincipal("User", "Alice", "Alice", Optional.empty(), false, new HashSet<String>(Arrays.asList("g1", "g2")));
        OAuthKafkaPrincipalBuilder cpSerializer = new OAuthKafkaPrincipalBuilder();
        DefaultKafkaPrincipalBuilder defaultDeserializer = new DefaultKafkaPrincipalBuilder(null, null);
        KafkaPrincipal copy = defaultDeserializer.deserialize(cpSerializer.serialize((KafkaPrincipal)p));
        Assertions.assertEquals(KafkaPrincipal.class, copy.getClass());
        Assertions.assertEquals((Object)p.getPrincipalType(), (Object)copy.getPrincipalType());
        Assertions.assertEquals((Object)p.getName(), (Object)copy.getName());
        Assertions.assertEquals((Object)p.tokenAuthenticated(), (Object)copy.tokenAuthenticated());
    }

    @Test
    public void testConfluentPrincipalBuilderWithSslPrincipalMapper() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new X500Principal("CN=Duke, OU=ServiceUsers, O=Org, C=US")).thenReturn((Object)new X500Principal("CN=Duke, OU=SME, O=mycp, L=Fulton, ST=MD, C=US")).thenReturn((Object)new X500Principal("CN=duke, OU=JavaSoft, O=Sun Microsystems")).thenReturn((Object)new X500Principal("OU=JavaSoft, O=Sun Microsystems, C=US"));
        String rules = String.join((CharSequence)", ", "RULE:^CN=(.*),OU=ServiceUsers.*$/$1/L", "RULE:^CN=(.*),OU=(.*),O=(.*),L=(.*),ST=(.*),C=(.*)$/$1@$2/L", "RULE:^.*[Cc][Nn]=([a-zA-Z0-9.]*).*$/$1/U", "DEFAULT");
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        builder.configure(Collections.singletonMap("ssl.principal.mapping.rules", rules));
        SslAuthenticationContext sslContext = new SslAuthenticationContext(session, InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name());
        KafkaPrincipal principal = builder.build((AuthenticationContext)sslContext);
        Assertions.assertEquals((Object)"duke", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assertions.assertEquals((Object)"duke@sme", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assertions.assertEquals((Object)"DUKE", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assertions.assertEquals((Object)"OU=JavaSoft,O=Sun Microsystems,C=US", (Object)principal.getName());
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)4))).getPeerPrincipal();
    }

    @Test
    public void testConfluentPrincipalBuilderGssapi() throws Exception {
        SaslServer server = (SaslServer)Mockito.mock(SaslServer.class);
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"GSSAPI");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"foo/host@REALM.COM");
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        builder.configure(Collections.singletonMap("sasl.kerberos.principal.to.local.rules", Collections.singletonList("RULE:[2:$1]")));
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext(server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)"foo", (Object)principal.getName());
        ((SaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((SaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getAuthorizationID();
    }

    private OAuthBearerUnsecuredJws createUnsecuredJws(String issuer, String subject, String ... groups) {
        Base64.Encoder urlEncoderNoPadding = Base64.getUrlEncoder().withoutPadding();
        long tokenExp = System.currentTimeMillis() / 1000L + 50000L;
        String header = "{\"alg\":\"none\",\"typ\":\"JWT\"}";
        String payload = String.format("{\"iss\":\"%s\",\"sub\":\"%s\",\"groups\":[%s],\"exp\":%d}", issuer, subject, Arrays.stream(groups).map(g -> "\"" + g + "\"").collect(Collectors.joining(",")), tokenExp);
        return new OAuthBearerUnsecuredJws(String.format("%s.%s.%s", urlEncoderNoPadding.encodeToString(header.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString(payload.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString("".getBytes(StandardCharsets.UTF_8))), "sub", "scope");
    }
}

