/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class ComputeEvenClusterLoadPlanResponse
extends AbstractResponse {
    private final ComputeEvenClusterLoadPlanResponseData data;

    public ComputeEvenClusterLoadPlanResponse(ComputeEvenClusterLoadPlanResponseData data) {
        super(ApiKeys.COMPUTE_EVEN_CLUSTER_LOAD_PLAN);
        this.data = data;
    }

    @Override
    public ComputeEvenClusterLoadPlanResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short apiVersion) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static ComputeEvenClusterLoadPlanResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ComputeEvenClusterLoadPlanResponse(new ComputeEvenClusterLoadPlanResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

