/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.local;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.AesGcmKey;
import com.google.crypto.tink.subtle.Hkdf;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Locale;
import javax.annotation.Nullable;

public final class LocalKmsClient
implements KmsClient {
    public static final String PREFIX = "local-kms://";
    private static final String AES_GCM_KEY = "type.googleapis.com/google.crypto.tink.AesGcmKey";
    @Nullable
    private String keyUri;
    private Aead aead;

    private LocalKmsClient() {
    }

    public LocalKmsClient(String uri, String secret) throws GeneralSecurityException {
        if (!uri.toLowerCase(Locale.US).startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must start with local-kms://");
        }
        this.keyUri = uri;
        this.aead = this.getPrimitive(secret);
    }

    private Aead getPrimitive(String secret) throws GeneralSecurityException {
        byte[] keyBytes = Hkdf.computeHkdf((String)"HmacSha256", (byte[])secret.getBytes(StandardCharsets.UTF_8), null, null, (int)16);
        AesGcmKey key = AesGcmKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])keyBytes)).build();
        return (Aead)Registry.getPrimitive((String)AES_GCM_KEY, (ByteString)key.toByteString(), Aead.class);
    }

    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase(Locale.US).startsWith(PREFIX);
    }

    @CanIgnoreReturnValue
    public KmsClient withCredentials(String credentialPath) throws GeneralSecurityException {
        return this;
    }

    @CanIgnoreReturnValue
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        return this;
    }

    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        return this.aead;
    }
}

