/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.traffic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.kafka.traffic.TopicBasedTrafficNetworkIdRoutesStore;
import io.confluent.kafka.traffic.TrafficNetworkIdAllowedRoutes;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.BrokerSession;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TopicBasedTrafficNetworkIdRoutesStoreTest {
    private static final String TOPIC = "_confluent-network_id_routes";
    private String sessionUuid;
    private static final String CLUSTER_NETWORK_ID = "ne-uuid";
    private static final String PKC_ID = "pkc-uuid";
    private ObjectMapper objectMapper;
    private TopicBasedTrafficNetworkIdRoutesStore store;
    private KafkaBasedLog<String, String> kafkaBasedLog;
    private MetadataCache metadataCache;
    private Set<String> disallowedNetworks;

    @BeforeEach
    public void setUp() throws Exception {
        this.disallowedNetworks = new HashSet<String>();
        this.sessionUuid = UUID.randomUUID().toString();
        this.objectMapper = new ObjectMapper();
        this.kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        this.metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)this.metadataCache.contains(TOPIC)).thenReturn((Object)true);
        this.store = this.createAndStartStoreWithMockLog(this.sessionUuid, new HashMap(), new Metrics(), (Time)new MockTime(), this.kafkaBasedLog);
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)config.brokerSessionUuid()).thenReturn((Object)this.sessionUuid);
        Mockito.when((Object)config.closeConnectionsOnCredentialDelete()).thenReturn((Object)true);
        BrokerSession.addSession((KafkaConfig)config, publicCredential -> this.disallowedNetworks.add((String)publicCredential.networkId().get()));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.closeStore(this.store);
        BrokerSession.closeSession((String)this.sessionUuid);
    }

    @Test
    public void testStoreStartWaitsForTopicCreation() throws InterruptedException {
        AtomicInteger topicCreatedCallCount = new AtomicInteger(0);
        AtomicBoolean topicCreated = new AtomicBoolean(false);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)metadataCache.contains(TOPIC)).thenAnswer(invocation -> {
            topicCreatedCallCount.incrementAndGet();
            return topicCreated.get();
        });
        MockTime time = new MockTime();
        KafkaBasedLog kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        try (TopicBasedTrafficNetworkIdRoutesStore store = this.createStoreWithMockLog(metadataCache, UUID.randomUUID().toString(), new HashMap(), new Metrics(), (Time)time, (KafkaBasedLog<String, String>)kafkaBasedLog, 10L);){
            Endpoint endpoint = new Endpoint("EXTERNAL_BACKCHANNEL", SecurityProtocol.PLAINTEXT, "localhost", 9092);
            Map futures = store.start(Collections.singletonList(endpoint));
            futures.values().forEach(f -> {
                Void cfr_ignored_0 = (Void)f.join();
            });
            Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.STARTING, store.state.get());
            TestUtils.waitUntilTrue(() -> topicCreatedCallCount.get() > 5, () -> "periodic task isn't checking for topic creation.", (long)15000L, (long)100L);
            topicCreated.set(true);
            TestUtils.waitUntilTrue(() -> store.state.get() == TopicBasedTrafficNetworkIdRoutesStore.State.RUNNING, () -> "store never made it to RUNNING state.", (long)15000L, (long)100L);
            Assertions.assertTrue((boolean)store.storeStartTaskFuture.isCancelled());
        }
    }

    @Test
    public void testNonRoutesListenersDoNotWaitForStoreStart() {
        CountDownLatch latch = new CountDownLatch(1);
        Map<Endpoint, CompletableFuture<Void>> futures = this.startStoreWithDelayedLogStartup(latch, "EXTERNAL");
        futures.values().forEach(f -> Assertions.assertTrue((boolean)f.isDone()));
        latch.countDown();
    }

    @Test
    public void testOnlyRoutesListenersWaitForStoreStart() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Map<Endpoint, CompletableFuture<Void>> futures = this.startStoreWithDelayedLogStartup(latch, "EXTERNAL_BACKCHANNEL");
        futures.values().forEach(f -> Assertions.assertFalse((boolean)f.isDone()));
        latch.countDown();
        for (CompletableFuture<Void> future : futures.values()) {
            future.get(15000L, TimeUnit.MILLISECONDS);
        }
    }

    private Map<Endpoint, CompletableFuture<Void>> startStoreWithDelayedLogStartup(CountDownLatch latch, String listenerName) {
        KafkaBasedLog kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        ((KafkaBasedLog)Mockito.doAnswer(invocation -> {
            latch.await();
            return null;
        }).when((Object)kafkaBasedLog)).start();
        TopicBasedTrafficNetworkIdRoutesStore store = this.createStoreWithMockLog(this.metadataCache, UUID.randomUUID().toString(), new HashMap(), new Metrics(), (Time)new MockTime(), (KafkaBasedLog<String, String>)kafkaBasedLog);
        Endpoint externalEndpoint = new Endpoint(listenerName, SecurityProtocol.PLAINTEXT, "localhost", 9092);
        Map futures = store.start(Collections.singletonList(externalEndpoint));
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.STARTING, store.state.get());
        return futures;
    }

    @Test
    public void testDisabledInConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        HashMap interBrokerClientConfig = new HashMap();
        String sessionUuid = UUID.randomUUID().toString();
        configs.put(KafkaConfig.BrokerSessionUuidProp(), sessionUuid);
        configs.put("confluent.traffic.cdc.network.id.routes.enable", new Boolean(false));
        TopicBasedTrafficNetworkIdRoutesStore store = new TopicBasedTrafficNetworkIdRoutesStore(this.metadataCache, interBrokerClientConfig, new Metrics(), (Time)new MockTime());
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.NOT_STARTED, store.state.get());
        Assertions.assertNull((Object)store.load());
        store.configure(configs);
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.NOT_ENABLED, store.state.get());
        Assertions.assertNull((Object)store.load());
        store.close();
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.NOT_ENABLED, store.state.get());
        Assertions.assertNull((Object)store.load());
        configs.put("confluent.traffic.cdc.network.id.routes.enable", null);
        store = new TopicBasedTrafficNetworkIdRoutesStore(this.metadataCache, interBrokerClientConfig, new Metrics(), (Time)new MockTime());
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.NOT_STARTED, store.state.get());
        Assertions.assertNull((Object)store.load());
        store.configure(configs);
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.NOT_ENABLED, store.state.get());
        Assertions.assertNull((Object)store.load());
        store.close();
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.NOT_ENABLED, store.state.get());
        Assertions.assertNull((Object)store.load());
    }

    private TopicBasedTrafficNetworkIdRoutesStore createAndStartStoreWithMockLog(String sessionUuid, Map<String, ?> interBrokerClientConfig, Metrics metrics, Time time, KafkaBasedLog<String, String> kafkaBasedLog) {
        TopicBasedTrafficNetworkIdRoutesStore store = this.createStoreWithMockLog(this.metadataCache, sessionUuid, interBrokerClientConfig, metrics, time, kafkaBasedLog);
        Endpoint endpoint = new Endpoint("EXTERNAL_BACKCHANNEL", SecurityProtocol.PLAINTEXT, "localhost", 9092);
        store.start(Collections.singletonList(endpoint)).values().forEach(f -> {
            Void cfr_ignored_0 = (Void)f.join();
        });
        return store;
    }

    private TopicBasedTrafficNetworkIdRoutesStore createStoreWithMockLog(MetadataCache metadataCache, String sessionUuid, Map<String, ?> interBrokerClientConfig, Metrics metrics, Time time, KafkaBasedLog<String, String> kafkaBasedLog) {
        return this.createStoreWithMockLog(metadataCache, sessionUuid, interBrokerClientConfig, metrics, time, kafkaBasedLog, TimeUnit.MINUTES.toMillis(5L));
    }

    private TopicBasedTrafficNetworkIdRoutesStore createStoreWithMockLog(MetadataCache metadataCache, String sessionUuid, Map<String, ?> interBrokerClientConfig, Metrics metrics, Time time, KafkaBasedLog<String, String> kafkaBasedLog, long periodicStartTaskMs) {
        TopicBasedTrafficNetworkIdRoutesStore store = new TopicBasedTrafficNetworkIdRoutesStore(metadataCache, interBrokerClientConfig, metrics, time);
        store.configureInternal(kafkaBasedLog, sessionUuid, CLUSTER_NETWORK_ID, TOPIC, Collections.singletonList("EXTERNAL_BACKCHANNEL"), periodicStartTaskMs);
        return store;
    }

    private void closeStore(TopicBasedTrafficNetworkIdRoutesStore store) {
        store.close();
        ((KafkaBasedLog)Mockito.verify(this.kafkaBasedLog, (VerificationMode)Mockito.times((int)1))).stop();
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.CLOSED, store.state.get());
    }

    private String encodeValue(List<String> allowedNetworkIds) throws IOException {
        return this.encodeValue(new TrafficNetworkIdAllowedRoutes(allowedNetworkIds));
    }

    private String encodeValue(TrafficNetworkIdAllowedRoutes routes) throws IOException {
        StringWriter writer = new StringWriter();
        this.objectMapper.writeValue((Writer)writer, (Object)routes);
        return writer.toString();
    }

    private String encodeValueWithExtraFields(List<String> allowedNetworkIds) throws IOException {
        return this.encodeValue(new TestTrafficNetworkIdAllowedRoutes(allowedNetworkIds));
    }

    private ConsumerRecord<String, String> createRecord(long seqId, String key, String value) {
        RecordHeaders headers = KafkaTestUtils.createGoodSequenceIdRecordHeaders(seqId, false);
        return new ConsumerRecord(TOPIC, 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)key, (Object)value, (Headers)headers, Optional.empty());
    }

    @Test
    public void testMultipleStarts() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.store.start(Collections.emptyList()), (String)"Starting the store twice should throw");
    }

    @Test
    public void testFailedStartWillCloseResources() {
        HashMap interBrokerClientConfig = new HashMap();
        KafkaBasedLog kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        ((KafkaBasedLog)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("unknown exception during startup")}).when((Object)kafkaBasedLog)).start();
        TopicBasedTrafficNetworkIdRoutesStore store = this.createStoreWithMockLog(this.metadataCache, UUID.randomUUID().toString(), interBrokerClientConfig, new Metrics(), (Time)new MockTime(), (KafkaBasedLog<String, String>)kafkaBasedLog);
        Endpoint endpoint = new Endpoint("EXTERNAL_BACKCHANNEL", SecurityProtocol.PLAINTEXT, "localhost", 9092);
        Assertions.assertThrows(Exception.class, () -> store.start(Collections.singletonList(endpoint)).values().forEach(f -> {
            Void cfr_ignored_0 = (Void)f.join();
        }));
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.FAILED_TO_START, store.state.get());
        store.close();
        ((KafkaBasedLog)Mockito.verify((Object)kafkaBasedLog, (VerificationMode)Mockito.times((int)1))).stop();
        Assertions.assertEquals((Object)TopicBasedTrafficNetworkIdRoutesStore.State.FAILED_TO_START, store.state.get());
    }

    @Test
    public void testIgnoreBadMessages() throws IOException {
        Assertions.assertNull(this.store.routes.get());
        Assertions.assertNull((Object)this.store.getLastSeenSequenceId());
        List<String> allowedNetworkIds = Arrays.asList("ne1", "ne2");
        ConsumerRecord noHeaders = new ConsumerRecord(TOPIC, 0, 0L, (Object)CLUSTER_NETWORK_ID, (Object)this.encodeValue(allowedNetworkIds));
        this.store.consume(noHeaders);
        Assertions.assertNull(this.store.routes.get());
        Assertions.assertNull((Object)this.store.getLastSeenSequenceId());
        ConsumerRecord<String, String> noKey = this.createRecord(1L, null, this.encodeValue(allowedNetworkIds));
        this.store.consume(noKey);
        Assertions.assertNull(this.store.routes.get());
        Assertions.assertNull((Object)this.store.getLastSeenSequenceId());
        ConsumerRecord<String, String> badKey = this.createRecord(1L, "ne-uuid=pkc-foo", this.encodeValue(allowedNetworkIds));
        this.store.consume(badKey);
        Assertions.assertNull(this.store.routes.get());
        Assertions.assertNull((Object)this.store.getLastSeenSequenceId());
        badKey = this.createRecord(1L, "network-foo:pkc-foo", this.encodeValue(allowedNetworkIds));
        this.store.consume(badKey);
        Assertions.assertNull(this.store.routes.get());
        Assertions.assertNull((Object)this.store.getLastSeenSequenceId());
        ConsumerRecord<String, String> noValue = this.createRecord(1L, "ne-uuid:pkc-foo", "foo");
        this.store.consume(noValue);
        Assertions.assertNull(this.store.routes.get());
        Assertions.assertEquals((long)1L, (Long)this.store.getLastSeenSequenceId());
    }

    @Test
    public void testForceDisconnectOneRoute() throws IOException {
        this.store.state.set(TopicBasedTrafficNetworkIdRoutesStore.State.RUNNING);
        String key = "ne-uuid:pkc-uuid";
        Assertions.assertNull((Object)this.store.getLastSeenSequenceId());
        this.store.consume(this.createRecord(1L, key, this.encodeValue(Collections.emptyList())));
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        Assertions.assertFalse((boolean)this.store.load().allows("nr1"));
        Assertions.assertFalse((boolean)this.store.load().allows("nr2"));
        this.store.consume(this.createRecord(2L, key, this.encodeValue(Arrays.asList("nr1"))));
        Assertions.assertTrue((boolean)this.store.load().allows("nr1"));
        Assertions.assertFalse((boolean)this.store.load().allows("nr2"));
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.store.consume(this.createRecord(3L, key, this.encodeValue(Collections.emptyList())));
        Assertions.assertEquals((int)1, (int)this.disallowedNetworks.size());
        Assertions.assertTrue((boolean)this.disallowedNetworks.contains("nr1"));
        Assertions.assertFalse((boolean)this.store.load().allows("nr1"));
        Assertions.assertFalse((boolean)this.store.load().allows("nr2"));
        this.disallowedNetworks.clear();
        this.store.consume(this.createRecord(4L, key, this.encodeValue(Collections.emptyList())));
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        Assertions.assertFalse((boolean)this.store.load().allows("nr1"));
        Assertions.assertFalse((boolean)this.store.load().allows("nr2"));
    }

    @Test
    public void testConsumeRoutes() throws IOException {
        this.store.state.set(TopicBasedTrafficNetworkIdRoutesStore.State.RUNNING);
        String key = "ne-uuid:pkc-uuid";
        Assertions.assertNull((Object)this.store.getLastSeenSequenceId());
        this.store.consume(this.createRecord(100L, key, this.encodeValue(Arrays.asList("nr1", "nr2"))));
        Assertions.assertTrue((boolean)this.store.load().allows("nr1"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr2"));
        this.store.consume(this.createRecord(99L, key, this.encodeValue(Arrays.asList("nr3"))));
        Assertions.assertFalse((boolean)this.store.load().allows("nr3"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr1"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr2"));
        Assertions.assertEquals((long)100L, (Long)this.store.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.store.consume(this.createRecord(100L, key, this.encodeValue(Arrays.asList("nr3"))));
        Assertions.assertFalse((boolean)this.store.load().allows("nr3"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr1"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr2"));
        Assertions.assertEquals((long)100L, (Long)this.store.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.store.consume(this.createRecord(101L, key, this.encodeValue(Arrays.asList("nr11"))));
        Assertions.assertTrue((boolean)this.store.load().allows("nr11"));
        Assertions.assertEquals((long)101L, (Long)this.store.getLastSeenSequenceId());
        Assertions.assertEquals((int)2, (int)this.disallowedNetworks.size());
        Assertions.assertTrue((boolean)this.disallowedNetworks.contains("nr1"));
        Assertions.assertTrue((boolean)this.disallowedNetworks.contains("nr2"));
        this.disallowedNetworks.clear();
        this.store.consume(this.createRecord(102L, key, null));
        Assertions.assertFalse((boolean)this.store.load().allows("nr11"));
        Assertions.assertFalse((boolean)this.store.load().allows("nr1"));
        Assertions.assertFalse((boolean)this.store.load().allows("nr2"));
        Assertions.assertEquals((long)102L, (Long)this.store.getLastSeenSequenceId());
        Assertions.assertEquals((int)1, (int)this.disallowedNetworks.size());
        Assertions.assertTrue((boolean)this.disallowedNetworks.contains("nr11"));
        this.disallowedNetworks.clear();
        this.store.consume(this.createRecord(101L, key, this.encodeValue(Arrays.asList("nr21"))));
        Assertions.assertFalse((boolean)this.store.load().allows("nr21"));
        Assertions.assertFalse((boolean)this.store.load().allows("nr11"));
        Assertions.assertEquals((long)102L, (Long)this.store.getLastSeenSequenceId());
        this.store.consume(this.createRecord(103L, key, this.encodeValue(Arrays.asList("nr31"))));
        Assertions.assertTrue((boolean)this.store.load().allows("nr31"));
        Assertions.assertEquals((long)103L, (Long)this.store.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.store.consume(this.createRecord(104L, key, "badJson"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr31"));
        Assertions.assertEquals((long)104L, (Long)this.store.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
        this.store.consume(this.createRecord(105L, key, "{}"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr31"));
        Assertions.assertEquals((long)105L, (Long)this.store.getLastSeenSequenceId());
        this.store.consume(this.createRecord(106L, key, this.encodeValueWithExtraFields(Arrays.asList("nr31", "nr1", "nr2"))));
        Assertions.assertTrue((boolean)this.store.load().allows("nr1"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr2"));
        Assertions.assertTrue((boolean)this.store.load().allows("nr31"));
        Assertions.assertEquals((long)106L, (Long)this.store.getLastSeenSequenceId());
        Assertions.assertTrue((boolean)this.disallowedNetworks.isEmpty());
    }

    private static class TestTrafficNetworkIdAllowedRoutes
    extends TrafficNetworkIdAllowedRoutes {
        public TestTrafficNetworkIdAllowedRoutes(List<String> allowedNetworkIds) {
            super(allowedNetworkIds);
        }

        @JsonProperty(value="fooProperty")
        public String fooProperty() {
            return "fooValue";
        }
    }
}

