/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestInvalidCompatibilityException;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestInvalidRuleSetException;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class ConfigResource {
    public static final String apiTag = "Config (v1)";
    private static final Logger log = LoggerFactory.getLogger(ConfigResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public ConfigResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @Path(value="/{subject}")
    @PUT
    @DocumentedName(value="updateSubjectConfig")
    @Operation(summary="Update subject compatibility level", description="Update compatibility level for the specified subject. On success, echoes the original request back to the client.", responses={@ApiResponse(responseCode="200", description="The original request.", content={@Content(schema=@Schema(implementation=ConfigUpdateRequest.class))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates subject not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="422", description="Unprocessable Entity. Error code 42203 indicates invalid compatibility level.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store. Error code 50003 indicates a failure forwarding the request to the primary.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Config (v1)")})
    @PerformanceMetric(value="config.update-subject")
    public ConfigUpdateRequest updateSubjectLevelConfig(@Parameter(description="Name of the subject", required=true) @PathParam(value="subject") String subject, @Context HttpHeaders headers, @Parameter(description="Config Update Request", required=true) @NotNull ConfigUpdateRequest request) {
        this.schemaRegistry.getCompositeUpdateRequestHandler().handle(subject, request);
        CompatibilityLevel compatibilityLevel = CompatibilityLevel.forName((String)request.getCompatibilityLevel());
        if (request.getCompatibilityLevel() != null && compatibilityLevel == null) {
            throw new RestInvalidCompatibilityException();
        }
        if (request.getDefaultRuleSet() != null) {
            try {
                request.getDefaultRuleSet().validate();
            }
            catch (RuleException e) {
                throw new RestInvalidRuleSetException(e.getMessage());
            }
        }
        if (request.getOverrideRuleSet() != null) {
            try {
                request.getOverrideRuleSet().validate();
            }
            catch (RuleException e) {
                throw new RestInvalidRuleSetException(e.getMessage());
            }
        }
        if (subject != null && !QualifiedSubject.isValidSubject((String)this.schemaRegistry.tenant(), (String)subject)) {
            throw Errors.invalidSubjectException(subject);
        }
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.updateConfigOrForward(subject, new Config(request), headerProperties);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to update compatibility level", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to update compatibility level", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding update config request to the leader", e);
        }
        return request;
    }

    @Path(value="/{subject}")
    @GET
    @DocumentedName(value="getSubjectConfig")
    @Operation(summary="Get subject compatibility level", description="Retrieves compatibility level for a subject.", responses={@ApiResponse(responseCode="200", description="The subject compatibility level.", content={@Content(schema=@Schema(implementation=Config.class))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates subject not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Config (v1)")})
    @PerformanceMetric(value="config.get-subject")
    public Config getSubjectLevelConfig(@Parameter(description="Name of the subject", required=true) @PathParam(value="subject") String subject, @Parameter(description="Whether to return the global compatibility level  if subject compatibility level not found") @QueryParam(value="defaultToGlobal") boolean defaultToGlobal) {
        Config config;
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            Config config2 = config = defaultToGlobal ? this.schemaRegistry.getConfigInScope(subject) : this.schemaRegistry.getConfig(subject);
            if (config == null) {
                throw Errors.subjectLevelCompatibilityNotConfiguredException(subject);
            }
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to get the configs for subject " + subject, e);
        }
        return config;
    }

    @PUT
    @DocumentedName(value="updateGlobalConfig")
    @Operation(summary="Update global compatibility level", description="Updates the global compatibility level. On success, echoes the original request back to the client.", responses={@ApiResponse(responseCode="200", description="The original request.", content={@Content(schema=@Schema(implementation=ConfigUpdateRequest.class))}), @ApiResponse(responseCode="422", description="Unprocessable Entity. Error code 42203 indicates invalid compatibility level.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store. Error code 50003 indicates a failure forwarding the request to the primary.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Config (v1)")})
    @PerformanceMetric(value="config.update-global")
    public ConfigUpdateRequest updateTopLevelConfig(@Context HttpHeaders headers, @Parameter(description="Config Update Request", required=true) @NotNull ConfigUpdateRequest request) {
        this.schemaRegistry.getCompositeUpdateRequestHandler().handle(request);
        CompatibilityLevel compatibilityLevel = CompatibilityLevel.forName((String)request.getCompatibilityLevel());
        if (request.getCompatibilityLevel() != null && compatibilityLevel == null) {
            throw new RestInvalidCompatibilityException();
        }
        if (request.getDefaultRuleSet() != null) {
            try {
                request.getDefaultRuleSet().validate();
            }
            catch (RuleException e) {
                throw new RestInvalidRuleSetException(e.getMessage());
            }
        }
        if (request.getOverrideRuleSet() != null) {
            try {
                request.getOverrideRuleSet().validate();
            }
            catch (RuleException e) {
                throw new RestInvalidRuleSetException(e.getMessage());
            }
        }
        try {
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.updateConfigOrForward(null, new Config(request), headerProperties);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to update compatibility level", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to update compatibility level", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding update config request to the leader", e);
        }
        return request;
    }

    @GET
    @DocumentedName(value="getGlobalConfig")
    @Operation(summary="Get global compatibility level", description="Retrieves the global compatibility level.", responses={@ApiResponse(responseCode="200", description="The global compatibility level.", content={@Content(schema=@Schema(implementation=Config.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Config (v1)")})
    @PerformanceMetric(value="config.get-global")
    public Config getTopLevelConfig() {
        Config config;
        try {
            config = this.schemaRegistry.getConfig(null);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to get compatibility level", e);
        }
        return config;
    }

    @DELETE
    @DocumentedName(value="deleteGlobalConfig")
    @Operation(summary="Delete global compatibility level", description="Deletes the global compatibility level config and reverts to the default.", responses={@ApiResponse(responseCode="200", description="Operation succeeded. Returns old global compatibility level.", content={@Content(schema=@Schema(implementation=CompatibilityLevel.class), examples={@ExampleObject(value="FULL_TRANSITIVE")})}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Config (v1)")})
    @PerformanceMetric(value="config.delete-global")
    public void deleteTopLevelConfig(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers) {
        Config deletedConfig;
        log.debug("Deleting Global compatibility setting and reverting back to default");
        try {
            deletedConfig = this.schemaRegistry.getConfig(null);
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.deleteConfigOrForward(null, headerProperties);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to delete compatibility level", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to delete compatibility level", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding delete config request to the leader", e);
        }
        asyncResponse.resume((Object)deletedConfig);
    }

    @DELETE
    @Path(value="/{subject}")
    @DocumentedName(value="deleteSubjectConfig")
    @Operation(summary="Delete subject compatibility level", description="Deletes the specified subject-level compatibility level config and reverts to the global default.", responses={@ApiResponse(responseCode="200", description="Operation succeeded. Returns old compatibility level.", content={@Content(schema=@Schema(implementation=CompatibilityLevel.class), examples={@ExampleObject(value="FULL_TRANSITIVE")})}), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates subject not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Config (v1)")})
    @PerformanceMetric(value="config.delete-subject")
    public void deleteSubjectConfig(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the subject", required=true) @PathParam(value="subject") String subject) {
        Config deletedConfig;
        log.debug("Deleting compatibility setting for subject {}", (Object)subject);
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            deletedConfig = this.schemaRegistry.getConfig(subject);
            if (deletedConfig == null) {
                throw Errors.subjectNotFoundException(subject);
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.deleteConfigOrForward(subject, headerProperties);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to delete compatibility level", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to delete compatibility level", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding delete config request to the leader", e);
        }
        asyncResponse.resume((Object)deletedConfig);
    }
}

