/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.concurrent;

import io.confluent.kafka.concurrent.MockEventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.utils.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

final class MockEventExecutorTest {
    private MockTime time;
    private MockEventExecutor executor;

    MockEventExecutorTest() {
    }

    @BeforeEach
    void setUp() {
        this.time = new MockTime();
        this.executor = new MockEventExecutor(this.time);
    }

    @Test
    void testSubmitRunnable() {
        AtomicBoolean executed = new AtomicBoolean(false);
        CompletableFuture<Void> future = this.executor.submit(() -> executed.set(true));
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertTrue((boolean)executed.get());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
    }

    @Test
    void testSubmitRunnableException() {
        CompletableFuture<Void> future = this.executor.submit(() -> {
            throw new RuntimeException();
        });
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        CompletionException exception = (CompletionException)Assertions.assertThrows(CompletionException.class, future::join);
        Assertions.assertEquals(RuntimeException.class, exception.getCause().getClass());
    }

    @Test
    void testSubmitCallable() {
        int expected = 42;
        CompletableFuture<Integer> future = this.executor.submit(() -> expected);
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        Assertions.assertEquals((int)expected, (Integer)future.join());
    }

    @Test
    void testScheduleRunnable() {
        AtomicBoolean executed = new AtomicBoolean(false);
        long delayMs = 100L;
        CompletableFuture<Void> future = this.executor.schedule(() -> executed.set(true), delayMs, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertFalse((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertFalse((boolean)future.isDone());
        this.time.sleep(delayMs - 1L);
        Assertions.assertFalse((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertFalse((boolean)future.isDone());
        this.time.sleep(1L);
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertTrue((boolean)executed.get());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
    }

    @Test
    void testScheduleCallable() {
        long delayMs = 100L;
        int expected = 42;
        CompletableFuture<Integer> future = this.executor.schedule(() -> expected, delayMs, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertFalse((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)future.isDone());
        this.time.sleep(delayMs - 1L);
        Assertions.assertFalse((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)future.isDone());
        this.time.sleep(1L);
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        Assertions.assertEquals((int)expected, (Integer)future.join());
    }

    @Test
    void testScheduleCallableException() {
        long delayMs = 100L;
        CompletableFuture<Integer> future = this.executor.schedule(() -> {
            throw new RuntimeException();
        }, delayMs, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertFalse((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)future.isDone());
        this.time.sleep(delayMs - 1L);
        Assertions.assertFalse((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)future.isDone());
        this.time.sleep(1L);
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        CompletionException exception = (CompletionException)Assertions.assertThrows(CompletionException.class, future::join);
        Assertions.assertEquals(RuntimeException.class, exception.getCause().getClass());
    }

    @Test
    void testCancelSubmit() {
        AtomicBoolean executed = new AtomicBoolean(false);
        CompletableFuture<Void> future = this.executor.submit(() -> executed.set(true));
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertFalse((boolean)future.isDone());
        future.cancel(false);
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
    }

    @Test
    void testCancelSchedule() {
        AtomicBoolean executed = new AtomicBoolean(false);
        long delayMs = 100L;
        CompletableFuture<Void> future = this.executor.schedule(() -> executed.set(true), delayMs, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertFalse((boolean)future.isDone());
        this.time.sleep(delayMs - 1L);
        Assertions.assertFalse((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertFalse((boolean)future.isDone());
        future.cancel(false);
        this.time.sleep(1L);
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertFalse((boolean)executed.get());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
    }

    @Test
    void testShutdown() {
        AtomicBoolean delayedExecuted = new AtomicBoolean(false);
        long delayMs = 100L;
        CompletableFuture<Void> delayed = this.executor.schedule(() -> delayedExecuted.set(true), delayMs, TimeUnit.MILLISECONDS);
        AtomicBoolean veryDelayedExecuted = new AtomicBoolean(false);
        long veryDelayMs = 2L * delayMs;
        CompletableFuture<Void> veryDelayed = this.executor.schedule(() -> veryDelayedExecuted.set(true), veryDelayMs, TimeUnit.MILLISECONDS);
        AtomicBoolean submittedExecuted = new AtomicBoolean(false);
        CompletableFuture<Void> submitted = this.executor.submit(() -> submittedExecuted.set(true));
        this.time.sleep(delayMs);
        Assertions.assertTrue((boolean)this.executor.poll());
        CompletableFuture<Void> shutdown = this.executor.shutdown();
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertTrue((boolean)delayedExecuted.get());
        Assertions.assertTrue((boolean)delayed.isDone());
        Assertions.assertFalse((boolean)delayed.isCancelled());
        Assertions.assertTrue((boolean)submittedExecuted.get());
        Assertions.assertTrue((boolean)submitted.isDone());
        Assertions.assertFalse((boolean)submitted.isCancelled());
        Assertions.assertFalse((boolean)veryDelayedExecuted.get());
        Assertions.assertFalse((boolean)veryDelayed.isDone());
        Assertions.assertFalse((boolean)veryDelayed.isCancelled());
        Assertions.assertFalse((boolean)veryDelayed.isCompletedExceptionally());
        Assertions.assertTrue((boolean)shutdown.isDone());
        Assertions.assertFalse((boolean)shutdown.isCancelled());
        Assertions.assertFalse((boolean)shutdown.isCompletedExceptionally());
    }

    @Test
    void testNoOpPoll() {
        Assertions.assertFalse((boolean)this.executor.poll());
    }
}

